/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class LifecycleBinding
/*     */ {
/*  36 */   protected String name = GUID.asString();
/*     */   protected AspectManager manager;
/*     */   private String classes;
/*     */   private String expr;
/*     */   private String callbackBean;
/*     */   private ControllerState state;
/*  42 */   private String installMethod = "install";
/*  43 */   private String uninstallMethod = "uninstall";
/*     */ 
/*     */   public void setClasses(String classes)
/*     */   {
/*  47 */     this.classes = classes;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  52 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public void setExpr(String classes)
/*     */   {
/*  57 */     this.expr = classes;
/*     */   }
/*     */ 
/*     */   public void setCallbackBean(String name)
/*     */   {
/*  62 */     this.callbackBean = name;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  67 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public void setState(ControllerState state)
/*     */   {
/*  72 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public void setInstallMethod(String installMethod)
/*     */   {
/*  77 */     this.installMethod = installMethod;
/*     */   }
/*     */ 
/*     */   public void setUninstallMethod(String uninstallMethod)
/*     */   {
/*  82 */     this.uninstallMethod = uninstallMethod;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  87 */     if ((this.expr == null) && (this.classes == null))
/*  88 */       throw new IllegalArgumentException("Null classes and null expr");
/*  89 */     if ((this.expr != null) && (this.classes != null))
/*  90 */       throw new IllegalArgumentException("Both classes and expr were set");
/*  91 */     if (this.manager == null)
/*  92 */       throw new IllegalArgumentException("Null manager");
/*  93 */     if (this.callbackBean == null)
/*  94 */       throw new IllegalArgumentException("Null callback bean");
/*  95 */     if (this.state == null) {
/*  96 */       throw new IllegalArgumentException("Null controller state");
/*     */     }
/*  98 */     LifecycleCallbackBinding binding = new LifecycleCallbackBinding(this.name, this.classes, this.expr, this.state);
/*  99 */     binding.addLifecycleCallback(this.callbackBean, this.installMethod, this.uninstallMethod);
/* 100 */     this.manager.addLifecycleBinding(binding);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 106 */     this.manager.removeLifecycleBinding(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.LifecycleBinding
 * JD-Core Version:    0.6.0
 */