/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceFactory;
/*     */ import org.jboss.aop.advice.AdviceType;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.aop.advice.ScopedInterceptorFactory;
/*     */ 
/*     */ public class InterceptorEntry extends BindingEntry
/*     */   implements Cloneable
/*     */ {
/*     */   Aspect aspect;
/*     */   String aspectMethod;
/*     */   InterceptorFactory interceptorFactory;
/*     */   boolean forStack;
/*  41 */   AdviceType type = AdviceType.AROUND;
/*     */ 
/*     */   public AdviceType getType()
/*     */   {
/*  45 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(AdviceType type)
/*     */   {
/*  50 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public Aspect getAspect(Aspect aspect)
/*     */   {
/*  55 */     return aspect;
/*     */   }
/*     */ 
/*     */   public void setAspect(Aspect aspect)
/*     */   {
/*  60 */     this.aspect = aspect;
/*     */   }
/*     */ 
/*     */   public void setForStack(boolean forStack)
/*     */   {
/*  65 */     this.forStack = forStack;
/*     */   }
/*     */ 
/*     */   public String getAspectMethod()
/*     */   {
/*  70 */     return this.aspectMethod;
/*     */   }
/*     */ 
/*     */   public void setAspectMethod(String aspectMethod)
/*     */   {
/*  75 */     this.aspectMethod = aspectMethod;
/*     */   }
/*     */ 
/*     */   public InterceptorFactory[] getInterceptorFactories()
/*     */   {
/*  80 */     return new InterceptorFactory[] { this.interceptorFactory };
/*     */   }
/*     */ 
/*     */   public InterceptorFactory getInterceptorFactory()
/*     */   {
/*  85 */     return this.interceptorFactory;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  90 */     if (this.manager == null)
/*     */     {
/*  92 */       throw new IllegalArgumentException("Null manager");
/*     */     }
/*  94 */     if ((this.binding == null) && (!this.forStack))
/*     */     {
/*  96 */       throw new IllegalArgumentException("Null aspect binding");
/*     */     }
/*  98 */     if (this.aspect == null)
/*     */     {
/* 100 */       throw new IllegalArgumentException("Null aspect");
/*     */     }
/* 102 */     this.interceptorFactory = (this.aspectMethod == null ? new ScopedInterceptorFactory(this.aspect.getDefinition()) : new AdviceFactory(this.aspect.getDefinition(), this.aspectMethod));
/*     */ 
/* 105 */     this.manager.addInterceptorFactory(this.name, this.interceptorFactory);
/* 106 */     if (this.binding != null)
/*     */     {
/* 108 */       this.aspect.addBinding(this.binding);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 114 */     this.manager.removeInterceptorFactory(this.name);
/* 115 */     if (this.binding != null)
/*     */     {
/* 117 */       this.aspect.removeBinding(this.binding);
/*     */     }
/* 119 */     this.interceptorFactory = null;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 124 */     InterceptorEntry entry = new InterceptorEntry();
/* 125 */     entry.manager = this.manager;
/* 126 */     entry.binding = this.binding;
/* 127 */     entry.aspect = this.aspect;
/* 128 */     entry.aspectMethod = this.aspectMethod;
/* 129 */     return entry;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.InterceptorEntry
 * JD-Core Version:    0.6.0
 */