/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
/*    */ import org.jboss.beans.metadata.spi.factory.BeanFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class GenericBeanAspectFactory
/*    */   implements AspectFactory
/*    */ {
/* 40 */   private static final Logger log = Logger.getLogger(GenericBeanAspectFactory.class);
/*    */   protected BeanFactory factory;
/*    */   protected String name;
/*    */ 
/*    */   public GenericBeanAspectFactory(String name, BeanFactory factory)
/*    */   {
/* 48 */     this.name = name;
/* 49 */     this.factory = factory;
/*    */   }
/*    */ 
/*    */   public void setBeanFactory(GenericBeanFactory factory)
/*    */   {
/* 54 */     this.factory = factory;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 59 */     return this.name;
/*    */   }
/*    */ 
/*    */   public Object createPerVM()
/*    */   {
/* 64 */     return doCreate();
/*    */   }
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 69 */     return doCreate();
/*    */   }
/*    */ 
/*    */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*    */   {
/* 74 */     return doCreate();
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*    */   {
/* 79 */     return doCreate();
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*    */   {
/* 84 */     return doCreate();
/*    */   }
/*    */ 
/*    */   protected Object doCreate()
/*    */   {
/*    */     try
/*    */     {
/* 91 */       log.debug("Creating advice " + this.name);
/* 92 */       return this.factory.createBean();
/*    */     }
/*    */     catch (Throwable throwable) {
/*    */     }
/* 96 */     throw new RuntimeException(throwable);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.GenericBeanAspectFactory
 * JD-Core Version:    0.6.0
 */