/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.advice.AspectFactory;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
/*     */ import org.jboss.beans.metadata.spi.factory.BeanFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DelegatingBeanAspectFactory
/*     */   implements AspectFactory
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(GenericBeanAspectFactory.class);
/*     */   protected BeanFactory factory;
/*     */   protected String name;
/*     */ 
/*     */   public DelegatingBeanAspectFactory(String name, BeanFactory factory)
/*     */   {
/*  47 */     this.name = name;
/*  48 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public void setBeanFactory(GenericBeanFactory factory)
/*     */   {
/*  53 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  58 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Object createPerVM()
/*     */   {
/*  63 */     AspectFactory factory = doCreate();
/*  64 */     return factory.createPerVM();
/*     */   }
/*     */ 
/*     */   public Object createPerClass(Advisor advisor)
/*     */   {
/*  69 */     AspectFactory factory = doCreate();
/*  70 */     return factory.createPerClass(advisor);
/*     */   }
/*     */ 
/*     */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*     */   {
/*  75 */     AspectFactory factory = doCreate();
/*  76 */     return factory.createPerInstance(advisor, instanceAdvisor);
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*     */   {
/*  81 */     AspectFactory factory = doCreate();
/*  82 */     return factory.createPerJoinpoint(advisor, jp);
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*     */   {
/*  87 */     AspectFactory factory = doCreate();
/*  88 */     return factory.createPerJoinpoint(advisor, instanceAdvisor, jp);
/*     */   }
/*     */ 
/*     */   protected AspectFactory doCreate()
/*     */   {
/*     */     try
/*     */     {
/*  95 */       log.debug("Creating advice " + this.name);
/*  96 */       return (AspectFactory)this.factory.createBean();
/*     */     }
/*     */     catch (Throwable throwable) {
/*     */     }
/* 100 */     throw new RuntimeException(throwable);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.DelegatingBeanAspectFactory
 * JD-Core Version:    0.6.0
 */