/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import org.jboss.aop.AspectManager;
/*    */ 
/*    */ public class ClassMetaDataLoader
/*    */ {
/*    */   AspectManager manager;
/*    */   String tag;
/*    */   String className;
/*    */ 
/*    */   public AspectManager getManager()
/*    */   {
/* 39 */     return this.manager;
/*    */   }
/*    */ 
/*    */   public void setManager(AspectManager manager)
/*    */   {
/* 44 */     this.manager = manager;
/*    */   }
/*    */ 
/*    */   public String getTag()
/*    */   {
/* 49 */     return this.tag;
/*    */   }
/*    */ 
/*    */   public void setTag(String tag)
/*    */   {
/* 54 */     this.tag = tag;
/*    */   }
/*    */ 
/*    */   public String getClassName()
/*    */   {
/* 59 */     return this.className;
/*    */   }
/*    */ 
/*    */   public void setClassName(String className)
/*    */   {
/* 64 */     this.className = className;
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/* 69 */     if (this.manager == null)
/* 70 */       throw new IllegalArgumentException("Null manager");
/* 71 */     if (this.tag == null)
/* 72 */       throw new IllegalArgumentException("Null tag");
/* 73 */     if (this.className == null) {
/* 74 */       throw new IllegalArgumentException("Null className");
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 79 */       ClassLoader cl = SecurityActions.getContextClassLoader();
/* 80 */       Class clazz = cl.loadClass(this.className);
/* 81 */       org.jboss.aop.metadata.ClassMetaDataLoader loader = (org.jboss.aop.metadata.ClassMetaDataLoader)clazz.newInstance();
/*    */ 
/* 83 */       this.manager.addClassMetaDataLoader(this.tag, loader);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 87 */       throw new RuntimeException(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 93 */     this.manager.removeClassMetaDataLoader(this.tag);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.ClassMetaDataLoader
 * JD-Core Version:    0.6.0
 */