/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*     */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*     */ import org.jboss.util.id.GUID;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ClassMetaData
/*     */ {
/*     */   AspectManager manager;
/*  38 */   String name = GUID.asString();
/*     */   String tag;
/*     */   String className;
/*     */   Element element;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  48 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  53 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  58 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  63 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getTag()
/*     */   {
/*  68 */     return this.tag;
/*     */   }
/*     */ 
/*     */   public void setTag(String tag)
/*     */   {
/*  73 */     this.tag = tag;
/*     */   }
/*     */ 
/*     */   public String getClassName()
/*     */   {
/*  78 */     return this.className;
/*     */   }
/*     */ 
/*     */   public void setClassName(String className)
/*     */   {
/*  83 */     this.className = className;
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/*  88 */     return this.element;
/*     */   }
/*     */ 
/*     */   public void setElement(Element element)
/*     */   {
/*  93 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  98 */     if (this.manager == null)
/*  99 */       throw new IllegalArgumentException("Null manager");
/* 100 */     if (this.tag == null)
/* 101 */       throw new IllegalArgumentException("Null tag");
/* 102 */     if (this.className == null) {
/* 103 */       throw new IllegalArgumentException("Null className");
/*     */     }
/* 105 */     ClassMetaDataLoader loader = this.manager.findClassMetaDataLoader(this.tag);
/*     */     try
/*     */     {
/* 108 */       ClassMetaDataBinding data = loader.importMetaData(this.element, this.name, this.tag, this.className);
/* 109 */       this.manager.addClassMetaData(data);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 114 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 120 */     this.manager.removeClassMetaData(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.ClassMetaData
 * JD-Core Version:    0.6.0
 */