/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.CFlow;
/*     */ 
/*     */ public class CFlowStack
/*     */ {
/*     */   private AspectManager manager;
/*     */   private String name;
/*     */   private List<CFlowStackEntry> entries;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  54 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  59 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  64 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  69 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public List<CFlowStackEntry> getEntries()
/*     */   {
/*  74 */     return this.entries;
/*     */   }
/*     */ 
/*     */   public void setEntries(List<CFlowStackEntry> entries)
/*     */   {
/*  79 */     this.entries = entries;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  84 */     if ((this.name == null) || (this.name.length() == 0))
/*     */     {
/*  86 */       throw new IllegalArgumentException("Null name");
/*     */     }
/*  88 */     if ((this.entries == null) || (this.entries.size() == 0))
/*     */     {
/*  90 */       throw new IllegalArgumentException("No entries");
/*     */     }
/*     */ 
/*  93 */     org.jboss.aop.pointcut.CFlowStack stack = new org.jboss.aop.pointcut.CFlowStack(this.name);
/*  94 */     for (CFlowStackEntry entry : this.entries)
/*     */     {
/*  96 */       boolean notCalled = !entry.getCalled();
/*  97 */       stack.addCFlow(new CFlow(entry.getExpr(), notCalled));
/*     */     }
/*  99 */     this.manager.addCFlowStack(stack);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 104 */     this.manager.removeCFlowStack(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.CFlowStack
 * JD-Core Version:    0.6.0
 */