/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceBinding;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class AspectBinding
/*     */   implements Binding
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(AspectBinding.class);
/*     */   protected AspectManager manager;
/*  45 */   protected String name = GUID.asString();
/*     */   protected String pointcut;
/*     */   protected List<BindingEntry> advices;
/*     */   protected String cflow;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  59 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  69 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getCflow()
/*     */   {
/*  75 */     return this.cflow;
/*     */   }
/*     */ 
/*     */   public void setCflow(String cflow)
/*     */   {
/*  80 */     this.cflow = cflow;
/*     */   }
/*     */ 
/*     */   public String getPointcut()
/*     */   {
/*  90 */     return this.pointcut;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  95 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 100 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public void setPointcut(String pointcut)
/*     */   {
/* 110 */     this.pointcut = pointcut;
/*     */   }
/*     */ 
/*     */   public List<BindingEntry> getAdvices()
/*     */   {
/* 115 */     return this.advices;
/*     */   }
/*     */ 
/*     */   public void setAdvices(List<BindingEntry> advices)
/*     */   {
/* 120 */     this.advices = advices;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 125 */     if (this.pointcut == null)
/* 126 */       throw new IllegalArgumentException("Null pointcut");
/* 127 */     if (this.manager == null)
/* 128 */       throw new IllegalArgumentException("Null manager");
/* 129 */     AdviceBinding binding = new AdviceBinding(this.name, this.pointcut, this.cflow);
/*     */ 
/* 131 */     if (this.advices != null)
/*     */     {
/* 133 */       for (BindingEntry entry : this.advices)
/*     */       {
/* 135 */         entry.start();
/* 136 */         InterceptorFactory[] factories = entry.getInterceptorFactories();
/* 137 */         for (InterceptorFactory ifac : factories)
/*     */         {
/* 139 */           binding.addInterceptorFactory(ifac);
/*     */         }
/*     */       }
/*     */     }
/* 143 */     this.manager.addBinding(binding);
/* 144 */     log.debug("Bound binding " + this.name);
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 149 */     this.manager.removeBinding(this.name);
/* 150 */     if (this.advices != null)
/*     */     {
/* 152 */       for (BindingEntry entry : this.advices)
/*     */       {
/* 154 */         entry.stop();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstall() throws Exception
/*     */   {
/* 161 */     stop();
/*     */   }
/*     */ 
/*     */   public void rebind() throws Exception
/*     */   {
/* 166 */     stop();
/* 167 */     start();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.AspectBinding
 * JD-Core Version:    0.6.0
 */