/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.advice.AspectFactory;
/*     */ import org.jboss.aop.advice.AspectFactoryDelegator;
/*     */ import org.jboss.aop.advice.GenericAspectFactory;
/*     */ import org.jboss.aop.advice.Scope;
/*     */ import org.jboss.aop.advice.ScopeUtil;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.kernel.spi.dependency.ConfigureKernelControllerContextAware;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class Aspect
/*     */   implements ConfigureKernelControllerContextAware, Untransformable
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(Aspect.class);
/*     */   protected AspectManager manager;
/*  59 */   protected String adviceName = GUID.asString();
/*     */   protected boolean factory;
/*     */   protected Scope scope;
/*     */   protected ManagedAspectDefinition definition;
/*     */   protected GenericBeanFactory advice;
/*     */   protected String adviceBean;
/*     */   protected ControllerContext context;
/*     */   protected String myname;
/*     */   protected String aspectDefName;
/* 102 */   protected Map<String, Binding> bindings = new LinkedHashMap();
/*     */ 
/*     */   public String getAdviceName()
/*     */   {
/* 111 */     return this.adviceName;
/*     */   }
/*     */ 
/*     */   public void setFactory(boolean factory)
/*     */   {
/* 119 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public void setAdviceName(String adviceName)
/*     */   {
/* 129 */     this.adviceName = adviceName;
/*     */   }
/*     */ 
/*     */   public String getAdviceBean()
/*     */   {
/* 139 */     return this.adviceBean;
/*     */   }
/*     */ 
/*     */   public void setAdviceBean(String adviceBean)
/*     */   {
/* 149 */     this.adviceBean = adviceBean;
/*     */   }
/*     */ 
/*     */   public AspectDefinition getDefinition()
/*     */   {
/* 159 */     return this.definition;
/*     */   }
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/* 169 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/* 179 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public GenericBeanFactory getAdvice()
/*     */   {
/* 189 */     return this.advice;
/*     */   }
/*     */ 
/*     */   public void setAdvice(GenericBeanFactory advice)
/*     */   {
/* 199 */     this.advice = advice;
/*     */   }
/*     */ 
/*     */   public String getScope()
/*     */   {
/* 209 */     return this.scope.toString();
/*     */   }
/*     */ 
/*     */   public void setScope(String scope)
/*     */   {
/* 219 */     this.scope = ScopeUtil.parse(scope);
/*     */   }
/*     */ 
/*     */   public void setKernelControllerContext(KernelControllerContext context) throws Exception
/*     */   {
/* 224 */     this.myname = ((String)context.getName());
/* 225 */     this.context = context;
/*     */   }
/*     */ 
/*     */   public void unsetKernelControllerContext(KernelControllerContext context) throws Exception
/*     */   {
/* 230 */     this.context = null;
/*     */   }
/*     */ 
/*     */   public void install(GenericBeanFactory factory) throws Exception
/*     */   {
/* 235 */     this.advice = factory;
/* 236 */     start();
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 241 */     if (this.definition == null)
/*     */     {
/* 243 */       this.aspectDefName = (this.adviceBean != null ? this.adviceBean : this.myname);
/* 244 */       if (this.manager == null)
/* 245 */         throw new IllegalArgumentException("Null manager");
/* 246 */       if (this.advice != null)
/*     */       {
/* 248 */         this.definition = getAspectDefinitionNoDependencies();
/*     */       }
/* 250 */       else if ((this.adviceBean != null) && (this.context.getController() != null))
/*     */       {
/* 252 */         this.definition = getAspectDefintionDependencies();
/*     */       }
/*     */       else
/*     */       {
/* 257 */         this.definition = getAspectDefinitionPlainAspectFactory();
/*     */       }
/* 259 */       addDefinitionToManager();
/*     */     }
/*     */ 
/* 262 */     if ((this.adviceBean != null) && (this.advice != null))
/*     */     {
/* 264 */       this.definition.setDeployed(true);
/* 265 */       GenericBeanAspectFactory factory = (GenericBeanAspectFactory)this.definition.getFactory();
/* 266 */       factory.setBeanFactory(this.advice);
/*     */     }
/*     */ 
/* 270 */     ArrayList clonedBindings = new ArrayList();
/* 271 */     for (Binding aspectBinding : this.bindings.values())
/*     */     {
/* 273 */       clonedBindings.add(aspectBinding);
/*     */     }
/*     */ 
/* 276 */     for (Binding binding : clonedBindings)
/*     */     {
/* 278 */       binding.rebind();
/*     */     }
/*     */ 
/* 281 */     log.debug("Bound aspect " + this.aspectDefName + "; deployed:" + this.definition.isDeployed());
/*     */   }
/*     */ 
/*     */   protected ManagedAspectDefinition getAspectDefinitionNoDependencies()
/*     */   {
/* 286 */     AspectFactory factory = this.factory ? new DelegatingBeanAspectFactory(this.adviceName, this.advice) : new GenericBeanAspectFactory(this.adviceName, this.advice);
/*     */ 
/* 288 */     return new ManagedAspectDefinition(this.aspectDefName, this.scope, factory);
/*     */   }
/*     */ 
/*     */   protected ManagedAspectDefinition getAspectDefintionDependencies()
/*     */   {
/* 293 */     AspectFactory factory = this.factory ? new DelegatingBeanAspectFactory(this.aspectDefName, this.advice) : new GenericBeanAspectFactory(this.aspectDefName, this.advice);
/*     */ 
/* 295 */     return new ManagedAspectDefinition(this.aspectDefName, this.scope, factory, false);
/*     */   }
/*     */ 
/*     */   protected ManagedAspectDefinition getAspectDefinitionPlainAspectFactory()
/*     */   {
/* 300 */     AspectFactory factory = this.factory ? new AspectFactoryDelegator(this.adviceName, null) : new GenericAspectFactory(this.adviceName, null);
/*     */ 
/* 302 */     return new ManagedAspectDefinition(this.aspectDefName, this.scope, factory);
/*     */   }
/*     */ 
/*     */   protected void addDefinitionToManager()
/*     */   {
/* 307 */     this.manager.addAspectDefinition(this.definition);
/*     */   }
/*     */ 
/*     */   public void uninstall() throws Exception
/*     */   {
/* 312 */     stop();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 318 */     this.aspectDefName = (this.adviceBean != null ? this.adviceBean : this.myname);
/* 319 */     log.debug("Unbinding aspect " + this.aspectDefName);
/* 320 */     this.manager.removeAspectDefinition(this.aspectDefName);
/* 321 */     if (this.definition != null)
/*     */     {
/* 323 */       this.definition.undeploy();
/* 324 */       this.definition = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   void addBinding(Binding binding)
/*     */   {
/* 330 */     this.bindings.put(binding.getName(), binding);
/*     */   }
/*     */ 
/*     */   void removeBinding(Binding binding)
/*     */   {
/* 335 */     this.bindings.remove(binding.getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.Aspect
 * JD-Core Version:    0.6.0
 */