/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class ArrayReplacement
/*     */ {
/*     */   AspectManager manager;
/*  40 */   String name = GUID.asString();
/*     */   String classes;
/*     */   String expr;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  46 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  51 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  56 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  61 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getClasses()
/*     */   {
/*  66 */     return this.classes;
/*     */   }
/*     */ 
/*     */   public void setClasses(String classes)
/*     */   {
/*  71 */     this.classes = classes;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  76 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public void setExpr(String expr)
/*     */   {
/*  81 */     this.expr = expr;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  86 */     if (this.manager == null)
/*     */     {
/*  88 */       throw new IllegalArgumentException("Null manager");
/*     */     }
/*  90 */     if ((this.classes == null) && (this.expr == null))
/*     */     {
/*  92 */       throw new IllegalArgumentException("Must define either expr or classes");
/*     */     }
/*  94 */     if ((this.classes != null) && (this.expr != null))
/*     */     {
/*  96 */       throw new IllegalArgumentException("Cannot define both expr and classes");
/*     */     }
/*     */ 
/*  99 */     org.jboss.aop.array.ArrayReplacement pcut = null;
/* 100 */     if (this.classes != null)
/*     */     {
/* 102 */       pcut = new org.jboss.aop.array.ArrayReplacement(this.name, this.classes);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 108 */         ASTStart start = new TypeExpressionParser(new StringReader(this.expr)).Start();
/* 109 */         pcut = new org.jboss.aop.array.ArrayReplacement(this.name, start);
/*     */       }
/*     */       catch (ParseException e)
/*     */       {
/* 113 */         throw new IllegalArgumentException("Could not parse type expression " + this.expr, e);
/*     */       }
/*     */     }
/* 116 */     this.manager.addArrayReplacement(pcut);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 122 */     this.manager.removeArrayReplacement(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.ArrayReplacement
 * JD-Core Version:    0.6.0
 */