/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.aop.array.Type;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class ArrayBinding
/*     */   implements Binding
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(ArrayBinding.class);
/*     */   AspectManager manager;
/*  42 */   String name = GUID.asString();
/*     */   String type;
/*     */   List<BindingEntry> advices;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  48 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  53 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  58 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  63 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/*  68 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/*  73 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public List<BindingEntry> getAdvices()
/*     */   {
/*  78 */     return this.advices;
/*     */   }
/*     */ 
/*     */   public void setAdvices(List<BindingEntry> advices)
/*     */   {
/*  83 */     this.advices = advices;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  88 */     if (this.manager == null)
/*     */     {
/*  90 */       throw new IllegalArgumentException("Null manager");
/*     */     }
/*  92 */     if (this.type == null)
/*     */     {
/*  94 */       throw new IllegalArgumentException("Null type");
/*     */     }
/*  96 */     Type theType = Type.valueOf(this.type);
/*     */ 
/*  98 */     ArrayList interceptors = null;
/*  99 */     if (this.advices != null)
/*     */     {
/* 101 */       interceptors = new ArrayList();
/* 102 */       int i = 0;
/* 103 */       for (BindingEntry entry : this.advices)
/*     */       {
/* 105 */         entry.start();
/* 106 */         InterceptorFactory[] factories = entry.getInterceptorFactories();
/* 107 */         for (InterceptorFactory ifac : factories)
/*     */         {
/* 109 */           interceptors.add(ifac);
/*     */         }
/*     */       }
/*     */     }
/* 113 */     InterceptorFactory[] facs = interceptors != null ? (InterceptorFactory[])interceptors.toArray(new InterceptorFactory[interceptors.size()]) : new InterceptorFactory[0];
/* 114 */     org.jboss.aop.array.ArrayBinding binding = new org.jboss.aop.array.ArrayBinding(this.name, facs, theType);
/* 115 */     this.manager.addArrayBinding(binding);
/* 116 */     log.debug("Bound array binding " + this.name);
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 121 */     this.manager.removeArrayBinding(this.name);
/* 122 */     if (this.advices != null)
/*     */     {
/* 124 */       for (BindingEntry entry : this.advices)
/*     */       {
/* 126 */         entry.stop();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstall() throws Exception
/*     */   {
/* 133 */     stop();
/*     */   }
/*     */ 
/*     */   public void rebind() throws Exception
/*     */   {
/* 138 */     stop();
/* 139 */     start();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.ArrayBinding
 * JD-Core Version:    0.6.0
 */