/*     */ package org.jboss.aop.microcontainer.aspects.jndi;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Properties;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class JndiIntroduction
/*     */   implements Interceptor
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(JndiIntroduction.class);
/*     */   private Properties env;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  52 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Properties getEnv()
/*     */   {
/*  61 */     return this.env;
/*     */   }
/*     */ 
/*     */   public void setEnv(Properties env)
/*     */   {
/*  70 */     this.env = env;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  79 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  80 */     KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
/*     */ 
/*  82 */     boolean trace = log.isTraceEnabled();
/*  83 */     JndiBinding bindingInfo = (JndiBinding)invocation.resolveClassAnnotation(JndiBinding.class);
/*  84 */     if (trace) {
/*  85 */       log.trace("Checking method: " + mi.getMethod() + ", bindingInfo: " + bindingInfo);
/*     */     }
/*  87 */     if (("setKernelControllerContext".equals(mi.getMethod().getName())) && (bindingInfo != null))
/*     */     {
/*  89 */       InitialContext ctx = new InitialContext(this.env);
/*  90 */       Object target = context.getTarget();
/*  91 */       Util.bind(ctx, bindingInfo.name(), target);
/*  92 */       if (trace)
/*  93 */         log.trace("Bound to: " + bindingInfo.name());
/*  94 */       String[] aliases = bindingInfo.aliases();
/*  95 */       if (aliases != null)
/*     */       {
/*  97 */         for (String name : aliases)
/*     */         {
/*  99 */           Util.bind(ctx, name, target);
/* 100 */           if (trace) {
/* 101 */             log.trace("Bound to alias: " + bindingInfo.name());
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 106 */     else if (bindingInfo != null)
/*     */     {
/* 108 */       InitialContext ctx = new InitialContext(this.env);
/* 109 */       Util.unbind(ctx, bindingInfo.name());
/* 110 */       if (trace)
/* 111 */         log.trace("Unbound: " + bindingInfo.name());
/* 112 */       String[] aliases = bindingInfo.aliases();
/* 113 */       if (aliases != null)
/*     */       {
/* 115 */         for (String name : aliases)
/*     */         {
/* 117 */           Util.unbind(ctx, name);
/* 118 */           if (trace)
/* 119 */             log.trace("Unbound alias: " + bindingInfo.name());
/*     */         }
/*     */       }
/*     */     }
/* 123 */     else if (trace)
/*     */     {
/* 125 */       log.trace("Ignoring null binding info");
/*     */     }
/*     */ 
/* 128 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.aspects.jndi.JndiIntroduction
 * JD-Core Version:    0.6.0
 */