/*     */ package org.jboss.aop.microcontainer.aspects.jmx;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.StandardMBean;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ public class JMXLifecycleCallback
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(JMXLifecycleCallback.class);
/*     */   private MBeanServer server;
/*     */ 
/*     */   public void setMbeanServer(MBeanServer server)
/*     */   {
/*  44 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void install(ControllerContext context) throws Exception
/*     */   {
/*  49 */     validateServer();
/*  50 */     JMX jmx = readJmxAnnotation(context);
/*  51 */     ObjectName objectName = createObjectName(context, jmx);
/*     */ 
/*  53 */     Class intfClass = null;
/*  54 */     boolean registerDirectly = false;
/*  55 */     if (jmx != null)
/*     */     {
/*  57 */       intfClass = jmx.exposedInterface();
/*  58 */       registerDirectly = jmx.registerDirectly();
/*     */     }
/*  60 */     Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
/*     */ 
/*  62 */     this.server.registerMBean(mbean, objectName);
/*  63 */     log.debug("Registered MBean " + objectName);
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerContext context) throws Exception
/*     */   {
/*  68 */     validateServer();
/*  69 */     JMX jmx = readJmxAnnotation(context);
/*  70 */     ObjectName objectName = createObjectName(context, jmx);
/*     */ 
/*  72 */     log.debug("Unregistering MBean " + objectName);
/*  73 */     this.server.unregisterMBean(objectName);
/*     */   }
/*     */ 
/*     */   private void validateServer()
/*     */   {
/*  78 */     if (this.server == null)
/*     */     {
/*  80 */       throw new RuntimeException("No MBeanServer was injected");
/*     */     }
/*     */   }
/*     */ 
/*     */   private JMX readJmxAnnotation(ControllerContext context) throws Exception
/*     */   {
/*  86 */     MetaData metaData = context.getScopeInfo().getMetaData();
/*  87 */     if (metaData != null)
/*  88 */       return (JMX)metaData.getAnnotation(JMX.class);
/*  89 */     return null;
/*     */   }
/*     */ 
/*     */   private ObjectName createObjectName(ControllerContext context, JMX jmx) throws Exception
/*     */   {
/*  94 */     ObjectName objectName = null;
/*  95 */     if (jmx != null)
/*     */     {
/*  97 */       String jmxName = jmx.name();
/*  98 */       if ((jmxName != null) && (jmxName.length() > 0)) {
/*  99 */         objectName = new ObjectName(jmxName);
/*     */       }
/*     */     }
/* 102 */     if (objectName == null)
/*     */     {
/* 105 */       String name = (String)context.getName();
/*     */ 
/* 107 */       if (name.contains(":"))
/*     */       {
/* 109 */         objectName = new ObjectName(name);
/*     */       }
/*     */       else
/*     */       {
/* 113 */         objectName = new ObjectName("test:name='" + name + "'");
/*     */       }
/*     */     }
/*     */ 
/* 117 */     return objectName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.aspects.jmx.JMXLifecycleCallback
 * JD-Core Version:    0.6.0
 */