/*     */ package org.jboss.aop.microcontainer.aspects.jmx;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.StandardMBean;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class JMXIntroduction
/*     */   implements Interceptor
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(JMXIntroduction.class);
/*     */   private MBeanServer server;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  51 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer server)
/*     */   {
/*  56 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  61 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  62 */     KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
/*     */ 
/*  64 */     JMX jmx = (JMX)invocation.resolveClassAnnotation(JMX.class);
/*     */ 
/*  66 */     ObjectName objectName = null;
/*  67 */     if (jmx != null)
/*     */     {
/*  69 */       String jmxName = jmx.name();
/*  70 */       if ((jmxName != null) && (jmxName.length() > 0)) {
/*  71 */         objectName = new ObjectName(jmxName);
/*     */       }
/*     */     }
/*  74 */     if (objectName == null)
/*     */     {
/*  77 */       String name = (String)context.getName();
/*     */ 
/*  79 */       if (name.contains(":"))
/*     */       {
/*  81 */         objectName = new ObjectName(name);
/*     */       }
/*     */       else
/*     */       {
/*  85 */         objectName = new ObjectName("test:name='" + name + "'");
/*     */       }
/*     */     }
/*     */ 
/*  89 */     if (this.server == null)
/*     */     {
/*  91 */       throw new RuntimeException("No MBeanServer was injected");
/*     */     }
/*     */ 
/*  94 */     if ("setKernelControllerContext".equals(mi.getMethod().getName()))
/*     */     {
/*  96 */       Class intfClass = null;
/*  97 */       boolean registerDirectly = false;
/*  98 */       if (jmx != null)
/*     */       {
/* 100 */         intfClass = jmx.exposedInterface();
/* 101 */         registerDirectly = jmx.registerDirectly();
/*     */       }
/* 103 */       Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
/*     */ 
/* 105 */       this.server.registerMBean(mbean, objectName);
/* 106 */       log.info("Registered MBean " + objectName);
/*     */     }
/*     */     else
/*     */     {
/* 110 */       log.info("Unregistering MBean " + objectName);
/* 111 */       this.server.unregisterMBean(objectName);
/*     */     }
/*     */ 
/* 114 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.aspects.jmx.JMXIntroduction
 * JD-Core Version:    0.6.0
 */