/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javassist.CtMethod;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aop.util.UnmodifiableEmptyCollections;
/*     */ 
/*     */ public class MethodMetaData
/*     */   implements MetaDataResolver
/*     */ {
/*  42 */   volatile Map methodMetaData = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*     */   HashMap inexactMatches;
/*     */ 
/*     */   public boolean hasTag(String group)
/*     */   {
/*  47 */     Iterator values = this.methodMetaData.values().iterator();
/*  48 */     while (values.hasNext())
/*     */     {
/*  50 */       SimpleMetaData map = (SimpleMetaData)values.next();
/*  51 */       if (map.hasTag(group)) return true;
/*     */     }
/*  53 */     return false;
/*     */   }
/*     */ 
/*     */   public void tagMethod(Method method, Object tag) {
/*  57 */     addMethodMetaData(method, tag, "$tagged$", new Object(), PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public void addMethodMetaData(Method method, Object tag, Object attr, Object value) {
/*  61 */     addMethodMetaData(method, tag, attr, value, PayloadKey.MARSHALLED, true);
/*     */   }
/*     */ 
/*     */   public void addMethodMetaData(Method method, Object tag, Object attr, Object value, boolean exactMatch) {
/*  65 */     addMethodMetaData(method, tag, attr, value, PayloadKey.MARSHALLED, exactMatch);
/*     */   }
/*     */ 
/*     */   public void addMethodMetaData(Method method, Object tag, Object attr, Object value, PayloadKey type) {
/*  69 */     addMethodMetaData(method.toString(), tag, attr, value, type, true);
/*     */   }
/*     */ 
/*     */   public void addMethodMetaData(Method method, Object tag, Object attr, Object value, PayloadKey type, boolean exactMatch) {
/*  73 */     addMethodMetaData(method.toString(), tag, attr, value, type, exactMatch);
/*     */   }
/*     */ 
/*     */   private synchronized void addMethodMetaData(String key, Object tag, Object attr, Object value, PayloadKey type, boolean exactMatch)
/*     */   {
/*  78 */     SimpleMetaData methodData = (SimpleMetaData)this.methodMetaData.get(key);
/*  79 */     if (methodData == null)
/*     */     {
/*  81 */       methodData = new SimpleMetaData();
/*  82 */       initMethodMetaDataMap();
/*  83 */       this.methodMetaData.put(key, methodData);
/*     */     }
/*  85 */     methodData.addMetaData(tag, attr, value, type);
/*  86 */     manageInexactMatches(key, tag, attr, exactMatch);
/*     */   }
/*     */ 
/*     */   private synchronized void manageInexactMatches(String key, Object tag, Object attr, boolean exactMatch)
/*     */   {
/*  91 */     if (!exactMatch)
/*     */     {
/*  93 */       if (this.inexactMatches == null)
/*     */       {
/*  95 */         this.inexactMatches = new HashMap();
/*     */       }
/*     */ 
/*  98 */       HashMap tags = (HashMap)this.inexactMatches.get(key);
/*  99 */       if (tags == null)
/*     */       {
/* 101 */         tags = new HashMap();
/* 102 */         this.inexactMatches.put(key, tags);
/*     */       }
/*     */ 
/* 105 */       HashMap attrs = (HashMap)tags.get(tag);
/* 106 */       if (attrs == null)
/*     */       {
/* 108 */         attrs = new HashMap();
/* 109 */         tags.put(tag, attrs);
/*     */       }
/* 111 */       attrs.put(attr, Boolean.TRUE);
/*     */     }
/*     */     else
/*     */     {
/* 115 */       if (this.inexactMatches == null) return;
/* 116 */       HashMap tags = (HashMap)this.inexactMatches.get(key);
/* 117 */       if (tags == null) return;
/* 118 */       HashMap attrs = (HashMap)tags.get(tag);
/* 119 */       if (attrs == null) return;
/* 120 */       attrs.remove(attr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized boolean tagWasMatchedInexactly(Method method, Object tag, Object attr)
/*     */   {
/* 127 */     if (this.inexactMatches == null) return false;
/* 128 */     HashMap tags = (HashMap)this.inexactMatches.get(method.toString());
/* 129 */     if (tags == null) return false;
/* 130 */     HashMap attrs = (HashMap)tags.get(tag);
/* 131 */     if (attrs == null) return false;
/* 132 */     return attrs.get(attr) != null;
/*     */   }
/*     */ 
/*     */   public boolean hasTag(Method method, String tag)
/*     */   {
/* 137 */     SimpleMetaData meta = getMethodMetaData(method);
/* 138 */     if (meta == null) return false;
/* 139 */     return meta.hasTag(tag);
/*     */   }
/*     */ 
/*     */   public Iterator getMethods()
/*     */   {
/* 144 */     return this.methodMetaData.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMethodMetaData(String method)
/*     */   {
/* 154 */     return (SimpleMetaData)this.methodMetaData.get(method);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMethodMetaData(Method method)
/*     */   {
/* 159 */     return getMethodMetaData(method.toString());
/*     */   }
/*     */ 
/*     */   public Object getMethodMetaData(Method method, Object tag, Object attr)
/*     */   {
/* 164 */     SimpleMetaData methodData = (SimpleMetaData)this.methodMetaData.get(method.toString());
/* 165 */     if (methodData == null) return null;
/* 166 */     return methodData.getMetaData(tag, attr);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 171 */     this.methodMetaData.clear();
/*     */   }
/*     */ 
/*     */   public Object resolve(Invocation invocation, Object tag, Object attr)
/*     */   {
/* 176 */     MethodInvocation methodInvocation = (MethodInvocation)invocation;
/* 177 */     return getMethodMetaData(methodInvocation.getMethod(), tag, attr);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getAllMetaData(Invocation invocation)
/*     */   {
/* 182 */     MethodInvocation methodInvocation = (MethodInvocation)invocation;
/* 183 */     return (SimpleMetaData)this.methodMetaData.get(methodInvocation.getMethod().toString());
/*     */   }
/*     */ 
/*     */   private String getCtMethodKey(CtMethod method)
/*     */   {
/* 191 */     return method.getName() + ":" + method.getSignature();
/*     */   }
/*     */ 
/*     */   public void tagMethod(CtMethod method, Object tag)
/*     */   {
/* 196 */     addMethodMetaData(method, tag, "$tagged$", PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public void addMethodMetaData(CtMethod method, Object tag, Object attr, Object value) {
/* 200 */     addMethodMetaData(getCtMethodKey(method), tag, attr, value, PayloadKey.MARSHALLED, true);
/*     */   }
/*     */ 
/*     */   public void addMethodMetaData(CtMethod method, Object tag, Object attr, Object value, PayloadKey type) {
/* 204 */     addMethodMetaData(getCtMethodKey(method), tag, attr, value, type, true);
/*     */   }
/*     */ 
/*     */   public boolean hasGroup(CtMethod method, String tag)
/*     */   {
/* 209 */     SimpleMetaData meta = getMethodMetaData(getCtMethodKey(method));
/* 210 */     if (meta == null) return false;
/* 211 */     return meta.hasTag(tag);
/*     */   }
/*     */ 
/*     */   private void initMethodMetaDataMap()
/*     */   {
/* 216 */     if (this.methodMetaData == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */     {
/* 218 */       this.methodMetaData = new ConcurrentHashMap();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.MethodMetaData
 * JD-Core Version:    0.6.0
 */