/*    */ package org.jboss.aop.metadata;
/*    */ 
/*    */ public class DynamicSimpleClassMetadataLoader extends SimpleClassMetaDataLoader
/*    */ {
/*    */   SimpleClassMetaDataBinding binding;
/*    */   String tag;
/*    */ 
/*    */   public DynamicSimpleClassMetadataLoader(String name, String tag, String classExpr)
/*    */   {
/* 38 */     String bname = name;
/* 39 */     if (bname == null)
/*    */     {
/* 42 */       long millis = System.currentTimeMillis();
/* 43 */       long random = ()(Math.random() * millis);
/* 44 */       bname = tag + ":" + classExpr + millis + ":" + random;
/*    */     }
/* 46 */     this.binding = new SimpleClassMetaDataBinding(this, bname, tag, classExpr);
/*    */   }
/*    */ 
/*    */   public DynamicSimpleClassMetadataLoader(String tag, String classExpr)
/*    */   {
/* 51 */     this(null, tag, classExpr);
/*    */   }
/*    */ 
/*    */   public ClassMetaDataBinding getClassMetaDataBinding()
/*    */   {
/* 56 */     return this.binding;
/*    */   }
/*    */ 
/*    */   public void addDefaultMetaData(String attr, Object val)
/*    */   {
/* 61 */     this.binding.addDefaultMetaData(this.binding.getTag(), attr, val);
/*    */   }
/*    */ 
/*    */   public void addClassMetaData(String attr, Object val)
/*    */   {
/* 66 */     this.binding.addClassMetaData(this.binding.getTag(), attr, val);
/*    */   }
/*    */ 
/*    */   public void addMethodMetaData(String methodExpr, String attr, Object val)
/*    */   {
/* 71 */     this.binding.queueMethodMetaData(methodExpr, this.binding.getTag(), attr, val);
/*    */   }
/*    */ 
/*    */   public void addFieldMetaData(String fieldName, String attr, Object val)
/*    */   {
/* 76 */     this.binding.queueFieldMetaData(fieldName, this.binding.getTag(), attr, val);
/*    */   }
/*    */ 
/*    */   public void addConstructorMetaData(String constructorExpr, String attr, Object val)
/*    */   {
/* 81 */     this.binding.queueConstructorMetaData(constructorExpr, this.binding.getTag(), attr, val);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.DynamicSimpleClassMetadataLoader
 * JD-Core Version:    0.6.0
 */