/*     */ package org.jboss.aop.junit;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.test.AbstractTestDelegate;
/*     */ 
/*     */ public class AOPTestDelegate extends AbstractTestDelegate
/*     */ {
/*  41 */   private static final CopyOnWriteArrayList urls = new CopyOnWriteArrayList();
/*     */ 
/*     */   public AOPTestDelegate(Class clazz)
/*     */     throws Exception
/*     */   {
/*  51 */     super(clazz);
/*     */   }
/*     */ 
/*     */   public void setUp() throws Exception
/*     */   {
/*  56 */     super.setUp();
/*     */     try
/*     */     {
/*  60 */       deploy();
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  64 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  68 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/*  72 */       throw e;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  76 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Exception
/*     */   {
/*  82 */     super.tearDown();
/*  83 */     undeploy();
/*     */   }
/*     */ 
/*     */   protected void deploy()
/*     */     throws Exception
/*     */   {
/*  93 */     String testName = this.clazz.getName();
/*  94 */     testName = testName.replace('.', '/') + "-aop.xml";
/*  95 */     URL url = this.clazz.getClassLoader().getResource(testName);
/*  96 */     if (url != null)
/*  97 */       deploy(url);
/*     */     else
/*  99 */       this.log.debug("No test specific deployment " + testName);
/*     */   }
/*     */ 
/*     */   protected void undeploy()
/*     */   {
/* 104 */     for (Iterator i = urls.iterator(); i.hasNext(); )
/*     */     {
/* 106 */       URL url = (URL)i.next();
/* 107 */       undeploy(url);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deploy(URL url)
/*     */     throws Exception
/*     */   {
/* 119 */     this.log.debug("Deploying " + url);
/* 120 */     urls.add(url);
/* 121 */     AspectXmlLoader.deployXML(url);
/*     */   }
/*     */ 
/*     */   protected void undeploy(URL url)
/*     */   {
/*     */     try
/*     */     {
/* 133 */       this.log.debug("Undeploying " + url);
/* 134 */       urls.remove(url);
/* 135 */       AspectXmlLoader.undeployXML(url);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 139 */       this.log.warn("Ignored error undeploying " + url, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.junit.AOPTestDelegate
 * JD-Core Version:    0.6.0
 */