/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class MethodInvocationWrapper extends MethodInvocation
/*     */ {
/*     */   private static final long serialVersionUID = 6399861718513077210L;
/*     */   MethodInvocation wrapped;
/*     */ 
/*     */   public MethodInvocationWrapper(MethodInvocation wrapped, Interceptor[] interceptors)
/*     */   {
/*  46 */     super(interceptors);
/*  47 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  52 */     return this.wrapped.getMetaData(group, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     Object localObject1;
/*  57 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  61 */         localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  71 */       localObject1 = this.wrapped.invokeNext();
/*     */       return localObject1; } finally { this.responseContextInfo = this.wrapped.getResponseContextInfo(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/*  81 */     return this.wrapped.getInstanceResolver();
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/*  86 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] args)
/*     */   {
/*  91 */     this.wrapped.setArguments(args);
/*     */   }
/*     */ 
/*     */   public Object getTargetObject() {
/*  95 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 100 */     MethodInvocationWrapper invocation = new MethodInvocationWrapper((MethodInvocation)this.wrapped.copy(), this.interceptors);
/* 101 */     invocation.currentInterceptor = this.currentInterceptor;
/* 102 */     return invocation;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 107 */     return this.wrapped.getMethod();
/*     */   }
/*     */ 
/*     */   public Method getActualMethod()
/*     */   {
/* 112 */     return this.wrapped.getActualMethod();
/*     */   }
/*     */ 
/*     */   public long getMethodHash()
/*     */   {
/* 117 */     return this.wrapped.getMethodHash();
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 122 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 127 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 132 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 137 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 142 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 147 */     return this.wrapped.getMetaData();
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 152 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 157 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodInvocationWrapper
 * JD-Core Version:    0.6.0
 */