/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MethodMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class MethodInvocation extends InvocationBase
/*     */   implements Externalizable
/*     */ {
/*     */   static final long serialVersionUID = -1313717554016611763L;
/*     */   protected Object[] arguments;
/*     */   protected long methodHash;
/*     */   protected MarshalledObject marshalledArguments;
/*     */   protected Method advisedMethod;
/*     */   protected Method unadvisedMethod;
/*     */ 
/*     */   public String toString()
/*     */   {
/*  55 */     StringBuffer sb = new StringBuffer(100);
/*  56 */     sb.append("[");
/*  57 */     sb.append("advisedMethod=").append(this.advisedMethod);
/*  58 */     sb.append(", unadvisedMethod=").append(this.unadvisedMethod);
/*  59 */     sb.append(", metadata=").append(this.metadata);
/*  60 */     sb.append(", targetObject=").append(this.targetObject);
/*  61 */     sb.append(", arguments=").append(this.arguments);
/*  62 */     sb.append("]");
/*  63 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public MethodInvocation(MethodInfo info, Interceptor[] interceptors)
/*     */   {
/*  69 */     this(interceptors, info.getHash(), info.getMethod(), info.getUnadvisedMethod(), info.getAdvisor());
/*     */   }
/*     */ 
/*     */   public MethodInvocation(Interceptor[] interceptors, long methodHash, Method advisedMethod, Method unadvisedMethod, Advisor advisor)
/*     */   {
/*  74 */     super(interceptors);
/*  75 */     this.advisor = advisor;
/*  76 */     this.methodHash = methodHash;
/*  77 */     this.advisedMethod = advisedMethod;
/*  78 */     this.unadvisedMethod = unadvisedMethod;
/*     */   }
/*     */ 
/*     */   protected MethodInvocation(Interceptor[] interceptors)
/*     */   {
/*  83 */     super(interceptors);
/*     */   }
/*     */ 
/*     */   public MethodInvocation()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  97 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/* 101 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/* 110 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 121 */       return getActualMethod().invoke(getTargetObject(), this.arguments);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 125 */     throw handleErrors(getTargetObject(), getMethod(), this.arguments, t);
/*     */   }
/*     */ 
/*     */   public static Throwable handleErrors(Object target, Method method, Object[] arguments, Throwable t)
/*     */     throws Throwable
/*     */   {
/* 142 */     if ((t instanceof IllegalArgumentException))
/*     */     {
/* 144 */       if (target == null)
/*     */       {
/* 146 */         throw new IllegalArgumentException("Null target for method " + method);
/* 147 */       }Class methodClass = method.getClass();
/* 148 */       Class targetClass = target.getClass();
/* 149 */       if (!methodClass.isAssignableFrom(targetClass))
/* 150 */         throw new IllegalArgumentException("Wrong target. " + targetClass + " for " + method);
/* 151 */       ArrayList expected = new ArrayList();
/* 152 */       Class[] parameterTypes = method.getParameterTypes();
/* 153 */       for (int i = 0; i < parameterTypes.length; i++)
/* 154 */         expected.add(parameterTypes[i].getName());
/* 155 */       ArrayList actual = new ArrayList();
/* 156 */       if (arguments != null)
/*     */       {
/* 158 */         for (int i = 0; i < arguments.length; i++)
/*     */         {
/* 160 */           if (arguments[i] == null)
/* 161 */             actual.add(null);
/*     */           else
/* 163 */             actual.add(arguments[i].getClass().getName());
/*     */         }
/*     */       }
/* 166 */       throw new IllegalArgumentException("Wrong arguments. " + method.getName() + " expected=" + expected + " actual=" + actual);
/*     */     }
/* 168 */     if ((t instanceof InvocationTargetException))
/*     */     {
/* 170 */       throw ((InvocationTargetException)t).getTargetException();
/*     */     }
/* 172 */     throw t;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 180 */     Object val = super.resolveAnnotation(annotation);
/* 181 */     if (val != null) return val;
/*     */ 
/* 183 */     if (getAdvisor() != null)
/*     */     {
/* 185 */       val = getAdvisor().resolveAnnotation(getMethodHash(), getMethod(), annotation);
/* 186 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 189 */     return null;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class[] annotations)
/*     */   {
/* 197 */     Object val = super.resolveAnnotation(annotations);
/* 198 */     if (val != null) return val;
/*     */ 
/* 200 */     if (getAdvisor() != null)
/*     */     {
/* 202 */       val = getAdvisor().resolveAnnotation(getMethod(), annotations);
/* 203 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 206 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 220 */     Object val = super.getMetaData(group, attr);
/* 221 */     if (val != null) return val;
/*     */ 
/* 223 */     if (getAdvisor() != null)
/*     */     {
/* 225 */       val = getAdvisor().getMethodMetaData().resolve(this, group, attr);
/* 226 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 229 */     if (getAdvisor() != null)
/*     */     {
/* 231 */       val = getAdvisor().getDefaultMetaData().resolve(this, group, attr);
/* 232 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 235 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 249 */     MethodInvocationWrapper wrapper = new MethodInvocationWrapper(this, newchain);
/* 250 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 260 */     MethodInvocation wrapper = new MethodInvocation(this.interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/* 261 */     wrapper.metadata = this.metadata;
/* 262 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 263 */     wrapper.instanceResolver = this.instanceResolver;
/* 264 */     wrapper.setTargetObject(getTargetObject());
/* 265 */     wrapper.setArguments(getArguments());
/* 266 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 285 */     if ((this.arguments == null) && (this.marshalledArguments != null))
/*     */     {
/*     */       try
/*     */       {
/* 289 */         this.arguments = ((Object[])(Object[])this.marshalledArguments.get());
/* 290 */         this.marshalledArguments = null;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 294 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 298 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 301 */     return this.arguments;
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/* 320 */     this.arguments = arguments;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 325 */     return this.advisedMethod;
/*     */   }
/*     */ 
/*     */   public Method getActualMethod()
/*     */   {
/* 330 */     return this.unadvisedMethod;
/*     */   }
/*     */ 
/*     */   public long getMethodHash()
/*     */   {
/* 335 */     return this.methodHash;
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 340 */     return this.advisor;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 346 */     out.writeLong(this.methodHash);
/* 347 */     if (getArguments() == null)
/*     */     {
/* 349 */       out.writeObject(null);
/*     */     }
/*     */     else
/*     */     {
/* 353 */       MarshalledObject mo = new MarshalledObject(getArguments());
/* 354 */       out.writeObject(mo);
/*     */     }
/* 356 */     out.writeObject(this.metadata);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 361 */     this.methodHash = in.readLong();
/* 362 */     this.marshalledArguments = ((MarshalledObject)in.readObject());
/* 363 */     this.metadata = ((SimpleMetaData)in.readObject());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodInvocation
 * JD-Core Version:    0.6.0
 */