/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class MethodCalledByMethodInvocationWrapper extends MethodCalledByMethodInvocation
/*     */ {
/*     */   private static final long serialVersionUID = 5130026569290691583L;
/*     */   MethodCalledByMethodInvocation wrapped;
/*     */ 
/*     */   public MethodCalledByMethodInvocationWrapper(MethodCalledByMethodInvocation wrapped, Interceptor[] interceptors)
/*     */   {
/*  46 */     super(wrapped.getCallingObject(), interceptors);
/*  47 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  52 */     return this.wrapped.getMetaData(group, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     Object localObject1;
/*  57 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  61 */         localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  71 */       localObject1 = this.wrapped.invokeNext();
/*     */       return localObject1; } finally { this.responseContextInfo = this.wrapped.getResponseContextInfo(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/*  81 */     return this.wrapped.getInstanceResolver();
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/*  86 */     MethodCalledByMethodInvocationWrapper invocation = new MethodCalledByMethodInvocationWrapper((MethodCalledByMethodInvocation)this.wrapped.copy(), this.interceptors);
/*  87 */     invocation.currentInterceptor = this.currentInterceptor;
/*  88 */     return invocation;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/*  93 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/*  98 */     this.wrapped.setArguments(arguments);
/*     */   }
/*     */ 
/*     */   public Class getCallingClass()
/*     */   {
/* 103 */     return this.wrapped.getCallingClass();
/*     */   }
/*     */ 
/*     */   public Method getCallingMethod()
/*     */   {
/* 108 */     return this.wrapped.getCallingMethod();
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 113 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 118 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 123 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 128 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 133 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 138 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/* 143 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 148 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ 
/*     */   public Method getCalledMethod()
/*     */   {
/* 156 */     return this.wrapped.getCalledMethod();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodCalledByMethodInvocationWrapper
 * JD-Core Version:    0.6.0
 */