/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import org.jboss.aop.FieldInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ 
/*     */ public class FieldWriteInvocation extends FieldInvocation
/*     */ {
/*     */   static final long serialVersionUID = 6795964118579848645L;
/*     */   protected Object value;
/*     */ 
/*     */   public FieldWriteInvocation(Field field, int index, Object value, Interceptor[] interceptors)
/*     */   {
/*  46 */     super(field, index, interceptors);
/*  47 */     this.value = value;
/*     */   }
/*     */ 
/*     */   protected FieldWriteInvocation(Interceptor[] interceptors)
/*     */   {
/*  52 */     super(interceptors);
/*     */   }
/*     */ 
/*     */   protected FieldWriteInvocation(FieldInfo info, Interceptor[] interceptors)
/*     */   {
/*  57 */     super(info, interceptors);
/*     */   }
/*     */ 
/*     */   protected FieldWriteInvocation(FieldInfo info, Object value, Interceptor[] interceptors)
/*     */   {
/*  62 */     super(info, interceptors);
/*  63 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  73 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  77 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  86 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*  95 */     this.field.set(getTargetObject(), getValue());
/*  96 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 109 */     FieldWriteInvocationWrapper wrapper = new FieldWriteInvocationWrapper(this, newchain);
/* 110 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 119 */     FieldWriteInvocation wrapper = new FieldWriteInvocation(this.field, this.index, this.value, this.interceptors);
/* 120 */     wrapper.setAdvisor(getAdvisor());
/* 121 */     wrapper.setTargetObject(getTargetObject());
/* 122 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 123 */     wrapper.instanceResolver = this.instanceResolver;
/* 124 */     wrapper.metadata = this.metadata;
/* 125 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/* 130 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(Object value)
/*     */   {
/* 135 */     this.value = value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.FieldWriteInvocation
 * JD-Core Version:    0.6.0
 */