/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class FieldReadInvocationWrapper extends FieldReadInvocation
/*     */ {
/*     */   static final long serialVersionUID = 7595351292713886213L;
/*     */   FieldReadInvocation wrapped;
/*     */ 
/*     */   public FieldReadInvocationWrapper(FieldReadInvocation wrapped, Interceptor[] interceptors)
/*     */   {
/*  47 */     super(interceptors);
/*  48 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  53 */     return this.wrapped.getMetaData(group, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     Object localObject1;
/*  58 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  62 */         localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  72 */       localObject1 = this.wrapped.invokeNext();
/*     */       return localObject1; } finally { this.responseContextInfo = this.wrapped.getResponseContextInfo(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/*  82 */     return this.wrapped.getInstanceResolver();
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/*  87 */     FieldReadInvocationWrapper invocation = new FieldReadInvocationWrapper((FieldReadInvocation)this.wrapped.copy(), this.interceptors);
/*  88 */     invocation.currentInterceptor = this.currentInterceptor;
/*  89 */     return invocation;
/*     */   }
/*     */ 
/*     */   public Field getField()
/*     */   {
/*  94 */     return this.wrapped.getField();
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/*  99 */     return this.wrapped.getIndex();
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 104 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 109 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 114 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 119 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 124 */     return this.wrapped.getMetaData();
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 129 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 134 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/* 139 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 144 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.FieldReadInvocationWrapper
 * JD-Core Version:    0.6.0
 */