/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import org.jboss.aop.FieldInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ 
/*     */ public class FieldReadInvocation extends FieldInvocation
/*     */ {
/*     */   private static final long serialVersionUID = 3337041720097890861L;
/*     */ 
/*     */   public FieldReadInvocation(Field field, int index, Interceptor[] interceptors)
/*     */   {
/*  44 */     super(field, index, interceptors);
/*     */   }
/*     */ 
/*     */   protected FieldReadInvocation(Interceptor[] interceptors)
/*     */   {
/*  49 */     super(interceptors);
/*     */   }
/*     */ 
/*     */   protected FieldReadInvocation(FieldInfo info, Interceptor[] interceptors)
/*     */   {
/*  54 */     super(info, interceptors);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  64 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  68 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  77 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*  86 */     return this.field.get(getTargetObject());
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/*  99 */     FieldReadInvocationWrapper wrapper = new FieldReadInvocationWrapper(this, newchain);
/* 100 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 109 */     FieldReadInvocation wrapper = new FieldReadInvocation(this.field, this.index, this.interceptors);
/* 110 */     wrapper.setAdvisor(getAdvisor());
/* 111 */     wrapper.setTargetObject(getTargetObject());
/* 112 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 113 */     wrapper.metadata = this.metadata;
/* 114 */     wrapper.instanceResolver = this.instanceResolver;
/* 115 */     return wrapper;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.FieldReadInvocation
 * JD-Core Version:    0.6.0
 */