/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.FieldInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.FieldMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public abstract class FieldInvocation extends InvocationBase
/*     */ {
/*     */   private static final long serialVersionUID = -6040602776393748583L;
/*  41 */   protected transient Field field = null;
/*     */   protected int index;
/*     */ 
/*     */   public FieldInvocation(Field field, int fieldIndex, Interceptor[] interceptors)
/*     */   {
/*  46 */     super(interceptors);
/*  47 */     this.field = field;
/*  48 */     this.index = fieldIndex;
/*     */   }
/*     */ 
/*     */   protected FieldInvocation(Interceptor[] interceptors)
/*     */   {
/*  53 */     super(interceptors);
/*     */   }
/*     */ 
/*     */   protected FieldInvocation(FieldInfo info, Interceptor[] interceptors)
/*     */   {
/*  58 */     this(info.getField(), info.getIndex(), interceptors);
/*  59 */     this.advisor = info.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/*  68 */     Object val = super.resolveAnnotation(annotation);
/*  69 */     if (val != null) return val;
/*     */ 
/*  71 */     if (getAdvisor() != null)
/*     */     {
/*  73 */       val = getAdvisor().resolveAnnotation(this.field, annotation);
/*  74 */       if (val != null) return val;
/*     */     }
/*     */ 
/*  77 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  90 */     Object val = super.getMetaData(group, attr);
/*  91 */     if (val != null) return val;
/*     */ 
/*  93 */     if (getAdvisor() != null)
/*     */     {
/*  95 */       val = getAdvisor().getFieldMetaData().resolve(this, group, attr);
/*  96 */       if (val != null) return val;
/*     */     }
/*     */ 
/*  99 */     if (getAdvisor() != null)
/*     */     {
/* 101 */       val = getAdvisor().getDefaultMetaData().resolve(this, group, attr);
/* 102 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 105 */     return null;
/*     */   }
/*     */ 
/*     */   public Field getField()
/*     */   {
/* 115 */     return this.field;
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/* 125 */     return this.index;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.FieldInvocation
 * JD-Core Version:    0.6.0
 */