/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class ConstructorInvocationWrapper extends ConstructorInvocation
/*     */ {
/*     */   private static final long serialVersionUID = -1092370003103163067L;
/*     */   ConstructorInvocation wrapped;
/*     */ 
/*     */   public ConstructorInvocationWrapper(ConstructorInvocation wrapped, Interceptor[] interceptors)
/*     */   {
/*  47 */     super(interceptors);
/*  48 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  53 */     return this.wrapped.getMetaData(group, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     Object localObject1;
/*  58 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  62 */         localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  72 */       localObject1 = this.wrapped.invokeNext();
/*     */       return localObject1; } finally { this.responseContextInfo = this.wrapped.getResponseContextInfo(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/*  82 */     return this.wrapped.getInstanceResolver();
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/*  87 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] args)
/*     */   {
/*  92 */     this.wrapped.setArguments(args);
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/*  97 */     ConstructorInvocationWrapper invocation = new ConstructorInvocationWrapper((ConstructorInvocation)this.wrapped.copy(), this.interceptors);
/*  98 */     invocation.currentInterceptor = this.currentInterceptor;
/*  99 */     return invocation;
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/* 104 */     return this.wrapped.getConstructor();
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/* 109 */     this.wrapped.setConstructor(constructor);
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 114 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 119 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 124 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 129 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 134 */     return this.wrapped.getMetaData();
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 139 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 144 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/* 149 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 154 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorInvocationWrapper
 * JD-Core Version:    0.6.0
 */