/*    */ package org.jboss.aop.joinpoint;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.Method;
/*    */ 
/*    */ public class ConstructorCalledByMethodJoinpoint
/*    */   implements Joinpoint
/*    */ {
/*    */   private final Method calling;
/*    */   private final Constructor called;
/*    */   int hashCode;
/*    */ 
/*    */   public ConstructorCalledByMethodJoinpoint(Method calling, Constructor called)
/*    */   {
/* 41 */     this.calling = calling;
/* 42 */     this.called = called;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 47 */     if (o == null) return false;
/* 48 */     if (o == this) return true;
/* 49 */     if (!(o instanceof ConstructorCalledByMethodJoinpoint)) return false;
/* 50 */     ConstructorCalledByMethodJoinpoint jp = (ConstructorCalledByMethodJoinpoint)o;
/* 51 */     if (!jp.calling.equals(this.calling)) return false;
/* 52 */     return jp.called.equals(this.called);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 58 */     if (this.hashCode == 0)
/*    */     {
/* 60 */       this.hashCode = (this.calling.hashCode() + this.called.hashCode());
/*    */     }
/* 62 */     return this.hashCode;
/*    */   }
/*    */ 
/*    */   public Method getCalling()
/*    */   {
/* 67 */     return this.calling;
/*    */   }
/*    */ 
/*    */   public Constructor getCalled()
/*    */   {
/* 72 */     return this.called;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 77 */     return this.called + " called by " + this.calling;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint
 * JD-Core Version:    0.6.0
 */