/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ConByMethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ 
/*     */ public class ConstructorCalledByMethodInvocation extends CallerInvocation
/*     */ {
/*     */   private static final long serialVersionUID = -3269308917757322223L;
/*     */   protected Class callingClass;
/*     */   protected Method callingMethod;
/*     */   protected Constructor constructor;
/*     */   protected Method wrappingMethod;
/*     */ 
/*     */   public ConstructorCalledByMethodInvocation(ConByMethodInfo info, Object callingObject, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  53 */     this(info.getAdvisor(), info.getCallingClass(), info.getCallingMethod(), info.getConstructor(), info.getWrappingMethod(), callingObject, args, interceptors);
/*     */   }
/*     */ 
/*     */   public ConstructorCalledByMethodInvocation(ConByMethodInfo info, Object callingObject, Interceptor[] interceptors)
/*     */   {
/*  58 */     this(info.getAdvisor(), info.getCallingClass(), info.getCallingMethod(), info.getConstructor(), info.getWrappingMethod(), callingObject, null, interceptors);
/*     */   }
/*     */ 
/*     */   public ConstructorCalledByMethodInvocation(Advisor advisor, Class callingClass, Method callingMethod, Constructor constructor, Method wrappingMethod, Object callingObject, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  64 */     super(advisor, callingObject, interceptors);
/*  65 */     this.callingClass = callingClass;
/*  66 */     this.callingMethod = callingMethod;
/*  67 */     this.constructor = constructor;
/*  68 */     this.wrappingMethod = wrappingMethod;
/*  69 */     this.callingObject = callingObject;
/*  70 */     this.arguments = args;
/*     */   }
/*     */ 
/*     */   public ConstructorCalledByMethodInvocation(Object callingObject, Interceptor[] interceptors)
/*     */   {
/*  75 */     super(callingObject, interceptors);
/*     */   }
/*     */ 
/*     */   public Class getCallingClass()
/*     */   {
/*  83 */     return this.callingClass;
/*     */   }
/*     */ 
/*     */   public Method getCallingMethod()
/*     */   {
/*  91 */     return this.callingMethod;
/*     */   }
/*     */ 
/*     */   public Constructor getCalledConstructor()
/*     */   {
/*  99 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public boolean isWrapped()
/*     */   {
/* 110 */     return this.wrappingMethod != null;
/*     */   }
/*     */ 
/*     */   public Method getWrappingMethod()
/*     */   {
/* 122 */     return this.wrappingMethod;
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/* 132 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/* 136 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/* 145 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/* 154 */     if (this.wrappingMethod != null)
/*     */     {
/*     */       try
/*     */       {
/* 158 */         setTargetObject(this.wrappingMethod.invoke(null, this.arguments));
/* 159 */         return getTargetObject();
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 163 */         throw e.getTargetException();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 170 */       return this.constructor.newInstance(this.arguments);
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 174 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 178 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 182 */     throw e.getCause();
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 198 */     Object val = super.getMetaData(group, attr);
/* 199 */     if (val != null) return val;
/*     */ 
/* 202 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 216 */     ConstructorCalledByMethodInvocationWrapper wrapper = new ConstructorCalledByMethodInvocationWrapper(this, newchain);
/* 217 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 227 */     ConstructorCalledByMethodInvocation wrapper = new ConstructorCalledByMethodInvocation(this.advisor, this.callingClass, this.callingMethod, this.constructor, this.wrappingMethod, this.callingObject, this.arguments, this.interceptors);
/*     */ 
/* 229 */     wrapper.setTargetObject(getTargetObject());
/* 230 */     wrapper.metadata = this.metadata;
/* 231 */     wrapper.instanceResolver = this.instanceResolver;
/* 232 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 233 */     return wrapper;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation
 * JD-Core Version:    0.6.0
 */