/*    */ package org.jboss.aop.joinpoint;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ 
/*    */ public class ConstructorCalledByConstructorJoinpoint
/*    */   implements Joinpoint
/*    */ {
/*    */   private final Constructor calling;
/*    */   private final Constructor called;
/*    */   int hashCode;
/*    */ 
/*    */   public ConstructorCalledByConstructorJoinpoint(Constructor calling, Constructor called)
/*    */   {
/* 40 */     this.calling = calling;
/* 41 */     this.called = called;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 46 */     if (o == null) return false;
/* 47 */     if (o == this) return true;
/* 48 */     if (!(o instanceof ConstructorCalledByConstructorJoinpoint)) return false;
/* 49 */     ConstructorCalledByConstructorJoinpoint jp = (ConstructorCalledByConstructorJoinpoint)o;
/* 50 */     if (!jp.calling.equals(this.calling)) return false;
/* 51 */     return jp.called.equals(this.called);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 57 */     if (this.hashCode == 0)
/*    */     {
/* 59 */       this.hashCode = (this.calling.hashCode() + this.called.hashCode());
/*    */     }
/* 61 */     return this.hashCode;
/*    */   }
/*    */ 
/*    */   public Constructor getCalling()
/*    */   {
/* 66 */     return this.calling;
/*    */   }
/*    */ 
/*    */   public Constructor getCalled()
/*    */   {
/* 71 */     return this.called;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 76 */     return this.called + " called by " + this.calling;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint
 * JD-Core Version:    0.6.0
 */