/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ConstructionInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class ConstructionInvocation extends InvocationBase
/*     */ {
/*     */   private static final long serialVersionUID = -6040602776303875808L;
/*  42 */   protected Object[] arguments = null;
/*  43 */   protected transient Constructor constructor = null;
/*     */ 
/*     */   public ConstructionInvocation(Interceptor[] interceptors, Constructor con, Object[] args)
/*     */   {
/*  47 */     super(interceptors);
/*  48 */     this.constructor = con;
/*  49 */     this.arguments = args;
/*     */   }
/*     */ 
/*     */   public ConstructionInvocation(Interceptor[] interceptors, Constructor con)
/*     */   {
/*  55 */     super(interceptors);
/*  56 */     this.constructor = con;
/*     */   }
/*     */ 
/*     */   public ConstructionInvocation(ConstructionInfo info, Interceptor[] interceptors)
/*     */   {
/*  61 */     super(interceptors);
/*  62 */     this.constructor = info.getConstructor();
/*  63 */     this.advisor = info.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  74 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  78 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  87 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*  97 */     return null;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 107 */     Object val = super.resolveAnnotation(annotation);
/* 108 */     if (val != null) return val;
/*     */ 
/* 110 */     if (getAdvisor() != null)
/*     */     {
/* 112 */       val = getAdvisor().resolveAnnotation(this.constructor, annotation);
/* 113 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 130 */     Object val = super.getMetaData(group, attr);
/* 131 */     if (val != null) return val;
/*     */ 
/* 133 */     if (getAdvisor() != null)
/*     */     {
/* 135 */       val = getAdvisor().getConstructorMetaData().resolve(this, group, attr);
/* 136 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 139 */     if (getAdvisor() != null)
/*     */     {
/* 141 */       val = getAdvisor().getDefaultMetaData().resolve(this, group, attr);
/* 142 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 145 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 159 */     ConstructionInvocationWrapper wrapper = new ConstructionInvocationWrapper(this, newchain);
/* 160 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 170 */     ConstructionInvocation wrapper = new ConstructionInvocation(this.interceptors, this.constructor, this.arguments);
/* 171 */     wrapper.setAdvisor(getAdvisor());
/* 172 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 173 */     wrapper.metadata = this.metadata;
/* 174 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 199 */     return this.arguments;
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/* 221 */     this.arguments = arguments;
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/* 226 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/* 231 */     this.constructor = constructor;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructionInvocation
 * JD-Core Version:    0.6.0
 */