/*     */ package org.jboss.aop.introduction;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*     */ import org.jboss.annotation.factory.ast.AnnotationParser;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.AnnotationMatcher;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*     */ 
/*     */ public class AnnotationIntroduction
/*     */ {
/*     */   private String originalExpression;
/*     */   private String originalAnnotationExpr;
/*     */   private org.jboss.aop.pointcut.ast.ASTStart target;
/*     */   private ASTAnnotation annotation;
/*     */   private boolean invisible;
/*     */ 
/*     */   public static AnnotationIntroduction createMethodAnnotationIntroduction(String methodExpr, String annotationExpr, boolean invisible)
/*     */   {
/*  51 */     String expr = "method(" + methodExpr + ")";
/*  52 */     return new AnnotationIntroduction(expr, annotationExpr, invisible);
/*     */   }
/*     */ 
/*     */   public static AnnotationIntroduction createConstructorAnnotationIntroduction(String conExpr, String annotationExpr, boolean invisible)
/*     */   {
/*  57 */     String expr = "constructor(" + conExpr + ")";
/*  58 */     return new AnnotationIntroduction(expr, annotationExpr, invisible);
/*     */   }
/*     */ 
/*     */   public static AnnotationIntroduction createFieldAnnotationIntroduction(String fieldExpr, String annotationExpr, boolean invisible)
/*     */   {
/*  63 */     String expr = "field(" + fieldExpr + ")";
/*  64 */     return new AnnotationIntroduction(expr, annotationExpr, invisible);
/*     */   }
/*     */ 
/*     */   public static AnnotationIntroduction createClassAnnotationIntroduction(String classExpr, String annotationExpr, boolean invisible)
/*     */   {
/*  69 */     String expr = "class(" + classExpr + ")";
/*  70 */     return new AnnotationIntroduction(expr, annotationExpr, invisible);
/*     */   }
/*     */ 
/*     */   public static AnnotationIntroduction createComplexAnnotationIntroduction(String expr, String annotationExpr, boolean invisible)
/*     */   {
/*  75 */     return new AnnotationIntroduction(expr, annotationExpr, invisible);
/*     */   }
/*     */ 
/*     */   private AnnotationIntroduction(String expr, String annotationExpr, boolean invisible)
/*     */   {
/*  87 */     this.invisible = invisible;
/*  88 */     this.originalAnnotationExpr = annotationExpr;
/*  89 */     this.originalExpression = expr;
/*     */     try
/*     */     {
/*  92 */       AnnotationParser parser = new AnnotationParser(new StringReader(annotationExpr));
/*  93 */       org.jboss.annotation.factory.ast.ASTStart start = parser.Start();
/*  94 */       this.annotation = ((ASTAnnotation)start.jjtGetChild(0));
/*     */     }
/*     */     catch (org.jboss.annotation.factory.ast.ParseException e)
/*     */     {
/*  98 */       throw new RuntimeException(annotationExpr, e);
/*     */     }
/*     */     try
/*     */     {
/* 102 */       TypeExpressionParser parser = new TypeExpressionParser(new StringReader(expr));
/* 103 */       this.target = parser.Start();
/*     */     }
/*     */     catch (org.jboss.aop.pointcut.ast.ParseException e)
/*     */     {
/* 107 */       throw new RuntimeException(expr, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtClass clazz)
/*     */   {
/* 113 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, clazz);
/* 114 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtMethod method)
/*     */   {
/* 119 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, method);
/* 120 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtConstructor con)
/*     */   {
/* 125 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, con);
/* 126 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtField field)
/*     */   {
/* 131 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, field);
/* 132 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Class clazz)
/*     */   {
/* 137 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, clazz);
/* 138 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Method method)
/*     */   {
/* 143 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, method);
/* 144 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Constructor con)
/*     */   {
/* 149 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, con);
/* 150 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Field field)
/*     */   {
/* 155 */     AnnotationMatcher matcher = new AnnotationMatcher(advisor, field);
/* 156 */     return ((Boolean)this.target.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public String getOriginalExpression()
/*     */   {
/* 161 */     return this.originalExpression;
/*     */   }
/*     */ 
/*     */   public String getOriginalAnnotationExpr()
/*     */   {
/* 166 */     return this.originalAnnotationExpr;
/*     */   }
/*     */ 
/*     */   public ASTAnnotation getAnnotation()
/*     */   {
/* 171 */     return this.annotation;
/*     */   }
/*     */ 
/*     */   public boolean isInvisible()
/*     */   {
/* 176 */     return this.invisible;
/*     */   }
/*     */ 
/*     */   public org.jboss.aop.pointcut.ast.ASTStart getTarget()
/*     */   {
/* 181 */     return this.target;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.introduction.AnnotationIntroduction
 * JD-Core Version:    0.6.0
 */