/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMember;
/*     */ 
/*     */ public class WrapperTransformer
/*     */ {
/*     */   private static final byte UNWRAPPED = 0;
/*     */   private static final byte WRAPPED = 1;
/*     */   private static final byte NOT_PREPARED = 2;
/*     */   private static final String WRAPPER_STATUS_ATTRIBUTE = "aop$wrapperStatus$aop";
/*  61 */   protected static final String[] SINGLE_TRANSFORMATION = { "aop$wrapperStatus$aop" };
/*     */   protected static final int SINGLE_TRANSFORMATION_INDEX = 0;
/*     */   private String[] transformationsStatus;
/*     */ 
/*     */   public WrapperTransformer(String[] transformations)
/*     */   {
/*  81 */     if (transformations == SINGLE_TRANSFORMATION)
/*     */     {
/*  83 */       this.transformationsStatus = transformations;
/*     */     }
/*     */     else
/*     */     {
/*  87 */       this.transformationsStatus = new String[transformations.length];
/*  88 */       for (int i = 0; i < transformations.length; i++)
/*     */       {
/*  90 */         this.transformationsStatus[i] = ("aop$wrapperStatus$aop$" + transformations[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void prepareForWrapping(CtMember member, int transformationIndex)
/*     */   {
/* 102 */     if (getWrapperStatusAttribute(member, transformationIndex) != 2)
/*     */     {
/* 104 */       throw new RuntimeException("Member already prepared:" + member);
/*     */     }
/* 106 */     setWrapperStatusAttribute(member, transformationIndex, 0);
/*     */   }
/*     */ 
/*     */   public void wrap(CtMember member, int transformationIndex)
/*     */   {
/* 116 */     byte wrapperStatus = getWrapperStatusAttribute(member, transformationIndex);
/* 117 */     if (wrapperStatus != 0)
/*     */     {
/* 119 */       String errorMessage = "Member not unwrapped: " + member.getName() + "." + member.getDeclaringClass().getName();
/*     */ 
/* 121 */       errorMessage = errorMessage + "\nMember status: ";
/* 122 */       errorMessage = errorMessage + (wrapperStatus == 2 ? "NOT_PREPARED" : "WRAPPED");
/*     */ 
/* 124 */       throw new RuntimeException(errorMessage);
/*     */     }
/* 126 */     setWrapperStatusAttribute(member, transformationIndex, 1);
/*     */   }
/*     */ 
/*     */   public void unwrap(CtMember member, int transformationIndex)
/*     */   {
/* 136 */     byte wrapperStatus = getWrapperStatusAttribute(member, transformationIndex);
/* 137 */     if (wrapperStatus != 1)
/*     */     {
/* 139 */       String errorMessage = "Member not wrapped: " + member.getName() + "." + member.getDeclaringClass().getName();
/*     */ 
/* 141 */       errorMessage = errorMessage + "\nMember status: ";
/* 142 */       errorMessage = errorMessage + (wrapperStatus == 2 ? "NOT_PREPARED" : "UNWRAPPED");
/* 143 */       throw new RuntimeException(errorMessage);
/*     */     }
/* 145 */     setWrapperStatusAttribute(member, transformationIndex, 0);
/*     */   }
/*     */ 
/*     */   public boolean isNotPrepared(CtMember member, int transformationIndex)
/*     */   {
/* 156 */     byte wrapperStatus = getWrapperStatusAttribute(member, transformationIndex);
/* 157 */     return wrapperStatus == 2;
/*     */   }
/*     */ 
/*     */   public boolean isWrapped(CtMember member, int transformationIndex)
/*     */   {
/* 168 */     byte wrapperStatus = getWrapperStatusAttribute(member, transformationIndex);
/* 169 */     return wrapperStatus == 1;
/*     */   }
/*     */ 
/*     */   private byte getWrapperStatusAttribute(CtMember member, int transformationIndex)
/*     */   {
/* 182 */     byte[] attributeValue = member.getAttribute(this.transformationsStatus[transformationIndex]);
/* 183 */     if (attributeValue == null)
/*     */     {
/* 185 */       return 2;
/*     */     }
/* 187 */     return attributeValue[0];
/*     */   }
/*     */ 
/*     */   private void setWrapperStatusAttribute(CtMember member, int transformationIndex, byte status)
/*     */   {
/* 200 */     member.setAttribute(this.transformationsStatus[transformationIndex], new byte[] { status });
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.WrapperTransformer
 * JD-Core Version:    0.6.0
 */