/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.standalone.Compiler;
/*     */ 
/*     */ public class TransformerCommon
/*     */ {
/*  53 */   static final URL[] NO_URLS = new URL[0];
/*  54 */   static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
/*  55 */   static final String WEAK_REFERENCE = WeakReference.class.getName();
/*     */ 
/*     */   public static boolean isCompileTime()
/*     */   {
/*  59 */     return Compiler.loader != null;
/*     */   }
/*     */ 
/*     */   public static void compileOrLoadClass(CtClass classForPackage, CtClass newClass)
/*     */   {
/*  64 */     compileOrLoadClass(classForPackage, newClass, isCompileTime());
/*     */   }
/*     */ 
/*     */   public static void compileOrLoadClass(CtClass classForPackage, CtClass newClass, boolean compile)
/*     */   {
/*     */     try
/*     */     {
/*  77 */       registerGeneratedClass(newClass);
/*     */ 
/*  79 */       if (compile)
/*     */       {
/*  82 */         URLClassLoader loader = Compiler.loader;
/*  83 */         if (loader == null)
/*     */         {
/*  85 */           loader = new URLClassLoader(NO_URLS, SecurityActions.getContextClassLoader());
/*     */         }
/*  87 */         URL url = loader.getResource(classForPackage.getName().replace('.', '/') + ".class");
/*     */ 
/*  89 */         String path = url.toString();
/*  90 */         path = path.substring(0, path.lastIndexOf('/') + 1);
/*  91 */         path = path + newClass.getSimpleName() + ".class";
/*  92 */         URI newUrl = new URI(path);
/*  93 */         File file = new File(newUrl);
/*  94 */         FileOutputStream fp = new FileOutputStream(file);
/*  95 */         fp.write(newClass.toBytecode());
/*  96 */         fp.close();
/*     */       }
/* 101 */       else if (System.getSecurityManager() == null)
/*     */       {
/* 103 */         ToClassAction.NON_PRIVILEGED.toClass(newClass, null, null);
/*     */       }
/*     */       else
/*     */       {
/* 107 */         ToClassAction.PRIVILEGED.toClass(newClass, null, null);
/*     */       }
/*     */ 
/* 111 */       if (AspectManager.debugClasses)
/*     */       {
/* 113 */         newClass.debugWriteFile();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 118 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Class toClass(CtClass newClass, ProtectionDomain pd) throws CannotCompileException
/*     */   {
/* 124 */     registerGeneratedClass(newClass);
/*     */ 
/* 126 */     if (System.getSecurityManager() == null)
/*     */     {
/* 128 */       return ToClassAction.NON_PRIVILEGED.toClass(newClass, null, pd);
/*     */     }
/*     */ 
/* 132 */     return ToClassAction.PRIVILEGED.toClass(newClass, null, pd);
/*     */   }
/*     */ 
/*     */   public static Class toClass(CtClass newClass, ClassLoader loader, ProtectionDomain pd)
/*     */     throws CannotCompileException
/*     */   {
/* 139 */     registerGeneratedClass(newClass);
/*     */ 
/* 141 */     if (System.getSecurityManager() == null)
/*     */     {
/* 143 */       return ToClassAction.NON_PRIVILEGED.toClass(newClass, loader, pd);
/*     */     }
/*     */ 
/* 147 */     return ToClassAction.PRIVILEGED.toClass(newClass, loader, pd);
/*     */   }
/*     */ 
/*     */   protected static void addInfoField(Instrumentor instrumentor, String infoClassName, String infoName, int modifiers, CtClass addTo, boolean weak, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 154 */     if (weak)
/*     */     {
/* 156 */       addWeakReferenceInfoField(instrumentor, infoClassName, infoName, modifiers, addTo, init);
/*     */     }
/*     */     else
/*     */     {
/* 160 */       addStrongReferenceInfoField(instrumentor, infoClassName, infoName, modifiers, addTo, init);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void registerGeneratedClass(CtClass newClass)
/*     */   {
/* 167 */     ClassPool pool = newClass.getClassPool();
/* 168 */     if ((pool instanceof AOPClassPool))
/*     */     {
/* 170 */       ((AOPClassPool)pool).registerGeneratedClass(newClass.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void addWeakReferenceInfoField(Instrumentor instrumentor, String infoClassName, String infoName, int modifiers, CtClass addTo, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 177 */     CtClass type = instrumentor.forName(WEAK_REFERENCE);
/* 178 */     CtField field = new CtField(type, infoName, addTo);
/* 179 */     field.setModifiers(modifiers);
/* 180 */     addTo.addField(field, init);
/*     */   }
/*     */ 
/*     */   private static void addStrongReferenceInfoField(Instrumentor instrumentor, String infoClassName, String infoName, int modifiers, CtClass addTo, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 186 */     CtClass type = instrumentor.forName(infoClassName);
/* 187 */     CtField field = new CtField(type, infoName, addTo);
/* 188 */     field.setModifiers(modifiers);
/* 189 */     addTo.addField(field, init);
/*     */   }
/*     */ 
/*     */   protected static String infoFromWeakReference(String infoClassName, String localName, String infoName)
/*     */   {
/* 194 */     return infoClassName + " " + localName + " = (" + infoClassName + ")" + infoName + ".get();";
/*     */   }
/*     */ 
/*     */   public static CtClass makeNestedClass(CtClass outer, String name, boolean isStatic, int modifiers, CtClass superClass)
/*     */     throws CannotCompileException
/*     */   {
/* 202 */     CtClass inner = makeNestedClass(outer, name, true);
/* 203 */     inner.setModifiers(modifiers);
/* 204 */     inner.setSuperclass(superClass);
/* 205 */     return inner;
/*     */   }
/*     */ 
/*     */   public static CtClass makeNestedClass(CtClass outer, String name, boolean isStatic)
/*     */     throws CannotCompileException
/*     */   {
/* 213 */     registerGeneratedClass(outer.getClassPool(), outer.getName() + "$" + name);
/* 214 */     CtClass inner = outer.makeNestedClass(name, true);
/* 215 */     return inner;
/*     */   }
/*     */ 
/*     */   public static CtClass makeClass(ClassPool pool, String name)
/*     */   {
/* 223 */     registerGeneratedClass(pool, name);
/* 224 */     return pool.makeClass(name);
/*     */   }
/*     */ 
/*     */   public static CtClass makeClass(ClassPool pool, String name, CtClass superClass)
/*     */   {
/* 232 */     registerGeneratedClass(pool, name);
/* 233 */     return pool.makeClass(name, superClass);
/*     */   }
/*     */ 
/*     */   private static void registerGeneratedClass(ClassPool pool, String name)
/*     */   {
/*     */     try
/*     */     {
/* 240 */       ((AOPClassPool)pool).registerGeneratedClass(name);
/*     */     }
/*     */     catch (ClassCastException e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface ToClassAction
/*     */   {
/* 253 */     public static final ToClassAction PRIVILEGED = new ToClassAction()
/*     */     {
/*     */       public Class toClass(CtClass clazz, ClassLoader loader, ProtectionDomain pd) throws CannotCompileException
/*     */       {
/*     */         Exception actual;
/*     */         try {
/* 260 */           return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(clazz, loader, pd)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/* 264 */               if (AspectManager.debugClasses)
/*     */               {
/* 266 */                 this.val$clazz.debugWriteFile();
/*     */               }
/* 268 */               return this.val$clazz.toClass(this.val$loader, this.val$pd);
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/* 274 */           actual = e.getException();
/* 275 */           if ((actual instanceof CannotCompileException))
/*     */           {
/* 277 */             throw ((CannotCompileException)actual);
/*     */           }
/*     */         }
/* 279 */         throw new RuntimeException(actual);
/*     */       }
/* 253 */     };
/*     */ 
/* 284 */     public static final ToClassAction NON_PRIVILEGED = new ToClassAction()
/*     */     {
/*     */       public Class toClass(CtClass clazz, ClassLoader loader, ProtectionDomain pd)
/*     */         throws CannotCompileException
/*     */       {
/* 289 */         if (AspectManager.debugClasses)
/*     */         {
/* 291 */           clazz.debugWriteFile();
/*     */         }
/* 293 */         return clazz.toClass(loader, pd);
/*     */       }
/* 284 */     };
/*     */ 
/*     */     public abstract Class toClass(CtClass paramCtClass, ClassLoader paramClassLoader, ProtectionDomain paramProtectionDomain)
/*     */       throws CannotCompileException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.TransformerCommon
 * JD-Core Version:    0.6.0
 */