/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static void setAccessible(AccessibleObject accessibleObject)
/*     */   {
/*  75 */     if (System.getSecurityManager() == null)
/*     */     {
/*  77 */       SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
/*     */     }
/*     */     else
/*     */     {
/*  81 */       SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/*  97 */     if (System.getSecurityManager() == null) {
/*  98 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/* 100 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*     */   }
/*     */ 
/*     */   public static class GetContextClassLoaderAction
/*     */     implements PrivilegedAction<ClassLoader>
/*     */   {
/*  87 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*     */ 
/*     */     public ClassLoader run()
/*     */     {
/*  91 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface SetAccessibleAction
/*     */   {
/*  43 */     public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction()
/*     */     {
/*     */       public void setAccessible(AccessibleObject accessibleObject)
/*     */       {
/*     */         try
/*     */         {
/*  49 */           AccessController.doPrivileged(new PrivilegedExceptionAction(accessibleObject)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/*  53 */               this.val$accessibleObject.setAccessible(true);
/*  54 */               return null;
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*  60 */           throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
/*     */         }
/*     */       }
/*  43 */     };
/*     */ 
/*  65 */     public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction()
/*     */     {
/*     */       public void setAccessible(AccessibleObject accessibleObject)
/*     */       {
/*  69 */         accessibleObject.setAccessible(true);
/*     */       }
/*  65 */     };
/*     */ 
/*     */     public abstract void setAccessible(AccessibleObject paramAccessibleObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.SecurityActions
 * JD-Core Version:    0.6.0
 */