/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class OptimizedMethodInvocations extends OptimizedBehaviourInvocations
/*     */ {
/*     */   static String getOptimizedInvocationClassName(CtClass clazz, CtMethod method)
/*     */   {
/*  46 */     long hash = JavassistMethodHashing.methodHash(method);
/*  47 */     StringBuffer sb = new StringBuffer(clazz.getName());
/*  48 */     sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
/*     */ 
/*  52 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static String getOptimizedInvocationClassName(Method method) throws Exception
/*     */   {
/*  57 */     long hash = MethodHashing.methodHash(method);
/*  58 */     StringBuffer sb = new StringBuffer(method.getDeclaringClass().getName());
/*  59 */     sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
/*     */ 
/*  63 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtMethod method, CtMethod notAdvisedMethod)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  70 */     AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
/*  71 */     CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
/*     */ 
/*  75 */     String className = getOptimizedInvocationClassName(clazz, method);
/*  76 */     boolean makeInnerClass = true;
/*  77 */     CtClass invocation = makeInvocationClass(pool, makeInnerClass, clazz, className, methodInvocation);
/*     */ 
/*  81 */     CtClass[] params = method.getParameterTypes();
/*  82 */     addArgumentFieldsAndAccessors(pool, invocation, params, true);
/*  83 */     boolean isStatic = Modifier.isStatic(method.getModifiers());
/*  84 */     if (!isStatic)
/*     */     {
/*  86 */       CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
/*  87 */       target.setModifiers(1);
/*  88 */       invocation.addField(target);
/*     */     }
/*     */ 
/*  93 */     addDispatch(invocation, "invokeTarget", notAdvisedMethod, isStatic);
/*     */ 
/*  97 */     addCopy(invocation, method.getParameterTypes(), isStatic);
/*     */ 
/* 101 */     TransformerCommon.compileOrLoadClass(method.getDeclaringClass(), invocation);
/*     */ 
/* 104 */     return invocation.getName();
/*     */   }
/*     */ 
/*     */   static final void addDispatch(CtClass invocation, String methodName, CtMethod method, boolean isStatic)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 122 */     StringBuffer dispatchLine = new StringBuffer();
/* 123 */     boolean isVoid = method.getReturnType().equals(CtClass.voidType);
/* 124 */     if (!isVoid)
/*     */     {
/* 126 */       dispatchLine.append("return ($w)");
/*     */     }
/* 128 */     dispatchLine.append(isStatic ? method.getDeclaringClass().getName() : " typedTargetObject");
/*     */ 
/* 130 */     dispatchLine.append('.');
/* 131 */     dispatchLine.append(method.getName());
/* 132 */     addDispatch(invocation, methodName, method.getParameterTypes(), dispatchLine.toString(), "", isVoid ? "  return null;" : "");
/*     */   }
/*     */ 
/*     */   static void addCopy(CtClass invocation, CtClass[] params, boolean isStatic)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 139 */     CtMethod template = invocation.getSuperclass().getDeclaredMethod("copy");
/*     */ 
/* 141 */     StringBuffer code = new StringBuffer("{");
/* 142 */     code.append("   ").append(invocation.getName()).append(" wrapper = new ");
/* 143 */     code.append(invocation.getName());
/* 144 */     code.append("(this.interceptors, methodHash, advisedMethod, unadvisedMethod, advisor); ");
/* 145 */     code.append("   wrapper.arguments = this.arguments; ");
/* 146 */     code.append("   wrapper.metadata = this.metadata; ");
/* 147 */     code.append("   wrapper.currentInterceptor = this.currentInterceptor; ");
/* 148 */     code.append("   wrapper.instanceResolver = this.instanceResolver; ");
/* 149 */     if (!isStatic)
/*     */     {
/* 151 */       code.append("   wrapper.typedTargetObject = this.typedTargetObject; ");
/* 152 */       code.append("   wrapper.targetObject = this.targetObject; ");
/*     */     }
/* 154 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 156 */       code.append("   wrapper.arg").append(i).append(" = this.arg").append(i).append("; ");
/*     */     }
/* 158 */     code.append("   return wrapper; }");
/*     */ 
/* 160 */     CtMethod copy = CtNewMethod.make(template.getReturnType(), "copy", template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
/*     */ 
/* 163 */     copy.setModifiers(template.getModifiers());
/* 164 */     invocation.addMethod(copy);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedMethodInvocations
 * JD-Core Version:    0.6.0
 */