/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ 
/*     */ public class OptimizedMethodExecutionTransformer extends MethodExecutionTransformer
/*     */ {
/*     */   public OptimizedMethodExecutionTransformer(Instrumentor instrumentor)
/*     */   {
/*  44 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected void transformMethod(MethodExecutionTransformer.MethodTransformation trans, boolean wrap) throws CannotCompileException, NotFoundException
/*     */   {
/*  49 */     String methodInfoField = addMethodInfoField(10, trans.getClazz(), trans);
/*  50 */     String wrappedName = ClassAdvisor.notAdvisedMethodName(trans.getClazzName(), trans.getOriginalName());
/*     */ 
/*  52 */     CtMethod wmethod = CtNewMethod.copy(trans.getMethod(), trans.getClazz(), null);
/*     */ 
/*  55 */     String originalName = trans.getOriginalName();
/*  56 */     wmethod.setName(wrappedName);
/*  57 */     trans.getClazz().addMethod(wmethod);
/*  58 */     moveAnnotationsAndCopySignature(trans.getMethod(), wmethod);
/*  59 */     String optimizedInvocation = OptimizedMethodInvocations.createOptimizedInvocationClass(trans.getInstrumentor(), trans.getClazz(), trans.getMethod(), wmethod);
/*  60 */     trans.getMethod().setName(wrappedName);
/*  61 */     wmethod.setName(originalName);
/*     */ 
/*  63 */     trans.setWMethod(wmethod, wrappedName);
/*     */ 
/*  65 */     getWrapper().prepareForWrapping(wmethod, 0);
/*     */ 
/*  67 */     if (wrap)
/*     */     {
/*  70 */       getWrapper().wrap(wmethod, 0);
/*     */ 
/*  72 */       setWrapperBody(trans, methodInfoField, optimizedInvocation);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void doWrap(MethodExecutionTransformer.MethodTransformation trans, String methodInfoFieldName) throws NotFoundException, Exception
/*     */   {
/*  78 */     String invocationClassName = OptimizedMethodInvocations.getOptimizedInvocationClassName(trans.getClazz(), trans.getWMethod());
/*  79 */     invocationClassName = invocationClassName.substring(invocationClassName.lastIndexOf('.') + 1);
/*  80 */     invocationClassName = trans.getMethod().getDeclaringClass().getName() + "$" + invocationClassName;
/*  81 */     setWrapperBody(trans, methodInfoFieldName, invocationClassName);
/*     */   }
/*     */ 
/*     */   protected void setWrapperBody(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField, String optimizedInvocation) throws NotFoundException
/*     */   {
/*  86 */     boolean isStatic = Modifier.isStatic(trans.getMethod().getModifiers());
/*  87 */     String code = null;
/*  88 */     if (!isStatic)
/*     */     {
/*  90 */       code = "{     " + methodInfoFromWeakReference("info", methodInfoField) + "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)_getInstanceAdvisor();" + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors();" + "    if (interceptors != (Object[])null || (instAdv != null && instAdv.hasInstanceAspects)) " + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(info, interceptors); " + "       " + OptimizedBehaviourInvocations.setArguments(trans.getMethod().getParameterTypes().length) + "       invocation.setTargetObject(this); " + "       invocation.typedTargetObject = this; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       " + getAopReturnStr(trans.getMethod()) + "invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + getReturnStr(trans.getMethod()) + " " + trans.getWrappedName() + "($$); " + "    }" + "}";
/*     */     }
/*     */     else
/*     */     {
/* 116 */       code = "{     " + methodInfoFromWeakReference("info", methodInfoField) + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors();" + "    if (interceptors != (Object[])null) " + "    { " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(info, interceptors); " + "       " + OptimizedBehaviourInvocations.setArguments(trans.getMethod().getParameterTypes().length) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       " + getAopReturnStr(trans.getMethod()) + "invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + getReturnStr(trans.getMethod()) + " " + trans.getWrappedName() + "($$); " + "    }" + "}";
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 135 */       trans.setWMethodBody(code);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 139 */       e.printStackTrace();
/* 140 */       throw new RuntimeException("code was: " + code + " for method " + trans.getOriginalName());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedMethodExecutionTransformer
 * JD-Core Version:    0.6.0
 */