/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ 
/*     */ public abstract class OptimizedInvocations
/*     */ {
/*     */   public static void defrostClassIfExists(AOPClassPool pool, String className)
/*     */   {
/*  45 */     CtClass existing = pool.getCached(className);
/*  46 */     if (existing != null)
/*     */     {
/*  48 */       existing.defrost();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static CtClass makeInvocationClass(AOPClassPool pool, boolean makeInnerClass, CtClass outerClass, String className, CtClass superInvocation)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/*  68 */     CtClass invocation = makeInvocationClassNoCtors(pool, makeInnerClass, outerClass, className, superInvocation);
/*     */ 
/*  71 */     CtConstructor[] cons = superInvocation.getDeclaredConstructors();
/*  72 */     for (int i = 0; i < cons.length; i++)
/*     */     {
/*  74 */       CtConstructor conTemplate = superInvocation.getDeclaredConstructors()[i];
/*  75 */       CtConstructor icon = CtNewConstructor.make(conTemplate.getParameterTypes(), conTemplate.getExceptionTypes(), invocation);
/*     */ 
/*  78 */       invocation.addConstructor(icon);
/*     */     }
/*     */ 
/*  81 */     return invocation;
/*     */   }
/*     */ 
/*     */   public static CtClass makeInvocationClassNoCtors(AOPClassPool pool, boolean makeInnerClass, CtClass outerClass, String className, CtClass superInvocation)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/*  90 */     CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
/*     */     CtClass invocation;
/*  93 */     if (makeInnerClass)
/*     */     {
/*  96 */       String innerClassName = className.substring(className.lastIndexOf('.') + 1);
/*  97 */       defrostClassIfExists(pool, outerClass.getName() + "$" + innerClassName);
/*     */ 
/* 100 */       boolean classStatic = true;
/* 101 */       CtClass invocation = TransformerCommon.makeNestedClass(outerClass, innerClassName, classStatic);
/* 102 */       invocation.setSuperclass(superInvocation);
/*     */     }
/*     */     else
/*     */     {
/* 106 */       defrostClassIfExists(pool, className);
/* 107 */       invocation = TransformerCommon.makeClass(pool, className, superInvocation);
/*     */     }
/*     */ 
/* 110 */     invocation.addInterface(untransformable);
/* 111 */     return invocation;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedInvocations
 * JD-Core Version:    0.6.0
 */