/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ 
/*     */ public class OptimizedConstructorInvocations extends OptimizedBehaviourInvocations
/*     */ {
/*     */   protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex)
/*     */   {
/*  52 */     return declaringClazz.getName() + "_" + constructorIndex + "OptimizedConstructorInvocation";
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  59 */     AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
/*  60 */     CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
/*     */ 
/*  64 */     String className = getOptimizedInvocationClassName(clazz, index);
/*  65 */     boolean makeInnerClass = !Modifier.isPublic(con.getModifiers());
/*  66 */     CtClass invocation = makeInvocationClassNoCtors(pool, makeInnerClass, clazz, className, conInvocation);
/*     */ 
/*  69 */     CtConstructor template = conInvocation.getDeclaredConstructors()[0];
/*  70 */     CtConstructor icon = CtNewConstructor.make(template.getParameterTypes(), template.getExceptionTypes(), invocation);
/*     */ 
/*  72 */     invocation.addConstructor(icon);
/*     */ 
/*  76 */     CtClass[] params = con.getParameterTypes();
/*  77 */     addArgumentFieldsAndAccessors(pool, invocation, params, false);
/*     */ 
/*  81 */     addDispatch(invocation, "invokeTarget", con);
/*     */ 
/*  85 */     addCopy(invocation, con.getParameterTypes());
/*     */ 
/*  89 */     TransformerCommon.compileOrLoadClass(clazz, invocation);
/*     */ 
/*  92 */     return invocation.getName();
/*     */   }
/*     */ 
/*     */   public static final void addDispatch(CtClass invocation, String methodName, CtConstructor constructor)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 110 */     StringBuffer dispatchLine = new StringBuffer("   result = new ");
/* 111 */     dispatchLine.append(constructor.getDeclaringClass().getName());
/* 112 */     OptimizedBehaviourInvocations.addDispatch(invocation, methodName, constructor.getParameterTypes(), dispatchLine.toString(), "Object result = null;", "   setTargetObject(result);   return result;");
/*     */   }
/*     */ 
/*     */   private static void addCopy(CtClass invocation, CtClass[] params)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 120 */     CtMethod template = invocation.getSuperclass().getDeclaredMethod("copy");
/*     */ 
/* 122 */     StringBuffer code = new StringBuffer("{    ");
/* 123 */     code.append(invocation.getName()).append(" wrapper = new ");
/* 124 */     code.append(invocation.getName()).append("(this.interceptors); ");
/* 125 */     code.append("   wrapper.constructor = this.constructor; ");
/* 126 */     code.append("   wrapper.arguments = this.arguments; ");
/* 127 */     code.append("   wrapper.metadata = this.metadata; ");
/* 128 */     code.append("   wrapper.currentInterceptor = this.currentInterceptor; ");
/*     */ 
/* 130 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 132 */       code.append("   wrapper.arg" + i + " = this.arg" + i + "; ");
/*     */     }
/* 134 */     code.append("   return wrapper; }");
/*     */ 
/* 136 */     CtMethod copy = CtNewMethod.make(template.getReturnType(), "copy", template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
/*     */ 
/* 139 */     copy.setModifiers(template.getModifiers());
/* 140 */     invocation.addMethod(copy);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedConstructorInvocations
 * JD-Core Version:    0.6.0
 */