/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ 
/*     */ public class OptimizedConstructionInvocations extends OptimizedBehaviourInvocations
/*     */ {
/*     */   protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex)
/*     */   {
/*  51 */     return declaringClazz.getName() + constructorIndex + "OptimizedConstructionInvocation";
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index)
/*     */     throws Exception
/*     */   {
/*  58 */     AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
/*  59 */     CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
/*     */ 
/*  63 */     String className = getOptimizedInvocationClassName(clazz, index);
/*  64 */     boolean makeInnerClass = !Modifier.isPublic(con.getModifiers());
/*  65 */     CtClass invocation = makeInvocationClassNoCtors(pool, makeInnerClass, clazz, className, conInvocation);
/*     */ 
/*  67 */     CtConstructor template = null;
/*  68 */     CtConstructor[] tcons = conInvocation.getDeclaredConstructors();
/*  69 */     for (int i = 0; i < tcons.length; i++)
/*     */     {
/*  71 */       if (tcons[i].getParameterTypes().length != 2)
/*     */         continue;
/*  73 */       template = tcons[i];
/*  74 */       break;
/*     */     }
/*     */ 
/*  77 */     CtConstructor icon = CtNewConstructor.make(template.getParameterTypes(), template.getExceptionTypes(), invocation);
/*     */ 
/*  79 */     invocation.addConstructor(icon);
/*     */ 
/*  83 */     addArgumentFieldsAndAccessors(pool, invocation, con.getParameterTypes(), false);
/*     */ 
/*  87 */     addCopy(invocation, con.getParameterTypes());
/*     */ 
/*  91 */     TransformerCommon.compileOrLoadClass(con.getDeclaringClass(), invocation);
/*     */ 
/*  94 */     return invocation.getName();
/*     */   }
/*     */ 
/*     */   protected static void addCopy(CtClass invocation, CtClass[] params) throws Exception
/*     */   {
/*  99 */     CtMethod template = invocation.getSuperclass().getDeclaredMethod("copy");
/* 100 */     StringBuffer code = new StringBuffer("{    ");
/* 101 */     code.append(invocation.getName()).append(" wrapper = new ");
/* 102 */     code.append(invocation.getName());
/* 103 */     code.append("(this.interceptors, this.constructor); ");
/* 104 */     code.append("   wrapper.metadata = this.metadata; ");
/* 105 */     code.append("   wrapper.currentInterceptor = this.currentInterceptor; ");
/* 106 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 108 */       code.append("   wrapper.arg" + i + " = this.arg" + i + "; ");
/*     */     }
/* 110 */     code.append("   return wrapper; }");
/*     */ 
/* 112 */     CtMethod copy = CtNewMethod.make(template.getReturnType(), "copy", template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
/*     */ 
/* 115 */     copy.setModifiers(template.getModifiers());
/* 116 */     invocation.addMethod(copy);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedConstructionInvocations
 * JD-Core Version:    0.6.0
 */