/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class OptimizedCallerInvocations extends OptimizedBehaviourInvocations
/*     */ {
/*  46 */   private static final Logger logger = AOPLogger.getLogger(OptimizedBehaviourInvocations.class);
/*     */ 
/*     */   protected static String createOptimizedMethodCalledByConInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, int callingIndex, long calledHash)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  56 */     return createOptimizedMethodCalledInvocationClass(instrumentor, className, callingClass, method, "org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation", "this.calling, ");
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedMethodCalledByMethodInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, long callingHash, long calledHash)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  70 */     return createOptimizedMethodCalledInvocationClass(instrumentor, className, callingClass, method, "org.jboss.aop.joinpoint.MethodCalledByMethodInvocation", "this.callingClass, this.callingMethod, ");
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedConCalledByConInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, int callingIndex, long calledHash)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  84 */     return createOptimizedConCalledInvocationClass(instrumentor, className, callingClass, con, "org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation", "this.calling, ");
/*     */   }
/*     */ 
/*     */   protected static String createOptimizedConCalledByMethodInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, long callingHash, long calledHash)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  98 */     return createOptimizedConCalledInvocationClass(instrumentor, className, callingClass, con, "org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation", "this.callingClass, this.callingMethod, ");
/*     */   }
/*     */ 
/*     */   private static String createOptimizedMethodCalledInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, String invocationClassName, String callerDescription)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 109 */     AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
/* 110 */     CtClass methodInvocation = pool.get(invocationClassName);
/*     */ 
/* 114 */     CtClass invocation = makeInvocationClass(pool, Modifier.isPrivate(method.getModifiers()), callingClass, className, methodInvocation);
/*     */ 
/* 120 */     CtClass[] params = method.getParameterTypes();
/* 121 */     addArgumentFieldsAndAccessors(pool, invocation, params, false);
/* 122 */     boolean isStatic = Modifier.isStatic(method.getModifiers());
/* 123 */     if (!isStatic)
/*     */     {
/* 125 */       CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
/*     */ 
/* 127 */       target.setModifiers(1);
/* 128 */       invocation.addField(target);
/*     */     }
/*     */ 
/* 133 */     OptimizedMethodInvocations.addDispatch(invocation, "invokeTarget", method, isStatic);
/*     */ 
/* 138 */     String copy = "";
/* 139 */     if (!Modifier.isStatic(method.getModifiers()))
/*     */     {
/* 141 */       copy = "wrapper.typedTargetObject = typedTargetObject;";
/*     */     }
/* 143 */     addCopyMethod(invocation, callerDescription, "this.method, this.callingObject, this.targetObject, ", copy, params.length);
/*     */ 
/* 149 */     TransformerCommon.compileOrLoadClass(callingClass, invocation);
/*     */ 
/* 152 */     return invocation.getName();
/*     */   }
/*     */ 
/*     */   private static String createOptimizedConCalledInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, String invocationClassName, String callerDescription)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 160 */     AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
/* 161 */     CtClass conInvocation = pool.get(invocationClassName);
/*     */ 
/* 165 */     CtClass invocation = makeInvocationClass(pool, Modifier.isPrivate(con.getModifiers()), callingClass, className, conInvocation);
/*     */ 
/* 171 */     CtClass[] params = con.getParameterTypes();
/* 172 */     addArgumentFieldsAndAccessors(pool, invocation, params, false);
/*     */ 
/* 176 */     OptimizedConstructorInvocations.addDispatch(invocation, "invokeTarget", con);
/*     */ 
/* 180 */     addCopyMethod(invocation, callerDescription, "this.constructor, this.wrappingMethod, this.callingObject, ", "", params.length);
/*     */ 
/* 186 */     TransformerCommon.compileOrLoadClass(callingClass, invocation);
/*     */ 
/* 189 */     return invocation.getName();
/*     */   }
/*     */ 
/*     */   private static void addCopyMethod(CtClass invocation, String callerDescription, String calledDescription, String copyText, int paramsLength)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 197 */     CtMethod copyTemplate = invocation.getSuperclass().getDeclaredMethod("copy");
/*     */ 
/* 199 */     String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.advisor, " + callerDescription + calledDescription + "this.arguments, this.interceptors);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.responseContextInfo = this.responseContextInfo; " + copyText;
/*     */ 
/* 212 */     for (int i = 0; i < paramsLength; i++)
/*     */     {
/* 214 */       copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
/*     */     }
/* 216 */     copyCode = copyCode + "   return wrapper; }";
/*     */ 
/* 218 */     CtMethod copy = null;
/*     */     try
/*     */     {
/* 221 */       copy = CtNewMethod.make(copyTemplate.getReturnType(), "copy", copyTemplate.getParameterTypes(), copyTemplate.getExceptionTypes(), copyCode, invocation);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 231 */       logger.error(copyCode);
/* 232 */       throw e;
/*     */     }
/* 234 */     copy.setModifiers(copyTemplate.getModifiers());
/* 235 */     invocation.addMethod(copy);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedCallerInvocations
 * JD-Core Version:    0.6.0
 */