/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.util.JavassistToReflect;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class OptimizedBehaviourInvocations extends OptimizedInvocations
/*     */ {
/*  46 */   private static final Logger logger = AOPLogger.getLogger(OptimizedBehaviourInvocations.class);
/*     */   public static final String ENFORCE_ARGS_CONSISTENCY = "enforceArgsConsistency";
/*     */   protected static final String INVOKE_TARGET = "invokeTarget";
/*     */   static final String GET_ARGUMENTS = "getArguments";
/*     */   private static final String SET_ARGUMENTS = "setArguments";
/*     */ 
/*     */   protected static String setArguments(int length)
/*     */   {
/*  70 */     return setArguments("invocation", length, 0);
/*     */   }
/*     */ 
/*     */   protected static void addArgumentFieldsAndAccessors(ClassPool pool, CtClass invocation, CtClass[] params, boolean hasMarshalledArguments)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  88 */     addArgumentFieldsToInvocation(invocation, params);
/*  89 */     addGetArguments(pool, invocation, params, hasMarshalledArguments);
/*  90 */     addSetArguments(pool, invocation, params);
/*  91 */     addEnforceArgsConsistency(invocation, params);
/*     */   }
/*     */ 
/*     */   protected static void addDispatch(CtClass invocation, String methodName, CtClass[] params, String dispatchLine, String beforeDispatch, String afterDispatch)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 123 */     StringBuffer sb = new StringBuffer("{");
/* 124 */     sb.append(beforeDispatch);
/* 125 */     sb.append("enforceArgsConsistency").append("();");
/* 126 */     sb.append(dispatchLine);
/* 127 */     if (params.length == 0)
/*     */     {
/* 129 */       sb.append("();");
/*     */     }
/*     */     else
/*     */     {
/* 133 */       sb.append("(arg0");
/* 134 */       for (int i = 1; i < params.length; i++)
/*     */       {
/* 136 */         sb.append(", ");
/* 137 */         sb.append("arg");
/* 138 */         sb.append(i);
/*     */       }
/* 140 */       sb.append(");");
/*     */     }
/* 142 */     sb.append(afterDispatch);
/* 143 */     sb.append("}");
/* 144 */     CtMethod dispatch = null;
/* 145 */     CtMethod in = invocation.getSuperclass().getDeclaredMethod("invokeTarget");
/*     */     try
/*     */     {
/* 148 */       dispatch = CtNewMethod.make(in.getReturnType(), methodName, in.getParameterTypes(), in.getExceptionTypes(), sb.toString(), invocation);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 156 */       logger.error(sb.toString());
/* 157 */       throw e;
/*     */     }
/* 159 */     dispatch.setModifiers(in.getModifiers());
/* 160 */     invocation.addMethod(dispatch);
/*     */   }
/*     */ 
/*     */   private static String setArguments(String inv, int length, int offset)
/*     */   {
/* 165 */     StringBuffer sb = new StringBuffer("");
/* 166 */     for (int i = 0; i < length; i++)
/*     */     {
/* 168 */       sb.append(inv + ".arg" + i + " = $" + (i + 1 + offset) + "; ");
/*     */     }
/* 170 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   private static void addSetArguments(ClassPool pool, CtClass invocation, CtClass[] params)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 176 */     if (params.length == 0) return;
/* 177 */     CtClass methodInvocation = pool.get(MethodInvocation.class.getName());
/* 178 */     CtMethod template = methodInvocation.getDeclaredMethod("setArguments");
/*     */ 
/* 180 */     StringBuffer code = new StringBuffer("{");
/* 181 */     code.append("   inconsistentArgs = true;");
/* 182 */     code.append("   arguments = $1; ");
/* 183 */     code.append("}");
/* 184 */     CtMethod setArguments = null;
/*     */     try
/*     */     {
/* 187 */       setArguments = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 195 */       logger.error(code.toString());
/* 196 */       throw e;
/*     */     }
/* 198 */     setArguments.setModifiers(template.getModifiers());
/* 199 */     invocation.addMethod(setArguments);
/*     */   }
/*     */ 
/*     */   private static void addGetArguments(ClassPool pool, CtClass invocation, CtClass[] params, boolean hasMarshalledArguments) throws CannotCompileException
/*     */   {
/*     */     try {
/* 205 */       CtClass methodInvocation = pool.get(MethodInvocation.class.getName());
/* 206 */       CtMethod template = methodInvocation.getDeclaredMethod("getArguments");
/*     */ 
/* 208 */       StringBuffer code = new StringBuffer();
/* 209 */       code.append("{ ");
/* 210 */       if (params.length != 0)
/*     */       {
/* 212 */         code.append("   inconsistentArgs = true;");
/*     */       }
/*     */ 
/* 215 */       if (hasMarshalledArguments)
/*     */       {
/* 217 */         code.append("   if (super.marshalledArguments != null)");
/* 218 */         code.append("   {");
/* 219 */         code.append("      Object[] args = super.").append("getArguments");
/* 220 */         code.append("();      ");
/* 221 */         code.append("setArguments").append("(args);");
/* 222 */         code.append("      return args;");
/* 223 */         code.append("   }");
/*     */       }
/*     */ 
/* 226 */       code.append("   if (arguments != (Object[])null) { return (Object[])arguments; } ");
/* 227 */       code.append("   arguments = new Object[" + params.length + "]; ");
/* 228 */       for (int i = 0; i < params.length; i++)
/*     */       {
/* 230 */         code.append("   arguments[" + i + "] = ($w)arg" + i + "; ");
/*     */       }
/*     */ 
/* 233 */       code.append("   return arguments; }");
/* 234 */       CtMethod getArguments = null;
/*     */       try
/*     */       {
/* 237 */         getArguments = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 245 */         logger.error(code.toString());
/* 246 */         throw e;
/*     */       }
/*     */ 
/* 249 */       getArguments.setModifiers(template.getModifiers());
/* 250 */       invocation.addMethod(getArguments);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void addEnforceArgsConsistency(CtClass invocation, CtClass[] params)
/*     */     throws CannotCompileException
/*     */   {
/* 271 */     StringBuffer code = new StringBuffer();
/* 272 */     code.append("{ ");
/* 273 */     if (params.length != 0)
/*     */     {
/* 275 */       code.append("if(inconsistentArgs) {");
/* 276 */       code.append("arg0 = ");
/* 277 */       code.append(JavassistToReflect.castInvocationValueToTypeString(params[0], "arguments[0]"));
/*     */ 
/* 279 */       for (int i = 1; i < params.length; i++)
/*     */       {
/* 281 */         code.append("; arg").append(i).append('=');
/* 282 */         code.append(JavassistToReflect.castInvocationValueToTypeString(params[i], "arguments[" + i + "]"));
/*     */       }
/*     */ 
/* 285 */       code.append("; }");
/*     */     }
/* 287 */     code.append('}');
/*     */ 
/* 289 */     CtMethod enforceArgsConsistency = null;
/*     */     try
/*     */     {
/* 292 */       enforceArgsConsistency = CtNewMethod.make(CtClass.voidType, "enforceArgsConsistency", new CtClass[0], new CtClass[0], code.toString(), invocation);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 300 */       logger.error(code.toString());
/* 301 */       throw e;
/*     */     }
/* 303 */     enforceArgsConsistency.setModifiers(16);
/* 304 */     invocation.addMethod(enforceArgsConsistency);
/*     */   }
/*     */ 
/*     */   private static void addArgumentFieldsToInvocation(CtClass invocation, CtClass[] params)
/*     */     throws CannotCompileException
/*     */   {
/* 315 */     if (params.length == 0)
/*     */     {
/* 317 */       return;
/*     */     }
/* 319 */     CtField inconsistentArgs = new CtField(CtClass.booleanType, "inconsistentArgs", invocation);
/*     */ 
/* 321 */     invocation.addField(inconsistentArgs, CtField.Initializer.byExpr("false"));
/*     */ 
/* 323 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 325 */       CtField field = new CtField(params[i], "arg" + i, invocation);
/* 326 */       field.setModifiers(1);
/* 327 */       invocation.addField(field);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedBehaviourInvocations
 * JD-Core Version:    0.6.0
 */