/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import javassist.CannotCompileException;
/*    */ import javassist.CtClass;
/*    */ import javassist.NotFoundException;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.ClassAdvisor;
/*    */ 
/*    */ public class NonOptimizedCallerTransformer extends CallerTransformer
/*    */ {
/*    */   public static final String PLACEHOLDER = "whatever";
/*    */ 
/*    */   public NonOptimizedCallerTransformer(Instrumentor instrumentor, AspectManager manager)
/*    */   {
/* 44 */     super(instrumentor, manager, false, new ClassicCallerInfoAdder(instrumentor));
/*    */   }
/*    */ 
/*    */   protected CallerTransformer.CallerExprEditor callerExprEditorFactory(ClassAdvisor advisor, CtClass clazz)
/*    */   {
/* 49 */     return new NonOptimizedCallerExprEditor(advisor, clazz);
/*    */   }
/*    */ 
/*    */   class NonOptimizedCallerExprEditor extends CallerTransformer.CallerExprEditor
/*    */   {
/*    */     public NonOptimizedCallerExprEditor(ClassAdvisor advisor, CtClass callingClass)
/*    */     {
/* 57 */       super(advisor, callingClass);
/*    */     }
/*    */ 
/*    */     protected void setupConstructor(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException
/*    */     {
/* 62 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*    */       {
/* 64 */         String invocationClassName = "whatever";
/*    */ 
/* 66 */         this.callerInfos.put(cd.callerInfoField, invocationClassName);
/* 67 */         NonOptimizedCallerTransformer.this.callerInfoAdder.addMethodByConInfoField(this.callingClass, cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
/*    */       }
/*    */     }
/*    */ 
/*    */     protected void setupMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException
/*    */     {
/* 73 */       if (this.callerInfos.get(md.callerInfoField) == null)
/*    */       {
/* 75 */         String invocationClassName = "whatever";
/*    */ 
/* 77 */         this.callerInfos.put(md.callerInfoField, invocationClassName);
/* 78 */         NonOptimizedCallerTransformer.this.callerInfoAdder.addMethodByMethodInfoField(this.callingClass, md.callerInfoField, md.callingHash, md.classname, md.calledHash);
/*    */       }
/*    */     }
/*    */ 
/*    */     protected void setupMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException
/*    */     {
/* 84 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*    */       {
/* 86 */         String invocationClassName = "whatever";
/*    */ 
/* 88 */         this.callerInfos.put(cd.callerInfoField, invocationClassName);
/* 89 */         NonOptimizedCallerTransformer.this.callerInfoAdder.addConByMethodInfoField(this.callingClass, cd.callerInfoField, cd.callingHash, cd.classname, cd.calledHash);
/*    */       }
/*    */     }
/*    */ 
/*    */     protected void setupConstructor(CallerTransformer.ConByConDetail cd) throws NotFoundException, CannotCompileException
/*    */     {
/* 95 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*    */       {
/* 97 */         String invocationClassName = "whatever";
/*    */ 
/* 99 */         this.callerInfos.put(cd.callerInfoField, invocationClassName);
/* 100 */         NonOptimizedCallerTransformer.this.callerInfoAdder.addConByConInfoField(this.callingClass, cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.NonOptimizedCallerTransformer
 * JD-Core Version:    0.6.0
 */