/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.joinpoint.MethodExecution;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class MethodJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*  53 */   private static final Class INVOCATION_TYPE = MethodInvocation.class;
/*  54 */   private static final Class JOINPOINT_TYPE = MethodExecution.class;
/*     */   private static final CtClass INVOCATION_CT_TYPE;
/*     */   WeakReference<Class<?>> returnType;
/*     */   boolean hasTargetObject;
/*     */ 
/*     */   public MethodJoinPointGenerator(GeneratedClassAdvisor advisor, MethodInfo info)
/*     */   {
/*  74 */     super(advisor, info, getParameters(info), info.getMethod().getParameterTypes().length, false);
/*     */ 
/*  76 */     if (super.getJoinpointField() != null)
/*     */     {
/*  78 */       if (!info.getUnadvisedMethod().getReturnType().equals(Void.TYPE))
/*     */       {
/*  80 */         this.returnType = new WeakReference(info.getUnadvisedMethod().getReturnType());
/*     */       }
/*  82 */       this.hasTargetObject = (!Modifier.isStatic(info.getMethod().getModifiers()));
/*     */     }
/*     */   }
/*     */ 
/*     */   private static JoinPointGenerator.JoinPointParameters getParameters(MethodInfo info)
/*     */   {
/*  89 */     if (Modifier.isStatic(info.getMethod().getModifiers()))
/*     */     {
/*  91 */       return JoinPointGenerator.JoinPointParameters.ONLY_ARGS;
/*     */     }
/*  93 */     return JoinPointGenerator.JoinPointParameters.TARGET_ARGS;
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/*  98 */     MethodInfo minfo = (MethodInfo)info;
/*  99 */     this.joinpointClassName = getGeneratedJoinPointClassName(advisedMethodName(minfo), methodHash(minfo));
/*     */ 
/* 103 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(advisedMethodName(minfo), methodHash(minfo));
/*     */   }
/*     */ 
/*     */   private String advisedMethodName(MethodInfo info)
/*     */   {
/* 110 */     return info.getMethod().getName();
/*     */   }
/*     */ 
/*     */   private long methodHash(MethodInfo info)
/*     */   {
/* 115 */     return info.getHash();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 120 */     return getReturnClassType() == null;
/*     */   }
/*     */ 
/*     */   protected Class getReturnClassType()
/*     */   {
/* 125 */     if (this.returnType == null)
/*     */     {
/* 127 */       return null;
/*     */     }
/* 129 */     return (Class)this.returnType.get();
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 134 */     Method method = ((MethodExecution)joinPoint).getMethod();
/* 135 */     return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, method.getGenericReturnType(), method.getGenericParameterTypes(), method.getParameterTypes(), method.getGenericExceptionTypes(), method.getDeclaringClass(), hasTargetObject());
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 152 */     return this.hasTargetObject;
/*     */   }
/*     */ 
/*     */   protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtMethod targetMethod, CtMethod wMethod, String miname, String originalMethodName, String wrappedMethodName, long hash)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 171 */     BaseClassGenerator factory = new BaseClassGenerator(instrumentor, advisedClass, targetMethod, wMethod, miname, originalMethodName, wrappedMethodName, hash);
/* 172 */     return factory.generate();
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(String methodName, long hash)
/*     */   {
/* 177 */     return "joinpoint_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
/*     */   }
/*     */ 
/*     */   private static String getGeneratedJoinPointClassName(String methodName, long hash)
/*     */   {
/* 182 */     return "JoinPoint_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  61 */       INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  65 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass advisedClass;
/*     */     CtMethod advisedMethod;
/*     */     CtMethod wMethod;
/*     */     String miname;
/*     */     String originalMethodName;
/*     */     String wrappedMethodName;
/*     */     long hash;
/*     */     boolean hasTargetObject;
/*     */     CtMethod targetMethod;
/*     */     CtClass jp;
/*     */     CtClass[] originalParams;
/*     */     CtClass[] params;
/*     */     CtClass methodInfoClass;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtMethod targetMethod, CtMethod wMethod, String miname, String originalMethodName, String wrappedMethodName, long hash)
/*     */       throws NotFoundException
/*     */     {
/* 207 */       this.instrumentor = instrumentor;
/* 208 */       this.advisedClass = advisedClass;
/* 209 */       this.advisedMethod = targetMethod;
/* 210 */       this.targetMethod = targetMethod;
/* 211 */       this.wMethod = wMethod;
/* 212 */       this.miname = miname;
/* 213 */       this.originalMethodName = originalMethodName;
/* 214 */       this.wrappedMethodName = wrappedMethodName;
/* 215 */       this.hash = hash;
/* 216 */       this.originalParams = targetMethod.getParameterTypes();
/* 217 */       this.params = GeneratedAdvisorMethodExecutionTransformer.addTargetToParamsForNonStaticMethod(advisedClass, targetMethod);
/* 218 */       this.methodInfoClass = instrumentor.forName("org.jboss.aop.MethodInfo");
/* 219 */       this.hasTargetObject = (!Modifier.isStatic(this.advisedMethod.getModifiers()));
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 224 */       this.jp = setupClass();
/*     */ 
/* 226 */       OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.originalParams, true);
/*     */ 
/* 228 */       if (this.hasTargetObject)
/*     */       {
/* 230 */         addTypedTargetField();
/*     */       }
/* 232 */       addInvokeJoinpointMethod();
/* 233 */       addMethodInfoField();
/* 234 */       addDefaultConstructor();
/* 235 */       addPublicConstructor();
/* 236 */       addProtectedConstructors();
/* 237 */       addDispatchMethods();
/*     */ 
/* 239 */       TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
/* 240 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 246 */       String className = MethodJoinPointGenerator.access$000(this.originalMethodName, this.hash);
/*     */ 
/* 249 */       this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true);
/* 250 */       int mod = this.jp.getModifiers();
/* 251 */       this.jp.setModifiers(mod | 0x1);
/*     */ 
/* 253 */       CtClass methodInvocation = MethodJoinPointGenerator.INVOCATION_CT_TYPE;
/* 254 */       this.jp.setSuperclass(methodInvocation);
/* 255 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/*     */ 
/* 257 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private void addTypedTargetField() throws CannotCompileException
/*     */     {
/* 262 */       CtField targetField = new CtField(this.advisedClass, "typedTargetObject", this.jp);
/* 263 */       this.jp.addField(targetField);
/* 264 */       targetField.setModifiers(132);
/*     */     }
/*     */ 
/*     */     private void addDefaultConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 272 */       CtConstructor defaultConstructor = CtNewConstructor.defaultConstructor(this.jp);
/* 273 */       this.jp.addConstructor(defaultConstructor);
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 283 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.methodInfoClass }, new CtClass[0], "{super($1, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 289 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException
/*     */     {
/* 298 */       CtClass[] ctorParams1 = new CtClass[this.params.length + 1];
/* 299 */       CtClass[] ctorParams2 = null;
/* 300 */       ctorParams1[0] = this.jp;
/*     */ 
/* 302 */       System.arraycopy(this.params, 0, ctorParams1, 1, this.params.length);
/*     */ 
/* 304 */       StringBuffer body = new StringBuffer();
/* 305 */       body.append("{");
/* 306 */       body.append("   this($1.info);");
/*     */ 
/* 308 */       int offset = 1;
/* 309 */       if (this.hasTargetObject)
/*     */       {
/* 311 */         offset = 2;
/*     */ 
/* 313 */         ctorParams2 = new CtClass[2];
/* 314 */         System.arraycopy(ctorParams1, 0, ctorParams2, 0, 2);
/*     */ 
/* 316 */         body.append("   this.typedTargetObject = $2;");
/* 317 */         body.append("   super.setTargetObject($2);");
/*     */       }
/*     */       else
/*     */       {
/* 321 */         ctorParams2 = new CtClass[1];
/* 322 */         ctorParams2[0] = ctorParams1[0];
/*     */       }
/*     */ 
/* 326 */       StringBuffer setArguments = new StringBuffer();
/* 327 */       for (int i = offset; i < ctorParams1.length; i++)
/*     */       {
/* 329 */         setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
/*     */       }
/*     */ 
/* 332 */       setArguments.append("}");
/*     */ 
/* 334 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
/*     */ 
/* 339 */       protectedConstructor.setModifiers(4);
/*     */ 
/* 341 */       this.jp.addConstructor(protectedConstructor);
/* 342 */       if (this.params.length > 1)
/*     */       {
/* 344 */         protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 349 */         protectedConstructor.setModifiers(4);
/* 350 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */     }
/*     */ 
/*     */     private CtMethod addInvokeJoinpointMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 360 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(this.advisedMethod.getReturnType(), "invokeJoinpoint", this.params, JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 367 */       invokeJoinpointMethod.setModifiers(4);
/* 368 */       this.jp.addMethod(invokeJoinpointMethod);
/* 369 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     private void addMethodInfoField() throws CannotCompileException
/*     */     {
/* 374 */       CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
/* 375 */       this.jp.addField(infoField);
/* 376 */       infoField.setModifiers(132);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 381 */       OptimizedMethodInvocations.addDispatch(this.jp, "dispatch", this.targetMethod, !this.hasTargetObject);
/*     */ 
/* 383 */       if (this.params.length > 0)
/*     */       {
/* 385 */         addInvokeJoinPointDispatchMethod();
/*     */       }
/*     */ 
/* 388 */       addInvokeTargetMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeJoinPointDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 395 */       int offset = this.hasTargetObject ? 1 : 0;
/* 396 */       StringBuffer parameters = new StringBuffer();
/* 397 */       for (int i = 0; i < this.originalParams.length; i++)
/*     */       {
/* 399 */         if (i > 0) parameters.append(", ");
/* 400 */         parameters.append("$" + (i + offset + 1));
/*     */       }
/*     */ 
/* 403 */       String body = "{" + MethodExecutionTransformer.getAopReturnStr(this.advisedMethod) + "$1." + this.wrappedMethodName + "(" + parameters + ");}";
/*     */       try
/*     */       {
/* 410 */         CtMethod dispatch = CtNewMethod.make(this.advisedMethod.getReturnType(), "dispatch", this.params, this.advisedMethod.getExceptionTypes(), body, this.jp);
/*     */ 
/* 417 */         dispatch.setModifiers(4);
/* 418 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 422 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 428 */       CtMethod template = MethodJoinPointGenerator.INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
/*     */ 
/* 430 */       boolean isVoid = this.advisedMethod.getReturnType().equals(CtClass.voidType);
/* 431 */       String body = isVoid ? "{dispatch(); return null;}" : "{return ($w)dispatch();}";
/*     */ 
/* 433 */       CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
/*     */ 
/* 440 */       this.jp.addMethod(invokeTarget);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.MethodJoinPointGenerator
 * JD-Core Version:    0.6.0
 */