/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import java.util.LinkedHashMap;
/*    */ import javassist.CtMember;
/*    */ import javassist.NotFoundException;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.pointcut.Pointcut;
/*    */ import org.jboss.aop.util.logging.AOPLogger;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JoinpointSimpleClassifier extends JoinpointClassifier
/*    */ {
/* 51 */   private static final Logger logger = AOPLogger.getLogger(JoinpointSimpleClassifier.class);
/*    */ 
/*    */   protected JoinpointClassification classifyJoinpoint(CtMember member, Advisor advisor, JoinpointClassifier.Matcher joinpointMatcher)
/*    */     throws NotFoundException
/*    */   {
/* 62 */     Collection pointcuts = advisor.getManager().getPointcuts().values();
/*    */     Iterator it;
/* 63 */     synchronized (pointcuts)
/*    */     {
/* 65 */       for (it = pointcuts.iterator(); it.hasNext(); )
/*    */       {
/* 67 */         Pointcut pointcut = (Pointcut)it.next();
/*    */ 
/* 69 */         if (joinpointMatcher.matches(pointcut, advisor, member))
/*    */         {
/* 71 */           if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*    */           {
/* 73 */             logger.debug(member + " matches pointcut: " + pointcut.getExpr());
/*    */           }
/* 75 */           return JoinpointClassification.WRAPPED;
/*    */         }
/*    */       }
/*    */     }
/* 79 */     if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*    */     {
/* 81 */       logger.debug(member + " matches no pointcuts");
/*    */     }
/* 83 */     return JoinpointClassification.NOT_INSTRUMENTED;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.JoinpointSimpleClassifier
 * JD-Core Version:    0.6.0
 */