/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import java.util.LinkedHashMap;
/*    */ import javassist.CtMember;
/*    */ import javassist.NotFoundException;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.pointcut.Pointcut;
/*    */ import org.jboss.aop.pointcut.PointcutInfo;
/*    */ 
/*    */ public class JoinpointFullClassifier extends JoinpointClassifier
/*    */ {
/*    */   protected JoinpointClassification classifyJoinpoint(CtMember member, Advisor advisor, JoinpointClassifier.Matcher joinpointMatcher)
/*    */     throws NotFoundException
/*    */   {
/* 60 */     JoinpointClassification classification = JoinpointClassification.NOT_INSTRUMENTED;
/* 61 */     Collection pointcuts = advisor.getManager().getPointcutInfos().values();
/* 62 */     boolean dynamicAop = true;
/* 63 */     for (Iterator it = pointcuts.iterator(); it.hasNext(); )
/*    */     {
/* 65 */       PointcutInfo pointcutInfo = (PointcutInfo)it.next();
/*    */ 
/* 67 */       if ((classification == JoinpointClassification.PREPARED) && (pointcutInfo.getBinding() == null))
/*    */       {
/*    */         continue;
/*    */       }
/* 71 */       Pointcut pointcut = pointcutInfo.getPointcut();
/* 72 */       if (joinpointMatcher.matches(pointcut, advisor, member))
/*    */       {
/* 74 */         if (pointcutInfo.getBinding() == null)
/*    */         {
/* 76 */           classification = JoinpointClassification.PREPARED;
/*    */         }
/* 78 */         else if (pointcutInfo.isDynamicAop())
/*    */         {
/* 80 */           classification = JoinpointClassification.DYNAMICALY_WRAPPED;
/* 81 */           synchronized (pointcutInfo)
/*    */           {
/* 83 */             pointcutInfo.setDynamicAop(false);
/*    */           }
/*    */         }
/*    */         else
/*    */         {
/* 88 */           classification = JoinpointClassification.WRAPPED;
/*    */ 
/* 90 */           break;
/*    */         }
/*    */       }
/*    */     }
/* 94 */     return classification;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.JoinpointFullClassifier
 * JD-Core Version:    0.6.0
 */