/*      */ package org.jboss.aop.instrument;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Method;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.security.ProtectionDomain;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.List;
/*      */ import java.util.Set;
/*      */ import javassist.CannotCompileException;
/*      */ import javassist.ClassPool;
/*      */ import javassist.CtClass;
/*      */ import javassist.CtConstructor;
/*      */ import javassist.CtField;
/*      */ import javassist.CtMethod;
/*      */ import javassist.CtNewConstructor;
/*      */ import javassist.CtNewMethod;
/*      */ import javassist.Modifier;
/*      */ import javassist.NotFoundException;
/*      */ import org.jboss.aop.Advisor;
/*      */ import org.jboss.aop.AspectManager;
/*      */ import org.jboss.aop.CallerConstructorInfo;
/*      */ import org.jboss.aop.ClassAdvisor;
/*      */ import org.jboss.aop.GeneratedClassAdvisor;
/*      */ import org.jboss.aop.InstanceAdvisor;
/*      */ import org.jboss.aop.JoinPointInfo;
/*      */ import org.jboss.aop.advice.AdviceMethodProperties;
/*      */ import org.jboss.aop.advice.AdviceType;
/*      */ import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
/*      */ import org.jboss.aop.advice.InvalidAdviceException;
/*      */ import org.jboss.aop.advice.NoMatchingAdviceException;
/*      */ import org.jboss.aop.advice.Scope;
/*      */ import org.jboss.aop.advice.annotation.AdviceMethodFactory;
/*      */ import org.jboss.aop.joinpoint.Invocation;
/*      */ import org.jboss.aop.joinpoint.JoinPointBean;
/*      */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*      */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*      */ import org.jboss.aop.util.JavassistUtils;
/*      */ import org.jboss.aop.util.ReflectToJavassist;
/*      */ import org.jboss.aop.util.logging.AOPLogger;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public abstract class JoinPointGenerator
/*      */ {
/*   79 */   private static final Logger logger = AOPLogger.getLogger(JoinPointGenerator.class);
/*      */   public static final String INFO_FIELD = "info";
/*      */   public static final String INITIALISED_LIGHTWEIGHT_INSTANCE_ASPECTS = "initialisedLightweightInstanceAspects";
/*      */   public static final String INITIALISE_LIGHTWEIGHT_INSTANCE_ASPECTS = "initialisePerInstanceAspects";
/*      */   public static final String IS_FOR_INSTANCE_ADVISOR = "isForInstanceAdvisor";
/*      */   public static final String INVOKE_JOINPOINT = "invokeJoinpoint";
/*      */   public static final String INVOKE_TARGET = "invokeTarget";
/*      */   public static final String DISPATCH = "dispatch";
/*      */   protected static final String TARGET_FIELD = "targetObject";
/*      */   protected static final String TYPED_TARGET_FIELD = "typedTargetObject";
/*      */   protected static final String CALLER_FIELD = "callingObject";
/*      */   protected static final String TYPED_CALLER_FIELD = "typedCallingObject";
/*   92 */   protected static final String GENERATED_CLASS_ADVISOR = GeneratedClassAdvisor.class.getName();
/*      */   public static final String GENERATE_JOINPOINT_CLASS = "generateJoinPointClass";
/*      */   private static final String CURRENT_ADVICE = "super.currentInterceptor";
/*      */   public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_";
/*      */   public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_";
/*      */   private static final String RETURN_VALUE = "ret";
/*      */   private static final String THROWABLE = "t";
/*      */   protected static final String ARGUMENTS = "arguments";
/*      */   private static final String GET_ARGUMENTS = "getArguments()";
/*  101 */   protected static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
/*      */   protected static final CtClass[] THROWS_THROWABLE;
/*      */   private final ArrayList<Integer> joinPointArguments;
/*      */   private final boolean nullArgsArray;
/*      */   private JoinPointParameters parameters;
/*      */   private static int increment;
/*      */   private Class advisorClass;
/*      */   private String baseJoinPointClassName;
/*      */   protected String joinpointClassName;
/*      */   protected String joinpointFieldName;
/*      */   private String joinpointFqn;
/*      */   private Field joinpointField;
/*      */   private boolean initialised;
/*      */   private ThreadLocal<Set<Integer>> inconsistentTypeArgs;
/*  137 */   private HashMap<String, GeneratedClassInfo> generatedJoinPointClassCache = new HashMap();
/*      */ 
/*      */   protected JoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info, JoinPointParameters parameters, int argumentsSize, boolean nullArgsArray)
/*      */   {
/*  155 */     this.parameters = parameters;
/*      */ 
/*  157 */     this.advisorClass = advisor.getClass();
/*  158 */     this.nullArgsArray = nullArgsArray;
/*  159 */     Class[] interfaces = this.advisorClass.getInterfaces();
/*      */ 
/*  161 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/*  163 */       if (!interfaces[i].equals(InstanceAdvisor.class)) {
/*      */         continue;
/*      */       }
/*  166 */       this.advisorClass = this.advisorClass.getSuperclass();
/*  167 */       break;
/*      */     }
/*      */ 
/*  171 */     this.joinPointArguments = new ArrayList(argumentsSize);
/*      */ 
/*  173 */     for (int i = 0; i < argumentsSize; i++)
/*      */     {
/*  175 */       this.joinPointArguments.add(Integer.valueOf(i));
/*      */     }
/*      */ 
/*  181 */     this.inconsistentTypeArgs = new ThreadLocal()
/*      */     {
/*      */       protected synchronized Set<Integer> initialValue() {
/*  184 */         return new HashSet();
/*      */       }
/*      */     };
/*  188 */     initialiseJoinPointNames(info);
/*  189 */     findAdvisedField(info);
/*  190 */     initBaseJoinPointClassName(advisor);
/*      */   }
/*      */ 
/*      */   private void initBaseJoinPointClassName(GeneratedClassAdvisor advisor)
/*      */   {
/*  195 */     Package pkg = advisor.getClass().getPackage();
/*      */ 
/*  197 */     StringBuffer className = new StringBuffer();
/*  198 */     if (pkg != null)
/*      */     {
/*  200 */       className.append(pkg.getName());
/*  201 */       className.append(".");
/*      */     }
/*  203 */     className.append(this.joinpointClassName);
/*  204 */     className.append("_");
/*  205 */     this.baseJoinPointClassName = className.toString();
/*      */   }
/*      */ 
/*      */   public void rebindJoinpoint(JoinPointInfo newInfo)
/*      */   {
/*      */     try
/*      */     {
/*  212 */       if (this.joinpointField == null) return;
/*  213 */       this.joinpointField.set(newInfo.getAdvisor(), null);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  217 */       e.printStackTrace();
/*  218 */       StringBuffer sb = new StringBuffer();
/*  219 */       debugClass(sb, newInfo.getAdvisor().getClass());
/*  220 */       System.out.println("==================== Error");
/*  221 */       System.out.println("Field: " + this.joinpointField);
/*  222 */       System.out.println("Field: " + this.joinpointField.getDeclaringClass() + " " + this.joinpointField.getDeclaringClass().getClassLoader());
/*  223 */       System.out.println("Value: " + newInfo.getAdvisor().getClass() + " " + newInfo.getAdvisor().getClass().getClassLoader());
/*  224 */       System.out.println(sb.toString());
/*      */ 
/*  226 */       throw new RuntimeException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void generateJoinPointClass()
/*      */   {
/*  236 */     generateJoinPointClass(null, null);
/*      */   }
/*      */ 
/*      */   public synchronized Object generateJoinPointClass(ClassLoader classloader, JoinPointInfo info)
/*      */   {
/*  244 */     if (info == null)
/*      */     {
/*  246 */       throw new RuntimeException("GeneratedAdvisor weaving in AOP 2.0.0.aplha5 and later is not compatible with that of previous versions");
/*      */     }
/*      */ 
/*  249 */     if (System.getSecurityManager() == null)
/*      */     {
/*  251 */       return GenerateJoinPointClassAction.NON_PRIVILEGED.generateJoinPointClass(classloader, this, info);
/*      */     }
/*      */ 
/*  255 */     return GenerateJoinPointClassAction.PRIVILEGED.generateJoinPointClass(classloader, this, info);
/*      */   }
/*      */ 
/*      */   private Object doGenerateJoinPointClass(ClassLoader classloader, JoinPointInfo info)
/*      */   {
/*      */     try
/*      */     {
/*  267 */       if (classloader == null)
/*      */       {
/*  269 */         logger.warn("No classloader specified " + info.getAdviceString());
/*  270 */         classloader = SecurityActions.getContextClassLoader();
/*      */       }
/*      */ 
/*  274 */       String infoAdviceString = info.getAdviceString();
/*  275 */       GeneratedClassInfo generatedClass = (GeneratedClassInfo)this.generatedJoinPointClassCache.get(infoAdviceString);
/*  276 */       Class clazz = null;
/*  277 */       if (generatedClass != null)
/*      */       {
/*  279 */         clazz = classloader.loadClass(generatedClass.getGenerated().getName());
/*      */       }
/*      */ 
/*  282 */       if (clazz == null)
/*      */       {
/*  285 */         AspectManager manager = AspectManager.instance();
/*  286 */         ClassPool pool = manager.findClassPool(classloader);
/*  287 */         generatedClass = generateJoinpointClass(pool, info);
/*      */ 
/*  289 */         ProtectionDomain pd = this.advisorClass.getProtectionDomain();
/*  290 */         clazz = toClass(pool, generatedClass.getGenerated(), pd);
/*  291 */         this.generatedJoinPointClassCache.put(infoAdviceString, generatedClass);
/*      */       }
/*  293 */       Object obj = instantiateClass(clazz, generatedClass.getAroundSetups(), info);
/*      */ 
/*  295 */       this.joinpointField.set(info.getAdvisor(), obj);
/*  296 */       if ((info.getAdvisor() instanceof InstanceAdvisor))
/*      */       {
/*  298 */         Field field = clazz.getDeclaredField("isForInstanceAdvisor");
/*  299 */         SecurityActions.setAccessible(field);
/*  300 */         field.set(obj, Boolean.TRUE);
/*      */       }
/*  302 */       this.initialised = true;
/*  303 */       return obj;
/*      */     }
/*      */     catch (NoMatchingAdviceException e)
/*      */     {
/*  307 */       throw e;
/*      */     }
/*      */     catch (InvalidAdviceException e)
/*      */     {
/*  311 */       throw e;
/*      */     }
/*      */     catch (Throwable e)
/*      */     {
/*      */     }
/*      */ 
/*  321 */     throw new RuntimeException("Error generating joinpoint class for joinpoint " + info, e);
/*      */   }
/*      */ 
/*      */   private Class toClass(ClassPool pool, CtClass ctclass, ProtectionDomain pd)
/*      */     throws NotFoundException, CannotCompileException, ClassNotFoundException
/*      */   {
/*  327 */     return TransformerCommon.toClass(ctclass, pd);
/*      */   }
/*      */ 
/*      */   private Object instantiateClass(Class clazz, AdviceSetup[] aroundSetups, JoinPointInfo info) throws Exception {
/*  332 */     Constructor ctor = clazz.getConstructor(new Class[] { info.getClass() });
/*      */     Object obj;
/*      */     try {
/*  336 */       obj = ctor.newInstance(new Object[] { info });
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  340 */       StringBuffer sb = new StringBuffer();
/*      */ 
/*  346 */       throw new RuntimeException(debugClass(sb, clazz).toString(), e);
/*      */     }
/*      */ 
/*  349 */     for (int i = 0; i < aroundSetups.length; i++)
/*      */     {
/*  351 */       if (!aroundSetups[i].isNewCFlow())
/*      */         continue;
/*  353 */       Field field = clazz.getDeclaredField("cflow" + aroundSetups[i].useCFlowFrom());
/*  354 */       field.setAccessible(true);
/*  355 */       field.set(obj, aroundSetups[i].getCFlow());
/*      */     }
/*      */ 
/*  358 */     return obj;
/*      */   }
/*      */ 
/*      */   private StringBuffer debugClass(StringBuffer sb, Class clazz)
/*      */   {
/*  363 */     sb.append("\n\t\t" + Modifier.toString(clazz.getModifiers()) + " " + clazz.getName() + " " + clazz.getClassLoader());
/*  364 */     Field[] fields = clazz.getDeclaredFields();
/*  365 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  367 */       sb.append("\n\t\t\t" + Modifier.toString(fields[i].getModifiers()) + " " + fields[i].getType().getName() + " " + fields[i].getName() + " " + fields[i].getType().getClassLoader());
/*      */     }
/*      */ 
/*  370 */     Class superClass = clazz.getSuperclass();
/*  371 */     if ((superClass != null) && (superClass != Object.class))
/*      */     {
/*  373 */       sb.append("\n\t\t\textends\n");
/*  374 */       debugClass(sb, superClass);
/*      */     }
/*  376 */     return sb;
/*      */   }
/*      */ 
/*      */   private static synchronized int getIncrement()
/*      */   {
/*  382 */     return ++increment;
/*      */   }
/*      */ 
/*      */   protected String getJoinPointArg(int index)
/*      */   {
/*  393 */     return "this.arg" + index;
/*      */   }
/*      */ 
/*      */   protected abstract void initialiseJoinPointNames(JoinPointInfo paramJoinPointInfo);
/*      */ 
/*      */   private GeneratedClassInfo generateJoinpointClass(ClassPool pool, JoinPointInfo newInfo) throws NotFoundException, CannotCompileException, ClassNotFoundException
/*      */   {
/*  401 */     CtClass superClass = pool.get(this.joinpointFqn);
/*  402 */     String className = getJoinpointClassName();
/*      */     try
/*      */     {
/*  405 */       CtClass clazz = TransformerCommon.makeClass(pool, className);
/*  406 */       clazz.setSuperclass(superClass);
/*  407 */       addUntransformableInterface(pool, clazz);
/*      */ 
/*  409 */       AdviceSetups setups = initialiseAdviceInfosAndAddFields(pool, clazz, newInfo);
/*  410 */       createInitialisePerInstanceAspectsMethod(clazz, setups, newInfo.getClazz());
/*      */ 
/*  412 */       createConstructors(pool, superClass, clazz, setups);
/*  413 */       createJoinPointInvokeMethod(superClass, clazz, isVoid(), setups, newInfo);
/*      */ 
/*  420 */       createInvokeNextMethod(clazz, isVoid(), setups, newInfo);
/*      */ 
/*  422 */       overrideDispatchMethods(superClass, clazz, newInfo);
/*  423 */       return new GeneratedClassInfo(clazz, setups);
/*      */     }
/*      */     catch (NotFoundException e)
/*      */     {
/*  427 */       System.err.println("Exception generating " + className + ": " + e.getMessage());
/*  428 */       throw e;
/*      */     }
/*      */     catch (CannotCompileException e)
/*      */     {
/*  432 */       System.err.println("Exception generating " + className + ": " + e.getMessage());
/*  433 */       throw e;
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  437 */       System.err.println("Exception generating " + className + ": " + e.getMessage());
/*  438 */     }throw e;
/*      */   }
/*      */ 
/*      */   private String getJoinpointClassName()
/*      */   {
/*  444 */     return this.baseJoinPointClassName + getIncrement();
/*      */   }
/*      */ 
/*      */   private void createInitialisePerInstanceAspectsMethod(CtClass clazz, AdviceSetups setups, Class advisedClass) throws CannotCompileException, NotFoundException
/*      */   {
/*  449 */     if (setups.hasLightweightAdvicesRequiringInstanceAdvisor())
/*      */     {
/*  451 */       StringBuffer code = new StringBuffer("{");
/*  452 */       for (AdviceSetup setup : setups.getLightweightAdvicesRequiringInstanceAdvisor())
/*      */       {
/*  454 */         AdviceType type = setup.getType();
/*  455 */         if ((type != AdviceType.AROUND) && (setup.requiresInstanceAdvisor()))
/*      */         {
/*  457 */           code.append(getPerInstanceAspectCode("$1", setup, false));
/*      */         }
/*      */       }
/*      */ 
/*  461 */       code.append("}");
/*      */ 
/*  463 */       String name = advisedClass.getName();
/*  464 */       CtClass ctTarget = clazz.getClassPool().get(name);
/*      */ 
/*  466 */       CtMethod method = CtNewMethod.make(2, CtClass.voidType, "initialisePerInstanceAspects", new CtClass[] { ctTarget }, EMPTY_CTCLASS_ARRAY, code.toString(), clazz);
/*      */ 
/*  474 */       clazz.addMethod(method);
/*      */     }
/*      */   }
/*      */   protected abstract boolean isVoid();
/*      */ 
/*      */   protected abstract Class getReturnClassType();
/*      */ 
/*      */   protected abstract AdviceMethodProperties getAdviceMethodProperties(JoinPointBean paramJoinPointBean, AdviceSetup paramAdviceSetup);
/*      */ 
/*  485 */   protected boolean isCaller() { return false;
/*      */   }
/*      */ 
/*      */   protected boolean hasCallingObject()
/*      */   {
/*  490 */     return false;
/*      */   }
/*      */ 
/*      */   protected abstract boolean hasTargetObject();
/*      */ 
/*      */   private boolean isStaticCall() {
/*  497 */     if (isCaller())
/*      */     {
/*  499 */       return !hasCallingObject();
/*      */     }
/*      */ 
/*  503 */     return !hasTargetObject();
/*      */   }
/*      */ 
/*      */   private void findAdvisedField(JoinPointInfo info)
/*      */   {
/*  509 */     if (info.getClazz() == null)
/*      */     {
/*  511 */       return;
/*      */     }
/*  513 */     Class advisorClass = null;
/*  514 */     if (info.getAdvisor().getClazz().equals(info.getClazz()))
/*      */     {
/*  517 */       advisorClass = info.getAdvisor().getClass();
/*      */     }
/*      */     else
/*      */     {
/*  521 */       AspectManager manager = info.getAdvisor().getManager();
/*      */       try
/*      */       {
/*  524 */         advisorClass = manager.getAdvisor(info.getClazz()).getClass();
/*      */       }
/*      */       catch (ClassCastException e)
/*      */       {
/*  528 */         Advisor advisor = manager.findAdvisor(info.getClazz());
/*  529 */         if ((advisor != null) && (!(advisor instanceof ClassAdvisor)))
/*      */         {
/*  532 */           return;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  539 */       this.joinpointField = advisorClass.getDeclaredField(this.joinpointFieldName);
/*  540 */       SecurityActions.setAccessible(this.joinpointField);
/*  541 */       this.joinpointFqn = (advisorClass.getDeclaringClass().getName() + "$" + this.joinpointClassName);
/*      */     }
/*      */     catch (NoSuchFieldException e)
/*      */     {
/*  545 */       throw new RuntimeException(e);
/*      */     }
/*      */     catch (NoClassDefFoundError e)
/*      */     {
/*  549 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   private AdviceSetups initialiseAdviceInfosAndAddFields(ClassPool pool, CtClass clazz, JoinPointInfo info) throws ClassNotFoundException, NotFoundException, CannotCompileException
/*      */   {
/*  555 */     HashMap cflows = new HashMap();
/*  556 */     AdviceSetup[] setups = new AdviceSetup[info.getInterceptors().length];
/*      */ 
/*  558 */     ClassLoader classLoader = pool.getClassLoader();
/*  559 */     if (classLoader == null)
/*      */     {
/*  561 */       logger.warn("No classloader specified " + clazz.getName(), new Throwable("STACKTRACE"));
/*  562 */       classLoader = SecurityActions.getContextClassLoader();
/*      */     }
/*      */ 
/*  565 */     for (int i = 0; i < info.getInterceptors().length; i++)
/*      */     {
/*  567 */       setups[i] = new AdviceSetup(i, (GeneratedAdvisorInterceptor)info.getInterceptors()[i], info, classLoader);
/*  568 */       addAspectFieldAndGetter(pool, clazz, setups[i]);
/*  569 */       addCFlowFieldsAndGetters(pool, setups[i], clazz, cflows);
/*      */     }
/*  571 */     addLightweightInstanceAspectsTrackerFields(clazz);
/*  572 */     return new AdviceSetups(info, setups);
/*      */   }
/*      */ 
/*      */   private void addAspectFieldAndGetter(ClassPool pool, CtClass clazz, AdviceSetup setup) throws NotFoundException, CannotCompileException
/*      */   {
/*  577 */     CtClass aspectClass = setup.getAspectCtClass();
/*      */ 
/*  579 */     if (!setup.shouldInvokeAspect())
/*      */     {
/*  581 */       return;
/*      */     }
/*      */ 
/*  584 */     CtField field = new CtField(aspectClass, setup.getAspectFieldName(), clazz);
/*  585 */     field.setModifiers(130);
/*  586 */     clazz.addField(field);
/*      */ 
/*  588 */     String body = getAspectFieldGetterBody(setup);
/*  589 */     CtMethod method = CtNewMethod.make(aspectClass, setup.getAspectInitialiserName(), new CtClass[0], new CtClass[0], body, clazz);
/*      */ 
/*  596 */     method.setModifiers(2);
/*  597 */     clazz.addMethod(method);
/*      */   }
/*      */ 
/*      */   private String getAspectFieldGetterBody(AdviceSetup setup)
/*      */   {
/*  602 */     if (setup.requiresInstanceAdvisor())
/*      */     {
/*  604 */       String instanceAdvisor = isCaller() ? "callingObject" : "targetObject";
/*      */ 
/*  606 */       return getPerInstanceAspectCode(instanceAdvisor, setup, true);
/*      */     }
/*      */ 
/*  610 */     return "{   if (" + setup.getAspectFieldName() + " != null)" + "   {" + "      return " + setup.getAspectFieldName() + ";" + "   }" + "   org.jboss.aop.advice.GeneratedAdvisorInterceptor fw = (org.jboss.aop.advice.GeneratedAdvisorInterceptor)info.getInterceptors()[" + setup.getIndex() + "];" + "   Object o = fw.getAspect(info.getAdvisor(), info.getJoinpoint());" + "   return (" + setup.getAspectClass().getName() + ")o;" + "}";
/*      */   }
/*      */ 
/*      */   private String getPerInstanceAspectCode(String objectWithInstanceAdvisor, AdviceSetup setup, boolean shouldReturn)
/*      */   {
/*  625 */     String instanceAdvisor = "org.jboss.aop.InstanceAdvisor ia = ((org.jboss.aop.Advised)" + objectWithInstanceAdvisor + ")._getInstanceAdvisor();";
/*  626 */     String assignOrReturn = setup.getAspectFieldName() + " = ";
/*  627 */     return "{   " + instanceAdvisor + "   org.jboss.aop.advice.GeneratedAdvisorInterceptor fw = (org.jboss.aop.advice.GeneratedAdvisorInterceptor)info.getInterceptors()[" + setup.getIndex() + "];" + "   Object o = fw.getPerInstanceAspect(info.getAdvisor(), info.getJoinpoint(), ia);" + "   " + assignOrReturn + "(" + setup.getAspectClass().getName() + ")o;" + "}";
/*      */   }
/*      */ 
/*      */   private void addCFlowFieldsAndGetters(ClassPool pool, AdviceSetup setup, CtClass clazz, HashMap<String, Integer> cflows)
/*      */     throws NotFoundException, CannotCompileException
/*      */   {
/*  640 */     if (setup.getCFlowString() != null)
/*      */     {
/*  642 */       Integer useCFlowIndex = (Integer)cflows.get(setup.getCFlowString());
/*  643 */       if (useCFlowIndex == null)
/*      */       {
/*  645 */         useCFlowIndex = new Integer(setup.getIndex());
/*  646 */         cflows.put(setup.getCFlowString(), useCFlowIndex);
/*      */ 
/*  648 */         CtField cflowX = new CtField(pool.get(ASTCFlowExpression.class.getName()), "cflow" + useCFlowIndex, clazz);
/*      */ 
/*  652 */         clazz.addField(cflowX);
/*      */ 
/*  654 */         CtField matchesCFlowX = new CtField(CtClass.booleanType, "matchesCflow" + useCFlowIndex, clazz);
/*      */ 
/*  658 */         clazz.addField(matchesCFlowX);
/*      */ 
/*  660 */         String initCFlowXBody = "{   org.jboss.aop.pointcut.CFlowMatcher matcher = new org.jboss.aop.pointcut.CFlowMatcher();   return matcher.matches(" + cflowX.getName() + ", this);" + "}";
/*      */ 
/*  665 */         CtMethod initCFlowX = CtNewMethod.make(CtClass.booleanType, "getCFlow" + useCFlowIndex, new CtClass[0], new CtClass[0], initCFlowXBody, clazz);
/*      */ 
/*  672 */         clazz.addMethod(initCFlowX);
/*      */       }
/*  674 */       setup.setUseCFlowFrom(useCFlowIndex.intValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addLightweightInstanceAspectsTrackerFields(CtClass clazz) throws CannotCompileException
/*      */   {
/*  680 */     CtField initialised = new CtField(CtClass.booleanType, "initialisedLightweightInstanceAspects", clazz);
/*  681 */     clazz.addField(initialised);
/*      */ 
/*  683 */     CtField forInstance = new CtField(CtClass.booleanType, "isForInstanceAdvisor", clazz);
/*  684 */     clazz.addField(forInstance);
/*      */   }
/*      */ 
/*      */   private void createJoinPointInvokeMethod(CtClass superClass, CtClass clazz, boolean isVoid, AdviceSetups setups, JoinPointInfo info) throws CannotCompileException, NotFoundException
/*      */   {
/*  689 */     CtMethod superInvoke = superClass.getDeclaredMethod("invokeJoinpoint");
/*  690 */     String code = null;
/*      */     try
/*      */     {
/*  693 */       code = createJoinpointInvokeBody(superClass, clazz, setups, superInvoke.getExceptionTypes(), superInvoke.getParameterTypes(), info);
/*      */ 
/*  698 */       CtMethod invoke = CtNewMethod.make(superInvoke.getReturnType(), superInvoke.getName(), superInvoke.getParameterTypes(), superInvoke.getExceptionTypes(), code, clazz);
/*      */ 
/*  705 */       clazz.addMethod(invoke);
/*      */     }
/*      */     catch (CannotCompileException e)
/*      */     {
/*  709 */       throw new RuntimeException("Error compiling code for Joinpoint (" + info.getJoinpoint() + "): " + code + "\n - " + e + "\n - " + getMethodString(clazz, superInvoke.getName(), superInvoke.getParameterTypes()) + "\n - " + clazz.getName(), e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private String createJoinpointInvokeBody(CtClass joinpointSuperClass, CtClass joinpointClass, AdviceSetups setups, CtClass[] declaredExceptions, CtClass[] parameterTypes, JoinPointInfo info)
/*      */     throws NotFoundException
/*      */   {
/*  716 */     AdviceCallStrategy defaultCall = DefaultAdviceCallStrategy.getInstance();
/*  717 */     AdviceCallStrategy afterCall = AfterAdviceCallStrategy.getInstance();
/*      */ 
/*  719 */     StringBuffer code = new StringBuffer();
/*  720 */     code.append("{");
/*      */ 
/*  722 */     if (!isVoid())
/*      */     {
/*  724 */       String ret = null;
/*  725 */       Class retType = getReturnClassType();
/*  726 */       if (retType.isPrimitive())
/*      */       {
/*  728 */         if (retType.equals(Boolean.TYPE)) ret = "false";
/*  729 */         else if (retType.equals(Character.TYPE)) ret = "'\\0'";
/*  730 */         else if (retType.equals(Byte.TYPE)) ret = "(byte)0";
/*  731 */         else if (retType.equals(Short.TYPE)) ret = "(short)0";
/*  732 */         else if (retType.equals(Integer.TYPE)) ret = "(int)0";
/*  733 */         else if (retType.equals(Long.TYPE)) ret = "0L";
/*  734 */         else if (retType.equals(Float.TYPE)) ret = "0.0f";
/*  735 */         else if (retType.equals(Double.TYPE)) ret = "0.0d";
/*      */       }
/*  737 */       code.append("   " + ClassExpression.simpleType(getReturnClassType()) + "  " + "ret" + " = " + ret + ";");
/*      */     }
/*      */ 
/*  741 */     code.append("Throwable ").append("t").append(" = null;");
/*      */ 
/*  744 */     addInitialiseLightweightPerInstanceAdvicesCode(joinpointSuperClass, info, code, setups);
/*      */ 
/*  746 */     code.append("   try");
/*  747 */     code.append("   {");
/*  748 */     boolean argsFoundBefore = defaultCall.addInvokeCode(this, setups.getByType(AdviceType.BEFORE), code, info);
/*      */ 
/*  752 */     boolean joinPointCreated = addAroundInvokeCode(code, setups, joinpointClass, argsFoundBefore, parameterTypes);
/*      */ 
/*  756 */     StringBuffer afterCode = new StringBuffer();
/*  757 */     boolean argsFoundAfter = afterCall.addInvokeCode(this, setups.getByType(AdviceType.AFTER), afterCode, info);
/*      */ 
/*  759 */     afterCode.append("   }");
/*  760 */     afterCode.append("   catch(java.lang.Throwable throwable)");
/*  761 */     afterCode.append("   {");
/*      */ 
/*  763 */     afterCode.append("t").append(" = ").append("throwable;");
/*  764 */     argsFoundAfter = (defaultCall.addInvokeCode(this, setups.getByType(AdviceType.THROWING), afterCode, info)) || (argsFoundAfter);
/*      */ 
/*  766 */     afterCode.append("throw t;");
/*      */ 
/*  768 */     afterCode.append("   }");
/*      */ 
/*  770 */     AdviceSetup[] finallySetups = setups.getByType(AdviceType.FINALLY);
/*  771 */     if ((finallySetups != null) && (finallySetups.length > 0))
/*      */     {
/*  773 */       afterCode.append("   finally {");
/*  774 */       argsFoundAfter = (afterCall.addInvokeCode(this, finallySetups, afterCode, info)) || (argsFoundAfter);
/*      */ 
/*  776 */       afterCode.append("}");
/*      */     }
/*      */ 
/*  785 */     if ((joinPointCreated) && ((argsFoundAfter) || (((Set)this.inconsistentTypeArgs.get()).size() < this.joinPointArguments.size())))
/*      */     {
/*  788 */       code.append("arguments");
/*  789 */       code.append(" = jp.").append("getArguments()").append(";");
/*  790 */       argsFoundAfter = true;
/*      */     }
/*      */ 
/*  794 */     code.append(afterCode.toString());
/*      */ 
/*  796 */     if (!isVoid())
/*      */     {
/*  798 */       code.append("   return ret;");
/*      */     }
/*      */ 
/*  801 */     code.append("}");
/*      */ 
/*  804 */     if ((argsFoundBefore) || (argsFoundAfter))
/*      */     {
/*  806 */       code.insert(1, this.parameters.declareArgsArray(parameterTypes.length, this.nullArgsArray));
/*      */     }
/*      */ 
/*  809 */     return code.toString();
/*      */   }
/*      */ 
/*      */   private void addInitialiseLightweightPerInstanceAdvicesCode(CtClass joinpointSuperClass, JoinPointInfo info, StringBuffer code, AdviceSetups setups)
/*      */   {
/*  814 */     if (setups.hasLightweightAdvicesRequiringInstanceAdvisor())
/*      */     {
/*  816 */       if ((!hasCallingObject()) && (!hasTargetObject()))
/*      */       {
/*  819 */         return;
/*      */       }
/*      */ 
/*  822 */       String instanceAdvisor = "$" + this.parameters.getContextIndex();
/*      */ 
/*  824 */       code.append("if (!initialisedLightweightInstanceAspects){");
/*  825 */       code.append("   if(isForInstanceAdvisor){");
/*  826 */       code.append("      initialisePerInstanceAspects(" + instanceAdvisor + ");");
/*  827 */       code.append("initialisedLightweightInstanceAspects = true;");
/*  828 */       code.append("   }else{");
/*  829 */       code.append("      org.jboss.aop.GeneratedClassAdvisor instanceAdvisor = (org.jboss.aop.GeneratedClassAdvisor)((org.jboss.aop.Advised)" + instanceAdvisor + ")._getInstanceAdvisor();");
/*  830 */       code.append("      Object objJp = instanceAdvisor.createAndRebindJoinPointForInstance((org.jboss.aop.JoinPointInfo)super.info);");
/*  831 */       code.append("      " + joinpointSuperClass.getName() + " jp = (" + joinpointSuperClass.getName() + ")objJp;");
/*  832 */       if (isVoid())
/*      */       {
/*  834 */         code.append("      jp.invokeJoinpoint($$);");
/*  835 */         code.append("return;");
/*      */       }
/*      */       else
/*      */       {
/*  839 */         code.append("      return jp.invokeJoinpoint($$);");
/*      */       }
/*  841 */       code.append("   }");
/*  842 */       code.append("}");
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean addAroundInvokeCode(StringBuffer code, AdviceSetups setups, CtClass joinpointClass, boolean argsFoundBefore, CtClass[] parameterTypes)
/*      */     throws NotFoundException
/*      */   {
/*  850 */     if (setups.getByType(AdviceType.AROUND) != null)
/*      */     {
/*  852 */       StringBuffer aspects = new StringBuffer();
/*  853 */       StringBuffer cflows = new StringBuffer();
/*      */ 
/*  855 */       AdviceSetup[] asetups = setups.getAllSetups();
/*  856 */       for (int i = 0; i < asetups.length; i++)
/*      */       {
/*  858 */         if (!asetups[i].requiresInstanceAdvisor())
/*      */         {
/*  863 */           aspects.append(", ");
/*  864 */           aspects.append(asetups[i].getAspectFieldName());
/*      */         }
/*      */ 
/*  867 */         if (!asetups[i].isNewCFlow())
/*      */           continue;
/*  869 */         cflows.append(", cflow" + asetups[i].getIndex());
/*      */       }
/*      */ 
/*  872 */       code.append(this.joinpointFqn).append(" jp = new " + joinpointClass.getName() + "(this");
/*  873 */       if (argsFoundBefore)
/*      */       {
/*  875 */         this.parameters.appendParameterListWithoutArgs(code);
/*      */       }
/*      */       else
/*      */       {
/*  880 */         code.append(", $$");
/*      */       }
/*      */ 
/*  883 */       code.append(aspects.toString() + cflows.toString() + ");");
/*      */ 
/*  885 */       if (argsFoundBefore)
/*      */       {
/*  887 */         code.append("   jp.setArguments(");
/*  888 */         code.append("arguments");
/*  889 */         code.append(");");
/*      */       }
/*      */ 
/*  892 */       if (setups.getHasArgsAroundAdvices())
/*      */       {
/*  894 */         code.append("try{");
/*  895 */         code.append("   org.jboss.aop.joinpoint.CurrentInvocation.push(jp); ");
/*      */       }
/*      */ 
/*  899 */       if (!isVoid())
/*      */       {
/*  901 */         code.append("          ret = ($r)");
/*      */       }
/*  903 */       code.append("jp.invokeNext();");
/*      */ 
/*  905 */       if (setups.getHasArgsAroundAdvices())
/*      */       {
/*  907 */         code.append("}finally{");
/*  908 */         code.append("   org.jboss.aop.joinpoint.CurrentInvocation.pop(); ");
/*  909 */         code.append("}");
/*      */       }
/*      */ 
/*  914 */       ((Set)this.inconsistentTypeArgs.get()).addAll(this.joinPointArguments);
/*  915 */       return true;
/*      */     }
/*      */ 
/*  919 */     addDispatchCode(code, parameterTypes, argsFoundBefore);
/*  920 */     return false;
/*      */   }
/*      */ 
/*      */   private final void addDispatchCode(StringBuffer code, CtClass[] parameterTypes, boolean argsFound)
/*      */   {
/*  927 */     if (!isVoid())
/*      */     {
/*  929 */       code.append("          ret = ($r)");
/*      */     }
/*  931 */     code.append("super.dispatch(");
/*  932 */     if (argsFound)
/*      */     {
/*  934 */       this.parameters.appendParameterList(code, parameterTypes);
/*      */     }
/*      */     else
/*      */     {
/*  938 */       code.append("$$");
/*      */     }
/*  940 */     code.append(");");
/*      */   }
/*      */ 
/*      */   private void addHandleExceptionCode(StringBuffer code, CtClass[] declaredExceptions)
/*      */   {
/*  945 */     for (int i = 0; i < declaredExceptions.length; i++)
/*      */     {
/*  947 */       code.append("if (t instanceof " + declaredExceptions[i].getName() + ")");
/*  948 */       code.append("   throw (" + declaredExceptions[i].getName() + ")t;");
/*      */     }
/*      */ 
/*  951 */     code.append("if (t instanceof java.lang.RuntimeException)");
/*  952 */     code.append("throw t;");
/*      */ 
/*  954 */     code.append("throw new java.lang.RuntimeException(t);");
/*      */   }
/*      */ 
/*      */   private void createInvokeNextMethod(CtClass jp, boolean isVoid, AdviceSetups setups, JoinPointInfo info) throws NotFoundException, CannotCompileException
/*      */   {
/*  959 */     AdviceSetup[] aroundSetups = setups.getByType(AdviceType.AROUND);
/*  960 */     if (aroundSetups == null) return;
/*      */ 
/*  962 */     CtMethod method = jp.getSuperclass().getSuperclass().getDeclaredMethod("invokeNext");
/*  963 */     CtMethod invokeNext = CtNewMethod.copy(method, jp, null);
/*      */ 
/*  965 */     String code = createInvokeNextMethodBody(jp, isVoid, aroundSetups, info);
/*      */     try
/*      */     {
/*  969 */       invokeNext.setBody(code);
/*      */     }
/*      */     catch (CannotCompileException e)
/*      */     {
/*  973 */       throw new RuntimeException("Error creating invokeNext method: " + code, e);
/*      */     }
/*      */ 
/*  976 */     jp.addMethod(invokeNext);
/*      */   }
/*      */ 
/*      */   private String createInvokeNextMethodBody(CtClass jp, boolean isVoid, AdviceSetup[] aroundSetups, JoinPointInfo info) throws NotFoundException
/*      */   {
/*  981 */     String returnStr = isVoid ? "" : "return ($w)";
/*      */ 
/*  983 */     StringBuffer body = new StringBuffer();
/*  984 */     body.append("{");
/*  985 */     body.append("   try{");
/*  986 */     body.append("      switch(++super.currentInterceptor){");
/*  987 */     AroundAdviceCallStrategy.getInstance().addInvokeCode(this, aroundSetups, body, info);
/*  988 */     body.append("      default:");
/*  989 */     body.append("         " + returnStr + "this.dispatch();");
/*  990 */     body.append("      }");
/*  991 */     body.append("   }finally{");
/*  992 */     body.append("      --super.currentInterceptor;");
/*  993 */     body.append("   }");
/*  994 */     body.append("   return null;");
/*  995 */     body.append("}");
/*      */ 
/*  997 */     return body.toString();
/*      */   }
/*      */ 
/*      */   private void createConstructors(ClassPool pool, CtClass superClass, CtClass clazz, AdviceSetups setups) throws NotFoundException, CannotCompileException
/*      */   {
/* 1002 */     CtConstructor[] superCtors = superClass.getDeclaredConstructors();
/* 1003 */     if ((superCtors.length != 3) && (superCtors.length != 2) && (!getClass().equals(MethodJoinPointGenerator.class)) && (!FieldJoinPointGenerator.class.isAssignableFrom(getClass())))
/*      */     {
/* 1006 */       throw new RuntimeException("JoinPoints should have 2 or 3 constructors, not " + superCtors.length);
/*      */     }
/* 1008 */     if ((superCtors.length != 4) && (superCtors.length != 3) && (getClass().equals(MethodJoinPointGenerator.class)))
/*      */     {
/* 1010 */       throw new RuntimeException("Method JoinPoints should have 3 or 4 constructors, not " + superCtors.length);
/*      */     }
/*      */ 
/* 1013 */     int publicIndex = -1;
/* 1014 */     int protectedIndex1 = -1;
/* 1015 */     int protectedIndex2 = -1;
/* 1016 */     int defaultIndex = -1;
/*      */ 
/* 1018 */     for (int i = 0; i < superCtors.length; i++)
/*      */     {
/* 1020 */       int modifier = superCtors[i].getModifiers();
/* 1021 */       if (Modifier.isPublic(modifier))
/*      */       {
/* 1023 */         if (superCtors[i].getParameterTypes().length == 0) defaultIndex = i; else
/* 1024 */           publicIndex = i;
/*      */       } else {
/* 1026 */         if (!Modifier.isProtected(modifier))
/*      */           continue;
/* 1028 */         if (protectedIndex1 == -1)
/*      */         {
/* 1030 */           protectedIndex1 = i;
/*      */         }
/*      */         else
/*      */         {
/* 1034 */           protectedIndex2 = i;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1039 */     if ((publicIndex < 0) || (protectedIndex1 < 0))
/*      */     {
/* 1041 */       throw new RuntimeException("One of the JoinPoint constructors should be public, and at least one of them should be protected");
/*      */     }
/*      */ 
/* 1044 */     if (defaultIndex >= 0)
/*      */     {
/* 1046 */       createDefaultConstructor(superCtors[defaultIndex], clazz);
/*      */     }
/*      */ 
/* 1049 */     createPublicConstructor(superCtors[publicIndex], clazz, setups);
/* 1050 */     if (protectedIndex2 == -1)
/*      */     {
/* 1052 */       createProtectedConstructors(pool, superCtors[protectedIndex1], null, clazz, setups);
/*      */     }
/*      */     else
/*      */     {
/* 1056 */       createProtectedConstructors(pool, superCtors[protectedIndex1], superCtors[protectedIndex2], clazz, setups);
/*      */     }
/* 1058 */     createCopyConstructorAndMethod(pool, clazz);
/*      */   }
/*      */ 
/*      */   private void createDefaultConstructor(CtConstructor superCtor, CtClass clazz)
/*      */     throws CannotCompileException
/*      */   {
/* 1066 */     CtConstructor ctor = CtNewConstructor.defaultConstructor(clazz);
/* 1067 */     clazz.addConstructor(ctor);
/*      */   }
/*      */ 
/*      */   private void createPublicConstructor(CtConstructor superCtor, CtClass clazz, AdviceSetups setups)
/*      */     throws CannotCompileException, NotFoundException
/*      */   {
/* 1076 */     StringBuffer body = new StringBuffer();
/*      */     try
/*      */     {
/* 1079 */       body.append("{super($$);");
/*      */ 
/* 1082 */       AdviceSetup[] allSetups = setups.getAllSetups();
/* 1083 */       for (int i = 0; i < allSetups.length; i++)
/*      */       {
/* 1085 */         if (allSetups[i].requiresInstanceAdvisor())
/*      */           continue;
/* 1087 */         body.append(allSetups[i].getAspectFieldName() + " = " + allSetups[i].getAspectInitialiserName() + "();");
/*      */       }
/*      */ 
/* 1091 */       body.append("}");
/*      */ 
/* 1093 */       CtConstructor ctor = CtNewConstructor.make(superCtor.getParameterTypes(), superCtor.getExceptionTypes(), body.toString(), clazz);
/* 1094 */       ctor.setModifiers(superCtor.getModifiers());
/* 1095 */       clazz.addConstructor(ctor);
/*      */     }
/*      */     catch (CannotCompileException e)
/*      */     {
/* 1100 */       throw new CannotCompileException("Error compiling. Code \n" + body.toString(), e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void createProtectedConstructors(ClassPool pool, CtConstructor superCtor1, CtConstructor superCtor2, CtClass clazz, AdviceSetups setups)
/*      */     throws CannotCompileException, NotFoundException
/*      */   {
/* 1113 */     ArrayList aspects = new ArrayList();
/* 1114 */     ArrayList cflows = new ArrayList();
/* 1115 */     StringBuffer adviceInit = new StringBuffer();
/*      */ 
/* 1117 */     AdviceSetup[] allSetups = setups.getAllSetups();
/* 1118 */     for (int i = 0; i < allSetups.length; i++)
/*      */     {
/* 1120 */       if (!allSetups[i].shouldInvokeAspect())
/*      */       {
/*      */         continue;
/*      */       }
/*      */ 
/* 1125 */       if (allSetups[i].requiresInstanceAdvisor())
/*      */       {
/* 1127 */         adviceInit.append(allSetups[i].getAspectFieldName());
/* 1128 */         adviceInit.append(" = ");
/* 1129 */         adviceInit.append(allSetups[i].getAspectInitialiserName());
/* 1130 */         adviceInit.append("();");
/*      */       }
/*      */       else
/*      */       {
/* 1134 */         aspects.add(allSetups[i]);
/*      */       }
/*      */ 
/* 1137 */       if (!allSetups[i].isNewCFlow())
/*      */         continue;
/* 1139 */       cflows.add(Integer.valueOf(allSetups[i].useCFlowFrom()));
/*      */     }
/*      */ 
/* 1142 */     createProtectedConstructor(pool, clazz, superCtor1, allSetups, aspects, cflows, adviceInit.toString());
/*      */ 
/* 1144 */     if (superCtor2 != null)
/*      */     {
/* 1146 */       createProtectedConstructor(pool, clazz, superCtor2, allSetups, aspects, cflows, adviceInit.toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void createProtectedConstructor(ClassPool pool, CtClass clazz, CtConstructor superCtor, AdviceSetup[] allSetups, ArrayList<AdviceSetup> aspects, ArrayList<Integer> cflows, String aspectInitialization)
/*      */     throws NotFoundException, CannotCompileException
/*      */   {
/* 1158 */     CtClass[] superParams = superCtor.getParameterTypes();
/* 1159 */     CtClass[] params = new CtClass[superParams.length + aspects.size() + cflows.size()];
/* 1160 */     System.arraycopy(superParams, 0, params, 0, superParams.length);
/*      */ 
/* 1162 */     StringBuffer init = new StringBuffer();
/* 1163 */     for (int i = 0; i < aspects.size(); i++)
/*      */     {
/* 1165 */       AdviceSetup setup = (AdviceSetup)aspects.get(i);
/* 1166 */       params[(i + superParams.length)] = setup.getAspectCtClass();
/* 1167 */       init.append("this." + setup.getAspectFieldName() + " = $" + (i + superParams.length + 1) + ";");
/*      */     }
/* 1169 */     int aspectsLength = superParams.length + aspects.size();
/* 1170 */     if (cflows.size() > 0)
/*      */     {
/* 1172 */       CtClass astCFlowExpr = pool.get(ASTCFlowExpression.class.getName());
/* 1173 */       for (int i = 0; i < cflows.size(); i++)
/*      */       {
/* 1175 */         params[(i + aspectsLength)] = astCFlowExpr;
/* 1176 */         init.append("cflow" + cflows.get(i) + "= $" + (i + aspectsLength + 1) + ";");
/* 1177 */         init.append("matchesCflow" + cflows.get(i) + " = getCFlow" + allSetups[((Integer)cflows.get(i)).intValue()].useCFlowFrom() + "();");
/*      */       }
/*      */     }
/*      */ 
/* 1181 */     StringBuffer body = new StringBuffer("{super(");
/* 1182 */     for (int i = 0; i < superParams.length; i++)
/*      */     {
/* 1184 */       if (i > 0)
/*      */       {
/* 1186 */         body.append(", ");
/*      */       }
/* 1188 */       body.append("$" + (i + 1));
/*      */     }
/*      */ 
/* 1191 */     body.append(");");
/* 1192 */     body.append(aspectInitialization);
/* 1193 */     body.append(init.toString());
/*      */ 
/* 1195 */     body.append("}");
/* 1196 */     CtConstructor ctor = CtNewConstructor.make(params, superCtor.getExceptionTypes(), body.toString(), clazz);
/*      */ 
/* 1201 */     ctor.setModifiers(superCtor.getModifiers());
/* 1202 */     clazz.addConstructor(ctor);
/*      */   }
/*      */ 
/*      */   private void createCopyConstructorAndMethod(ClassPool pool, CtClass clazz)
/*      */     throws NotFoundException, CannotCompileException
/*      */   {
/* 1209 */     StringBuffer body = new StringBuffer();
/* 1210 */     body.append("{");
/* 1211 */     body.append("   super($1.info);");
/*      */ 
/* 1213 */     CtClass superClass = clazz;
/* 1214 */     while ((superClass != null) && (!superClass.getName().equals("java.lang.Object")))
/*      */     {
/* 1216 */       CtField[] fields = superClass.getDeclaredFields();
/* 1217 */       for (int i = 0; i < fields.length; i++)
/*      */       {
/* 1219 */         if ((Modifier.isPrivate(fields[i].getModifiers())) && (fields[i].getDeclaringClass() != clazz))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/* 1224 */         if ((Modifier.isFinal(fields[i].getModifiers())) || (Modifier.isStatic(fields[i].getModifiers())))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/* 1229 */         body.append("   this." + fields[i].getName() + " = $1." + fields[i].getName() + ";");
/*      */       }
/* 1231 */       superClass = superClass.getSuperclass();
/*      */     }
/* 1233 */     body.append("}");
/*      */ 
/* 1235 */     CtConstructor copyCtor = CtNewConstructor.make(new CtClass[] { clazz }, new CtClass[0], body.toString(), clazz);
/* 1236 */     copyCtor.setModifiers(2);
/* 1237 */     clazz.addConstructor(copyCtor);
/*      */ 
/* 1239 */     CtMethod superCopy = pool.get(Invocation.class.getName()).getDeclaredMethod("copy");
/* 1240 */     String copyBody = "{   return new " + clazz.getName() + "(this);" + "}";
/*      */ 
/* 1244 */     CtMethod copy = CtNewMethod.make(superCopy.getReturnType(), superCopy.getName(), new CtClass[0], new CtClass[0], copyBody, clazz);
/*      */ 
/* 1251 */     clazz.setModifiers(1);
/* 1252 */     clazz.addMethod(copy);
/*      */   }
/*      */ 
/*      */   protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo)
/*      */     throws CannotCompileException, NotFoundException
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, CallerConstructorInfo cinfo)
/*      */     throws NotFoundException, CannotCompileException
/*      */   {
/* 1267 */     if (cinfo.getWrappingMethod() == null)
/*      */     {
/* 1269 */       return;
/*      */     }
/*      */ 
/* 1272 */     CtMethod[] superDispatches = JavassistUtils.getDeclaredMethodsWithName(superClass, "dispatch");
/*      */ 
/* 1274 */     if (superDispatches.length > 2)
/*      */     {
/* 1276 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Too many dispatch() methods found in " + superClass.getName());
/*      */     }
/*      */ 
/* 1279 */     for (int i = 0; i < superDispatches.length; i++)
/*      */     {
/* 1281 */       CtMethod wrapperMethod = ReflectToJavassist.methodToJavassist(cinfo.getWrappingMethod());
/* 1282 */       CtClass[] params = wrapperMethod.getParameterTypes();
/*      */ 
/* 1284 */       StringBuffer parameters = new StringBuffer("(");
/* 1285 */       if (superDispatches[i].getParameterTypes().length == 0)
/*      */       {
/* 1288 */         for (int j = 0; j < params.length; j++)
/*      */         {
/* 1290 */           if (j > 0) parameters.append(", ");
/* 1291 */           parameters.append("arg" + j);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1297 */         int offset = hasCallingObject() ? 1 : 0;
/* 1298 */         for (int j = 0; j < params.length; j++)
/*      */         {
/* 1300 */           if (j > 0) parameters.append(", ");
/* 1301 */           parameters.append("$" + (j + offset + 1));
/*      */         }
/*      */       }
/* 1304 */       parameters.append(")");
/*      */ 
/* 1306 */       String body = "{ return " + cinfo.getConstructor().getDeclaringClass().getName() + "." + cinfo.getWrappingMethod().getName() + parameters + ";}";
/*      */       try
/*      */       {
/* 1311 */         CtMethod dispatch = CtNewMethod.make(superDispatches[i].getReturnType(), superDispatches[i].getName(), superDispatches[i].getParameterTypes(), superDispatches[i].getExceptionTypes(), body, clazz);
/*      */ 
/* 1318 */         dispatch.setModifiers(superDispatches[i].getModifiers());
/* 1319 */         clazz.addMethod(dispatch);
/*      */       }
/*      */       catch (CannotCompileException e)
/*      */       {
/* 1323 */         throw new RuntimeException("Could not compile code " + body + " for method " + getMethodString(clazz, superDispatches[i].getName(), superDispatches[i].getParameterTypes()), e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static void addUntransformableInterface(Instrumentor instrumentor, CtClass clazz)
/*      */     throws NotFoundException
/*      */   {
/* 1331 */     addUntransformableInterface(instrumentor.getClassPool(), clazz);
/*      */   }
/*      */ 
/*      */   protected static void addUntransformableInterface(ClassPool pool, CtClass clazz) throws NotFoundException
/*      */   {
/* 1336 */     CtClass untransformable = pool.get(Untransformable.class.getName());
/* 1337 */     clazz.addInterface(untransformable);
/*      */   }
/*      */ 
/*      */   protected static String getMethodString(CtClass joinpoint, String method, CtClass[] params)
/*      */   {
/* 1342 */     StringBuffer sb = new StringBuffer();
/* 1343 */     sb.append(joinpoint);
/* 1344 */     sb.append(".");
/* 1345 */     sb.append("name");
/* 1346 */     sb.append("(");
/* 1347 */     for (int i = 0; i < params.length; i++)
/*      */     {
/* 1349 */       if (i > 0) sb.append(", ");
/* 1350 */       sb.append(params[i].getName());
/*      */     }
/* 1352 */     sb.append(")");
/*      */ 
/* 1354 */     return sb.toString();
/*      */   }
/*      */ 
/*      */   protected Field getJoinpointField()
/*      */   {
/* 2224 */     return this.joinpointField;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     try
/*      */     {
/*  107 */       THROWS_THROWABLE = new CtClass[] { AspectManager.instance().findClassPool(SecurityActions.getContextClassLoader()).get("java.lang.Throwable") };
/*      */     }
/*      */     catch (NotFoundException e)
/*      */     {
/*  113 */       throw new RuntimeException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static class JoinPointParameters
/*      */   {
/* 2011 */     public static final JoinPointParameters ONLY_ARGS = new JoinPointParameters(false, -1, false, -1, 0, null);
/* 2012 */     public static final JoinPointParameters TARGET_ARGS = new JoinPointParameters(true, 1, false, -1, 1, "$1");
/* 2013 */     public static final JoinPointParameters CALLER_ARGS = new JoinPointParameters(false, -1, true, 1, 1, "$1");
/* 2014 */     public static final JoinPointParameters TARGET_CALLER_ARGS = new JoinPointParameters(true, 1, true, 2, 2, "$1, $2");
/*      */     private boolean target;
/*      */     private boolean caller;
/*      */     private int targetIndex;
/*      */     private int callerIndex;
/*      */     private int firstArgIndex;
/*      */     private String targetCallerList;
/* 2155 */     private static final String[][] primitiveExtractions = { { "((Boolean) arguments [", "]).booleanValue()" }, { "((Integer) arguments[", "]).intValue()" }, { "((Double) arguments[", "]).doubleValue()" }, { "((Float) arguments[", "]).floatValue()" }, { "((Character) arguments[", "]).charValue()" }, { "((Byte) arguments [", "]).byteValue()" }, { "((Long) arguments[", "]).longValue()" }, { "((Short) arguments[", "]).shortValue()" } };
/*      */ 
/*      */     private JoinPointParameters(boolean target, int targetIndex, boolean caller, int callerIndex, int firstArgIndex, String targetCallerList)
/*      */     {
/* 2026 */       this.target = target;
/* 2027 */       this.targetIndex = targetIndex;
/* 2028 */       this.caller = caller;
/* 2029 */       this.callerIndex = callerIndex;
/* 2030 */       this.firstArgIndex = (firstArgIndex + 1);
/* 2031 */       this.targetCallerList = targetCallerList;
/*      */     }
/*      */ 
/*      */     public final boolean hasTarget()
/*      */     {
/* 2036 */       return this.target;
/*      */     }
/*      */ 
/*      */     public final int getTargetIndex()
/*      */     {
/* 2041 */       return this.targetIndex;
/*      */     }
/*      */ 
/*      */     public final boolean hasCaller()
/*      */     {
/* 2046 */       return this.caller;
/*      */     }
/*      */ 
/*      */     public final int getCallerIndex()
/*      */     {
/* 2051 */       return this.callerIndex;
/*      */     }
/*      */ 
/*      */     public final int getContextIndex()
/*      */     {
/* 2067 */       return this.caller ? this.callerIndex : this.targetIndex;
/*      */     }
/*      */ 
/*      */     public final int getFirstArgIndex()
/*      */     {
/* 2072 */       return this.firstArgIndex;
/*      */     }
/*      */ 
/*      */     public final String declareArgsArray(int totalParameters, boolean nullArgsArray)
/*      */     {
/* 2088 */       StringBuffer buffer = new StringBuffer("Object[] ");
/* 2089 */       buffer.append("arguments");
/* 2090 */       totalParameters++; if (totalParameters == this.firstArgIndex)
/*      */       {
/* 2092 */         if (nullArgsArray)
/*      */         {
/* 2094 */           buffer.append(" = null;");
/*      */         }
/*      */         else
/*      */         {
/* 2098 */           buffer.append(" = new Object[0];");
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 2103 */         buffer.append(" = new Object[]{($w)$");
/* 2104 */         buffer.append(this.firstArgIndex);
/* 2105 */         for (int i = this.firstArgIndex + 1; i < totalParameters; i++)
/*      */         {
/* 2107 */           buffer.append(", ($w)$");
/* 2108 */           buffer.append(i);
/*      */         }
/* 2110 */         buffer.append("};");
/*      */       }
/* 2112 */       return buffer.toString();
/*      */     }
/*      */ 
/*      */     public final void appendParameterList(StringBuffer code, CtClass[] parameterTypes)
/*      */     {
/* 2118 */       int j = this.firstArgIndex - 1;
/* 2119 */       int totalParameters = parameterTypes.length - j;
/* 2120 */       if (this.targetCallerList != null)
/*      */       {
/* 2122 */         code.append(this.targetCallerList);
/*      */       }
/* 2124 */       if (totalParameters == 0)
/*      */       {
/* 2126 */         return;
/*      */       }
/* 2128 */       if (this.targetCallerList != null)
/*      */       {
/* 2130 */         code.append(", ");
/*      */       }
/*      */ 
/* 2133 */       castArgument(code, parameterTypes[(j++)], 0);
/*      */ 
/* 2135 */       for (int i = 1; i < totalParameters; j++)
/*      */       {
/* 2137 */         code.append(", ");
/* 2138 */         castArgument(code, parameterTypes[j], i);
/*      */ 
/* 2135 */         i++;
/*      */       }
/*      */     }
/*      */ 
/*      */     public final void appendParameterListWithoutArgs(StringBuffer code)
/*      */     {
/* 2144 */       if (this.targetCallerList != null)
/*      */       {
/* 2146 */         code.append(',');
/* 2147 */         code.append(this.targetCallerList);
/*      */       }
/*      */     }
/*      */ 
/*      */     public final void castArgument(StringBuffer code, CtClass expectedType, int i)
/*      */     {
/* 2170 */       if (expectedType.isPrimitive())
/*      */       {
/* 2172 */         String[] extraction = null;
/* 2173 */         if (expectedType == CtClass.booleanType)
/*      */         {
/* 2175 */           extraction = primitiveExtractions[0];
/*      */         }
/* 2177 */         else if (expectedType == CtClass.intType)
/*      */         {
/* 2179 */           extraction = primitiveExtractions[1];
/*      */         }
/* 2181 */         else if (expectedType == CtClass.doubleType)
/*      */         {
/* 2183 */           extraction = primitiveExtractions[2];
/*      */         }
/* 2185 */         else if (expectedType == CtClass.floatType)
/*      */         {
/* 2187 */           extraction = primitiveExtractions[3];
/*      */         }
/* 2189 */         else if (expectedType == CtClass.charType)
/*      */         {
/* 2191 */           extraction = primitiveExtractions[4];
/*      */         }
/* 2193 */         else if (expectedType == CtClass.byteType)
/*      */         {
/* 2195 */           extraction = primitiveExtractions[5];
/*      */         }
/* 2197 */         else if (expectedType == CtClass.longType)
/*      */         {
/* 2199 */           extraction = primitiveExtractions[6];
/*      */         }
/* 2201 */         else if (expectedType == CtClass.shortType)
/*      */         {
/* 2203 */           extraction = primitiveExtractions[7];
/*      */         }
/* 2205 */         code.append(extraction[0]);
/* 2206 */         code.append(i);
/* 2207 */         code.append(extraction[1]);
/*      */       }
/*      */       else
/*      */       {
/* 2211 */         code.append("(");
/* 2212 */         code.append(expectedType.getName());
/* 2213 */         code.append(") ");
/* 2214 */         code.append("arguments");
/* 2215 */         code.append("[");
/* 2216 */         code.append(i);
/* 2217 */         code.append("]");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AfterAdviceCallStrategy extends JoinPointGenerator.AdviceCallStrategy
/*      */   {
/* 1978 */     private static AfterAdviceCallStrategy INSTANCE = new AfterAdviceCallStrategy();
/*      */ 
/*      */     public static final AfterAdviceCallStrategy getInstance()
/*      */     {
/* 1982 */       return INSTANCE;
/*      */     }
/*      */     private AfterAdviceCallStrategy() {
/* 1985 */       super();
/*      */     }
/*      */ 
/*      */     public String generateKey(JoinPointGenerator generator) {
/* 1989 */       if (generator.isVoid())
/*      */       {
/* 1991 */         return "";
/*      */       }
/* 1993 */       return "          ret = (" + generator.getReturnClassType().getName() + ")";
/*      */     }
/*      */ 
/*      */     public boolean appendAdviceCall(JoinPointGenerator.AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info)
/*      */       throws NotFoundException
/*      */     {
/* 2000 */       AdviceMethodProperties properties = setup.getAdviceMethodProperties();
/* 2001 */       if ((properties != null) && (!properties.isAdviceVoid()))
/*      */       {
/* 2003 */         call.append(key);
/*      */       }
/* 2005 */       return JoinPointGenerator.AdviceCallStrategy.access$700(this, setup, beforeCall, call, generator);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DefaultAdviceCallStrategy extends JoinPointGenerator.AdviceCallStrategy
/*      */   {
/* 1955 */     private static DefaultAdviceCallStrategy INSTANCE = new DefaultAdviceCallStrategy();
/*      */ 
/*      */     public static final DefaultAdviceCallStrategy getInstance()
/*      */     {
/* 1959 */       return INSTANCE;
/*      */     }
/*      */     private DefaultAdviceCallStrategy() {
/* 1962 */       super();
/*      */     }
/*      */ 
/*      */     public String generateKey(JoinPointGenerator generator) {
/* 1966 */       return null;
/*      */     }
/*      */ 
/*      */     public boolean appendAdviceCall(JoinPointGenerator.AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info)
/*      */     {
/* 1972 */       return JoinPointGenerator.AdviceCallStrategy.access$700(this, setup, beforeCall, call, generator);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class AroundAdviceCallStrategy extends JoinPointGenerator.AdviceCallStrategy
/*      */   {
/* 1822 */     private static ThreadLocal<AroundAdviceCallStrategy> INSTANCE = new ThreadLocal()
/*      */     {
/*      */       protected synchronized JoinPointGenerator.AroundAdviceCallStrategy initialValue()
/*      */       {
/* 1826 */         return new JoinPointGenerator.AroundAdviceCallStrategy(null);
/*      */       }
/* 1822 */     };
/*      */ 
/* 1837 */     private int addedAdvice = 0;
/* 1838 */     private boolean consistencyEnforced = false;
/*      */ 
/*      */     public static final AroundAdviceCallStrategy getInstance()
/*      */     {
/* 1832 */       return (AroundAdviceCallStrategy)INSTANCE.get();
/*      */     }
/*      */     private AroundAdviceCallStrategy() {
/* 1835 */       super();
/*      */     }
/*      */ 
/*      */     public String generateKey(JoinPointGenerator generator)
/*      */     {
/* 1842 */       this.addedAdvice = 0;
/* 1843 */       if (generator.isVoid())
/*      */       {
/* 1845 */         return "";
/*      */       }
/* 1847 */       return "return ($w)";
/*      */     }
/*      */ 
/*      */     public boolean appendAdviceCall(JoinPointGenerator.AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info)
/*      */     {
/* 1853 */       if (!setup.shouldInvokeAspect())
/*      */       {
/* 1856 */         return false;
/*      */       }
/*      */ 
/* 1859 */       boolean result = false;
/*      */ 
/* 1861 */       AdviceMethodProperties properties = setup.getAdviceMethodProperties();
/* 1862 */       if ((properties == null) || (properties.getAdviceMethod() == null))
/*      */       {
/* 1866 */         return false;
/*      */       }
/*      */ 
/* 1869 */       beforeCall.append("      case ");
/* 1870 */       beforeCall.append(++this.addedAdvice);
/* 1871 */       beforeCall.append(":");
/*      */ 
/* 1873 */       if (setup.getCFlowString() != null)
/*      */       {
/* 1875 */         beforeCall.append("         if (matchesCflow" + setup.useCFlowFrom() + ")");
/* 1876 */         beforeCall.append("         {");
/* 1877 */         result = appendAroundCallString(beforeCall, call, key, setup, properties, generator);
/* 1878 */         call.append("         }");
/* 1879 */         call.append("         else");
/* 1880 */         call.append("         {");
/* 1881 */         call.append("            ");
/* 1882 */         call.append(key);
/* 1883 */         call.append(" invokeNext();");
/* 1884 */         call.append("         }");
/*      */       }
/*      */       else
/*      */       {
/* 1888 */         result = appendAroundCallString(beforeCall, call, key, setup, properties, generator);
/*      */       }
/*      */ 
/* 1891 */       call.append("      break;");
/* 1892 */       return result;
/*      */     }
/*      */ 
/*      */     public boolean appendAroundCallString(StringBuffer beforeCall, StringBuffer call, String returnStr, JoinPointGenerator.AdviceSetup setup, AdviceMethodProperties properties, JoinPointGenerator generator)
/*      */     {
/* 1902 */       this.consistencyEnforced = false;
/* 1903 */       int[] args = properties.getArgs();
/*      */ 
/* 1905 */       call.append("   ");
/* 1906 */       call.append(returnStr);
/* 1907 */       call.append(" ");
/* 1908 */       boolean result = JoinPointGenerator.AdviceCallStrategy.access$700(this, setup, beforeCall, call, generator);
/*      */ 
/* 1910 */       return result;
/*      */     }
/*      */ 
/*      */     protected boolean appendParameter(StringBuffer beforeCall, StringBuffer call, int arg, Class adviceParam, AdviceMethodProperties properties, JoinPointGenerator generator)
/*      */     {
/* 1917 */       switch (arg)
/*      */       {
/*      */       case -3:
/* 1920 */         if (!generator.parameters.hasTarget())
/*      */           break;
/* 1922 */         call.append("typedTargetObject");
/* 1923 */         return false;
/*      */       case -7:
/* 1927 */         if (!generator.parameters.hasCaller())
/*      */           break;
/* 1929 */         call.append("typedCallingObject");
/* 1930 */         return false;
/*      */       case -6:
/* 1934 */         call.append("getArguments()");
/*      */ 
/* 1936 */         return true;
/*      */       case -5:
/* 1938 */       case -4: } if (arg >= 0)
/*      */       {
/* 1940 */         if (!this.consistencyEnforced)
/*      */         {
/* 1942 */           beforeCall.append("enforceArgsConsistency");
/* 1943 */           beforeCall.append("();");
/* 1944 */           this.consistencyEnforced = true;
/*      */         }
/* 1946 */         call.append(generator.getJoinPointArg(arg));
/* 1947 */         return false;
/*      */       }
/* 1949 */       return super.appendParameter(beforeCall, call, arg, adviceParam, properties, generator);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static abstract class AdviceCallStrategy
/*      */   {
/*      */     public boolean addInvokeCode(JoinPointGenerator generator, JoinPointGenerator.AdviceSetup[] setups, StringBuffer code, JoinPointInfo info)
/*      */       throws NotFoundException
/*      */     {
/* 1683 */       StringBuffer call = new StringBuffer();
/* 1684 */       if ((setups == null) || (setups.length == 0))
/*      */       {
/* 1686 */         return false;
/*      */       }
/* 1688 */       boolean argsFound = false;
/* 1689 */       String key = generateKey(generator);
/* 1690 */       for (int i = 0; i < setups.length; i++)
/*      */       {
/* 1692 */         call.setLength(0);
/* 1693 */         argsFound = (appendAdviceCall(setups[i], key, code, call, generator, info)) || (argsFound);
/*      */ 
/* 1695 */         code.append(call);
/* 1696 */         call.setLength(0);
/*      */       }
/* 1698 */       return argsFound;
/*      */     }
/*      */ 
/*      */     protected abstract String generateKey(JoinPointGenerator paramJoinPointGenerator);
/*      */ 
/*      */     protected abstract boolean appendAdviceCall(JoinPointGenerator.AdviceSetup paramAdviceSetup, String paramString, StringBuffer paramStringBuffer1, StringBuffer paramStringBuffer2, JoinPointGenerator paramJoinPointGenerator, JoinPointInfo paramJoinPointInfo) throws NotFoundException;
/*      */ 
/*      */     private final boolean appendAdviceCall(JoinPointGenerator.AdviceSetup setup, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator) {
/* 1708 */       AdviceMethodProperties properties = setup.getAdviceMethodProperties();
/* 1709 */       if (properties == null)
/*      */       {
/* 1711 */         return false;
/*      */       }
/* 1713 */       call.append(setup.getAspectFieldName());
/* 1714 */       call.append(".");
/* 1715 */       call.append(setup.getAdviceName());
/* 1716 */       call.append("(");
/*      */ 
/* 1718 */       int[] args = properties.getArgs();
/* 1719 */       boolean argsFound = false;
/* 1720 */       if (args.length > 0)
/*      */       {
/* 1722 */         Class[] adviceParams = properties.getAdviceMethod().getParameterTypes();
/* 1723 */         if (properties.isAdviceOverloaded())
/*      */         {
/* 1725 */           appendCast(call, adviceParams[0]);
/*      */         }
/* 1727 */         argsFound = appendParameter(beforeCall, call, args[0], adviceParams[0], properties, generator);
/*      */ 
/* 1729 */         for (int i = 1; i < args.length; i++)
/*      */         {
/* 1731 */           call.append(", ");
/* 1732 */           if (properties.isAdviceOverloaded())
/*      */           {
/* 1734 */             appendCast(call, adviceParams[i]);
/*      */           }
/* 1736 */           argsFound = (appendParameter(beforeCall, call, args[i], adviceParams[i], properties, generator)) || (argsFound);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1741 */       call.append(");\n");
/* 1742 */       return argsFound;
/*      */     }
/*      */ 
/*      */     protected boolean appendParameter(StringBuffer beforeCall, StringBuffer call, int arg, Class adviceParam, AdviceMethodProperties properties, JoinPointGenerator generator)
/*      */     {
/* 1749 */       switch (arg)
/*      */       {
/*      */       case -2:
/* 1752 */         call.append("this");
/* 1753 */         break;
/*      */       case -1:
/* 1755 */         call.append("info");
/* 1756 */         break;
/*      */       case -4:
/* 1758 */         call.append("ret");
/* 1759 */         break;
/*      */       case -5:
/* 1761 */         call.append("t");
/* 1762 */         break;
/*      */       case -3:
/* 1764 */         if (!generator.parameters.hasTarget())
/*      */         {
/* 1766 */           call.append("null");
/*      */         }
/*      */         else
/*      */         {
/* 1770 */           call.append('$');
/* 1771 */           call.append(generator.parameters.getTargetIndex());
/*      */         }
/* 1773 */         break;
/*      */       case -7:
/* 1775 */         if (!generator.parameters.hasCaller())
/*      */         {
/* 1777 */           call.append("null");
/*      */         }
/*      */         else
/*      */         {
/* 1781 */           call.append('$');
/* 1782 */           call.append(generator.parameters.getCallerIndex());
/*      */         }
/* 1784 */         break;
/*      */       case -6:
/* 1786 */         call.append("arguments");
/*      */ 
/* 1789 */         ((Set)generator.inconsistentTypeArgs.get()).addAll(generator.joinPointArguments);
/*      */ 
/* 1791 */         return true;
/*      */       default:
/* 1795 */         Set inconsistentTypeArgs = (Set)generator.inconsistentTypeArgs.get();
/* 1796 */         int argIndex = arg + generator.parameters.getFirstArgIndex();
/* 1797 */         if (inconsistentTypeArgs.contains(Integer.valueOf(arg)))
/*      */         {
/* 1799 */           beforeCall.append("$").append(argIndex).append(" = ");
/* 1800 */           beforeCall.append(ReflectToJavassist.castInvocationValueToTypeString(properties.getJoinpointParameterClassTypes()[arg], "arguments[" + arg + ']'));
/*      */ 
/* 1802 */           beforeCall.append(';');
/* 1803 */           inconsistentTypeArgs.remove(Integer.valueOf(arg));
/*      */         }
/*      */ 
/* 1806 */         call.append("$");
/* 1807 */         call.append(arg + generator.parameters.getFirstArgIndex());
/*      */       }
/* 1809 */       return false;
/*      */     }
/*      */ 
/*      */     protected void appendCast(StringBuffer call, Class adviceParam)
/*      */     {
/* 1814 */       call.append("(");
/* 1815 */       call.append(ClassExpression.simpleType(adviceParam));
/* 1816 */       call.append(")");
/*      */     }
/*      */   }
/*      */ 
/*      */   private static abstract interface GenerateJoinPointClassAction
/*      */   {
/* 1642 */     public static final GenerateJoinPointClassAction PRIVILEGED = new GenerateJoinPointClassAction()
/*      */     {
/*      */       public Object generateJoinPointClass(ClassLoader classloader, JoinPointGenerator joinPointGenerator, JoinPointInfo info) {
/*      */         Exception actual;
/*      */         try {
/* 1648 */           return AccessController.doPrivileged(new PrivilegedExceptionAction(joinPointGenerator, classloader, info)
/*      */           {
/*      */             public Object run() throws Exception
/*      */             {
/* 1652 */               return this.val$joinPointGenerator.doGenerateJoinPointClass(this.val$classloader, this.val$info);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1658 */           actual = e.getException();
/* 1659 */           if ((actual instanceof RuntimeException))
/*      */           {
/* 1661 */             throw ((RuntimeException)actual);
/*      */           }
/*      */         }
/* 1663 */         throw new RuntimeException(actual);
/*      */       }
/* 1642 */     };
/*      */ 
/* 1668 */     public static final GenerateJoinPointClassAction NON_PRIVILEGED = new GenerateJoinPointClassAction()
/*      */     {
/*      */       public Object generateJoinPointClass(ClassLoader classloader, JoinPointGenerator joinPointGenerator, JoinPointInfo info)
/*      */       {
/* 1672 */         return joinPointGenerator.doGenerateJoinPointClass(classloader, info);
/*      */       }
/* 1668 */     };
/*      */ 
/*      */     public abstract Object generateJoinPointClass(ClassLoader paramClassLoader, JoinPointGenerator paramJoinPointGenerator, JoinPointInfo paramJoinPointInfo);
/*      */   }
/*      */ 
/*      */   private class AdviceSetups
/*      */   {
/*      */     JoinPointGenerator.AdviceSetup[] allSetups;
/*      */     JoinPointGenerator.AdviceSetup[][] setups;
/*      */     List<JoinPointGenerator.AdviceSetup> lightweightAdvicesRequiringInstanceAdvisor;
/*      */     boolean hasAroundAdvices;
/*      */     boolean hasArgsAroundAdvices;
/*      */ 
/*      */     AdviceSetups(JoinPointInfo info, JoinPointGenerator.AdviceSetup[] allSetups)
/*      */     {
/* 1535 */       this.allSetups = allSetups;
/* 1536 */       int length = AdviceType.values().length;
/* 1537 */       ArrayList[] aspects = (ArrayList[])new ArrayList[length];
/*      */ 
/* 1539 */       for (int i = 0; i < allSetups.length; i++)
/*      */       {
/* 1541 */         if (!allSetups[i].shouldInvokeAspect())
/*      */         {
/*      */           continue;
/*      */         }
/* 1545 */         AdviceMethodProperties properties = JoinPointGenerator.this.getAdviceMethodProperties(info, allSetups[i]);
/* 1546 */         AdviceType type = allSetups[i].getType();
/* 1547 */         int index = type.ordinal();
/* 1548 */         if (aspects[index] == null)
/*      */         {
/* 1550 */           aspects[index] = new ArrayList();
/*      */         }
/*      */ 
/* 1554 */         properties = type.getFactory().findAdviceMethod(properties);
/* 1555 */         allSetups[i].setAdviceMethodProperties(properties);
/* 1556 */         aspects[index].add(allSetups[i]);
/*      */ 
/* 1558 */         if (AdviceType.AROUND == type)
/*      */         {
/* 1560 */           this.hasAroundAdvices = true;
/* 1561 */           if (this.hasArgsAroundAdvices)
/*      */             continue;
/* 1563 */           if (hasInvocation(properties))
/*      */             continue;
/* 1565 */           this.hasArgsAroundAdvices = true;
/*      */         }
/*      */         else
/*      */         {
/* 1570 */           if (!allSetups[i].requiresInstanceAdvisor()) {
/*      */             continue;
/*      */           }
/* 1573 */           if (this.lightweightAdvicesRequiringInstanceAdvisor == null)
/*      */           {
/* 1575 */             this.lightweightAdvicesRequiringInstanceAdvisor = new ArrayList();
/*      */           }
/* 1577 */           this.lightweightAdvicesRequiringInstanceAdvisor.add(allSetups[i]);
/*      */         }
/*      */       }
/*      */ 
/* 1581 */       this.setups = new JoinPointGenerator.AdviceSetup[length][];
/* 1582 */       for (int i = 0; i < length; i++)
/*      */       {
/* 1584 */         this.setups[i] = (aspects[i] == null ? null : (JoinPointGenerator.AdviceSetup[])(JoinPointGenerator.AdviceSetup[])aspects[i].toArray(new JoinPointGenerator.AdviceSetup[aspects[i].size()]));
/*      */       }
/*      */     }
/*      */ 
/*      */     private boolean hasInvocation(AdviceMethodProperties properties)
/*      */     {
/* 1591 */       int[] args = properties.getArgs();
/* 1592 */       for (int z = 0; z < args.length; z++)
/*      */       {
/* 1594 */         if (args[z] == -2)
/*      */         {
/* 1596 */           return true;
/*      */         }
/*      */       }
/* 1599 */       return false;
/*      */     }
/*      */ 
/*      */     public JoinPointGenerator.AdviceSetup[] getAllSetups()
/*      */     {
/* 1607 */       return this.allSetups;
/*      */     }
/*      */ 
/*      */     public JoinPointGenerator.AdviceSetup[] getByType(AdviceType type)
/*      */     {
/* 1619 */       return this.setups[type.ordinal()];
/*      */     }
/*      */ 
/*      */     public boolean hasLightweightAdvicesRequiringInstanceAdvisor()
/*      */     {
/* 1624 */       return (this.lightweightAdvicesRequiringInstanceAdvisor != null) && (this.lightweightAdvicesRequiringInstanceAdvisor.size() > 0);
/*      */     }
/*      */ 
/*      */     public List<JoinPointGenerator.AdviceSetup> getLightweightAdvicesRequiringInstanceAdvisor()
/*      */     {
/* 1629 */       return this.lightweightAdvicesRequiringInstanceAdvisor;
/*      */     }
/*      */ 
/*      */     public boolean getHasArgsAroundAdvices()
/*      */     {
/* 1634 */       return this.hasArgsAroundAdvices;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class GeneratedClassInfo
/*      */   {
/*      */     CtClass generated;
/*      */     JoinPointGenerator.AdviceSetup[] aroundSetups;
/*      */ 
/*      */     GeneratedClassInfo(CtClass generated, JoinPointGenerator.AdviceSetups setups)
/*      */     {
/* 1510 */       this.generated = generated;
/* 1511 */       this.aroundSetups = setups.getByType(AdviceType.AROUND);
/*      */     }
/*      */ 
/*      */     CtClass getGenerated()
/*      */     {
/* 1516 */       return this.generated;
/*      */     }
/*      */ 
/*      */     JoinPointGenerator.AdviceSetup[] getAroundSetups()
/*      */     {
/* 1521 */       return this.aroundSetups == null ? new JoinPointGenerator.AdviceSetup[0] : this.aroundSetups;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class AdviceSetup
/*      */   {
/*      */     int index;
/*      */     Class aspectClass;
/*      */     CtClass aspectCtClass;
/*      */     String adviceName;
/*      */     Class thrownType;
/*      */     Scope scope;
/*      */     String registeredName;
/*      */     String cflowString;
/*      */     ASTCFlowExpression cflowExpr;
/*      */     int cflowIndex;
/*      */     AdviceType type;
/*      */     AdviceMethodProperties adviceMethodProperties;
/*      */ 
/*      */     AdviceSetup(int index, GeneratedAdvisorInterceptor ifw, JoinPointInfo info, ClassLoader classLoader)
/*      */       throws ClassNotFoundException, NotFoundException
/*      */     {
/* 1375 */       this.index = index;
/* 1376 */       this.scope = ifw.getScope();
/* 1377 */       this.adviceName = ifw.getAdviceName();
/* 1378 */       this.registeredName = ifw.getRegisteredName();
/* 1379 */       this.cflowString = ifw.getCFlowString();
/* 1380 */       this.cflowExpr = ifw.getCflowExpression();
/*      */       Object aspectInstance;
/* 1381 */       if (ifw.isAspectFactory())
/*      */       {
/* 1383 */         aspectInstance = ((GeneratedAdvisorInterceptor)info.getInterceptors()[index]).getAspect(info.getAdvisor(), info.getJoinpoint(), true);
/* 1384 */         this.aspectClass = aspectInstance.getClass();
/*      */       }
/*      */       else
/*      */       {
/* 1388 */         this.aspectClass = classLoader.loadClass(ifw.getAspectClassName());
/*      */       }
/* 1390 */       this.aspectCtClass = ReflectToJavassist.classToJavassist(this.aspectClass);
/*      */ 
/* 1392 */       this.type = ifw.getType();
/*      */     }
/*      */ 
/*      */     String getAdviceName()
/*      */     {
/* 1397 */       return this.adviceName;
/*      */     }
/*      */ 
/*      */     Class getAspectClass()
/*      */     {
/* 1403 */       return this.aspectClass;
/*      */     }
/*      */ 
/*      */     CtClass getAspectCtClass()
/*      */     {
/* 1408 */       return this.aspectCtClass;
/*      */     }
/*      */ 
/*      */     Scope getScope()
/*      */     {
/* 1413 */       return this.scope;
/*      */     }
/*      */ 
/*      */     int getIndex()
/*      */     {
/* 1418 */       return this.index;
/*      */     }
/*      */ 
/*      */     String getRegisteredName()
/*      */     {
/* 1423 */       return this.registeredName;
/*      */     }
/*      */ 
/*      */     String getAspectFieldName()
/*      */     {
/* 1428 */       StringBuffer name = new StringBuffer();
/* 1429 */       name.append(this.type.getName());
/* 1430 */       name.append(this.index + 1);
/* 1431 */       return name.toString();
/*      */     }
/*      */ 
/*      */     String getAspectInitialiserName()
/*      */     {
/* 1436 */       StringBuffer name = new StringBuffer();
/* 1437 */       name.append(this.type.getAccessor());
/* 1438 */       name.append(this.index + 1);
/* 1439 */       return name.toString();
/*      */     }
/*      */ 
/*      */     boolean isPerInstance()
/*      */     {
/* 1444 */       return this.scope == Scope.PER_INSTANCE;
/*      */     }
/*      */ 
/*      */     boolean isPerJoinpoint()
/*      */     {
/* 1449 */       return this.scope == Scope.PER_JOINPOINT;
/*      */     }
/*      */ 
/*      */     boolean shouldInvokeAspect()
/*      */     {
/* 1454 */       return (!isPerInstance()) || (!JoinPointGenerator.this.isStaticCall());
/*      */     }
/*      */ 
/*      */     boolean requiresInstanceAdvisor()
/*      */     {
/* 1459 */       return (isPerInstance()) || ((isPerJoinpoint()) && (!JoinPointGenerator.this.isStaticCall()));
/*      */     }
/*      */ 
/*      */     String getCFlowString()
/*      */     {
/* 1464 */       return this.cflowString;
/*      */     }
/*      */ 
/*      */     ASTCFlowExpression getCFlow()
/*      */     {
/* 1469 */       return this.cflowExpr;
/*      */     }
/*      */ 
/*      */     void setUseCFlowFrom(int index)
/*      */     {
/* 1474 */       this.cflowIndex = index;
/*      */     }
/*      */ 
/*      */     int useCFlowFrom()
/*      */     {
/* 1479 */       return this.cflowIndex;
/*      */     }
/*      */ 
/*      */     boolean isNewCFlow()
/*      */     {
/* 1484 */       return (getCFlowString() != null) && (this.index == this.cflowIndex);
/*      */     }
/*      */ 
/*      */     public AdviceType getType()
/*      */     {
/* 1489 */       return this.type;
/*      */     }
/*      */ 
/*      */     public AdviceMethodProperties getAdviceMethodProperties()
/*      */     {
/* 1494 */       return this.adviceMethodProperties;
/*      */     }
/*      */ 
/*      */     public void setAdviceMethodProperties(AdviceMethodProperties adviceMethodProperties)
/*      */     {
/* 1499 */       this.adviceMethodProperties = adviceMethodProperties;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.JoinPointGenerator
 * JD-Core Version:    0.6.0
 */