/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ConByConInfo;
/*     */ import org.jboss.aop.ConByMethodInfo;
/*     */ import org.jboss.aop.FieldInfo;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodByConInfo;
/*     */ import org.jboss.aop.MethodByMethodInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ 
/*     */ public class GeneratedAdvisorInstrumentor extends Instrumentor
/*     */ {
/*     */   private static final String CURRENT_ADVISOR = "currentAdvisor$aop";
/*     */   private static final String INSTANCE_ADVISOR = "instanceAdvisor$aop";
/*     */   private static final String GET_CURRENT_ADVISOR_NAME = "getCurrentAdvisor$aop";
/*     */   public static final String GET_CURRENT_ADVISOR = "getCurrentAdvisor$aop()";
/*     */   private static final String DOMAIN = "domain";
/*     */   private static final String CHECK_VERSION = "checkVersion";
/*     */   private static final String ADVICES_UPDATED = "advicesUpdated";
/*     */   private static final String INSTANCE_ADVISOR_MIXIN = "instanceAdvisorMixin";
/*     */   private static final String CREATE_INSTANCE_ADVISOR = "createInstanceAdvisor";
/*     */   private static final String INITIALISE_CALLERS = "initialiseCallers";
/*     */   private static final String INITIALISE_FIELD_WRITES = "initialiseFieldWrites";
/*     */   private static final String INITIALISE_FIELD_READS = "initialiseFieldReads";
/*     */   private static final String INITIALISE_CONSTRUCTIONS = "initialiseConstructions";
/*     */   private static final String INITIALISE_CONSTRUCTORS = "initialiseConstructors";
/*     */   private static final String INITIALISE_METHODS = "initialiseMethods";
/*     */   private static final String INITIALISE_INFOS_FOR_INSTANCE = "initialiseInfosForInstance";
/*     */   public static final String GET_CLASS_ADVISOR = "_getClassAdvisor";
/*     */   private static final String DO_REBUILD_FOR_INSTANCE = "doRebuildForInstance";
/*     */   private static final String DECLARING_CLASS = "this.getClass().getDeclaringClass()";
/*  82 */   private static final CtClass[] EMPTY_EXCEPTIONS = new CtClass[0];
/*  83 */   private static final CtClass[] EMPTY_SIG = new CtClass[0];
/*     */   CtClass clazz;
/*     */   CtClass genadvisor;
/*     */   CtClass genInstanceAdvisor;
/*     */ 
/*     */   public GeneratedAdvisorInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer)
/*     */   {
/*  91 */     super(pool, manager, joinpointClassifier, observer);
/*     */   }
/*     */ 
/*     */   public GeneratedAdvisorInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier)
/*     */   {
/*  96 */     super(manager, joinpointClassifier);
/*     */   }
/*     */ 
/*     */   protected CtClass getGenadvisor()
/*     */   {
/* 101 */     return this.genadvisor;
/*     */   }
/*     */ 
/*     */   protected CtClass getGenInstanceadvisor()
/*     */   {
/* 106 */     return this.genInstanceAdvisor;
/*     */   }
/*     */ 
/*     */   public boolean transform(CtClass clazz, ClassAdvisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 114 */       this.clazz = clazz;
/* 115 */       if (super.transform(clazz, advisor))
/*     */       {
/* 117 */         if (this.genadvisor != null)
/*     */         {
/* 119 */           addInstanceAdvisorWrappers(clazz);
/* 120 */           TransformerCommon.compileOrLoadClass(clazz, this.genadvisor);
/* 121 */           TransformerCommon.compileOrLoadClass(clazz, this.genInstanceAdvisor);
/*     */         }
/* 123 */         return true;
/*     */       }
/* 125 */       return false;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 129 */       if (AspectManager.suppressTransformationErrors)
/*     */       {
/* 131 */         System.err.println("[warn] AOP Instrumentor failed to transform " + clazz.getName());
/* 132 */         e.printStackTrace();
/* 133 */         return false;
/*     */       }
/*     */ 
/* 137 */       if ((e instanceof TransformationException))
/*     */       {
/* 139 */         throw ((TransformationException)e);
/*     */       }
/*     */ 
/* 143 */       e.printStackTrace();
/* 144 */     }throw new RuntimeException("failed to transform: " + clazz.getName(), e);
/*     */   }
/*     */ 
/*     */   protected void intitialiseTransformers()
/*     */   {
/* 154 */     this.callerTransformer = new GeneratedAdvisorCallerTransformer(this, this.manager);
/* 155 */     this.fieldAccessTransformer = new GeneratedAdvisorFieldAccessTransformer(this);
/* 156 */     this.constructorExecutionTransformer = new GeneratedAdvisorConstructorExecutionTransformer(this);
/* 157 */     this.constructionTransformer = new GeneratedAdvisorConstructionTransformer(this);
/* 158 */     this.methodExecutionTransformer = new GeneratedAdvisorMethodExecutionTransformer(this);
/*     */   }
/*     */ 
/*     */   protected CtMethod createMixinInvokeMethod(CtClass clazz, CtClass mixinClass, String initializer, CtMethod method, long hash)
/*     */     throws CannotCompileException, NotFoundException, Exception
/*     */   {
/* 165 */     return ((GeneratedAdvisorMethodExecutionTransformer)this.methodExecutionTransformer).addMixinWrappersAndInfo(this, clazz, mixinClass, initializer, this.genadvisor, method);
/*     */   }
/*     */ 
/*     */   protected static String getAdvisorName(CtClass clazz)
/*     */   {
/* 171 */     String className = clazz.getName();
/* 172 */     return className.substring(className.lastIndexOf('.') + 1) + "Advisor";
/*     */   }
/*     */ 
/*     */   protected static String getInstanceAdvisorName(CtClass clazz)
/*     */   {
/* 178 */     String className = clazz.getName();
/* 179 */     return className.substring(className.lastIndexOf('.') + 1) + "InstanceAdvisor";
/*     */   }
/*     */ 
/*     */   protected static String getAdvisorFQN(CtClass clazz)
/*     */   {
/* 184 */     return clazz.getName() + "$" + getAdvisorName(clazz);
/*     */   }
/*     */ 
/*     */   protected static String getInstanceAdvisorFQN(CtClass clazz)
/*     */   {
/* 189 */     return clazz.getName() + "$" + getInstanceAdvisorName(clazz);
/*     */   }
/*     */ 
/*     */   protected CtClass createAdvisorClass(CtClass clazz) throws NotFoundException, CannotCompileException
/*     */   {
/* 194 */     String innerClassName = getAdvisorName(clazz);
/*     */ 
/* 197 */     boolean classStatic = true;
/* 198 */     this.genadvisor = TransformerCommon.makeNestedClass(clazz, innerClassName, true);
/*     */ 
/* 203 */     CtClass superAdvisor = getSuperClassAdvisor(clazz.getSuperclass());
/* 204 */     if (superAdvisor == null)
/*     */     {
/* 206 */       this.genadvisor.setSuperclass(forName(GeneratedClassAdvisor.class.getName()));
/*     */     }
/*     */     else
/*     */     {
/* 210 */       this.genadvisor.setSuperclass(superAdvisor);
/*     */     }
/*     */ 
/* 214 */     CtClass untransformable = getClassPool().get("org.jboss.aop.instrument.Untransformable");
/* 215 */     this.genadvisor.addInterface(untransformable);
/*     */ 
/* 218 */     CtField domain = new CtField(forName("org.jboss.aop.Domain"), "domain", this.genadvisor);
/* 219 */     domain.setModifiers(4);
/* 220 */     this.genadvisor.addField(domain);
/* 221 */     CtMethod getter = CtNewMethod.getter("getDomain", domain);
/* 222 */     this.genadvisor.addMethod(getter);
/*     */ 
/* 224 */     CtMethod initialiseMethods = CtNewMethod.make(4, CtClass.voidType, "initialiseMethods", EMPTY_SIG, EMPTY_EXCEPTIONS, isBaseClass(clazz) ? null : "{super.initialiseMethods();}", this.genadvisor);
/*     */ 
/* 233 */     this.genadvisor.addMethod(initialiseMethods);
/*     */ 
/* 235 */     CtMethod initialiseConstructors = CtNewMethod.make(4, CtClass.voidType, "initialiseConstructors", EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genadvisor);
/*     */ 
/* 243 */     this.genadvisor.addMethod(initialiseConstructors);
/*     */ 
/* 245 */     CtMethod initialiseConstructions = CtNewMethod.make(4, CtClass.voidType, "initialiseConstructions", EMPTY_SIG, EMPTY_EXCEPTIONS, isBaseClass(clazz) ? null : "{super.initialiseConstructions();}", this.genadvisor);
/*     */ 
/* 254 */     this.genadvisor.addMethod(initialiseConstructions);
/*     */ 
/* 256 */     CtMethod initialiseFieldReads = CtNewMethod.make(4, CtClass.voidType, "initialiseFieldReads", EMPTY_SIG, EMPTY_EXCEPTIONS, isBaseClass(clazz) ? null : "{super.initialiseFieldReads();}", this.genadvisor);
/*     */ 
/* 265 */     this.genadvisor.addMethod(initialiseFieldReads);
/*     */ 
/* 267 */     CtMethod initialiseFieldWrites = CtNewMethod.make(4, CtClass.voidType, "initialiseFieldWrites", EMPTY_SIG, EMPTY_EXCEPTIONS, isBaseClass(clazz) ? null : "{super.initialiseFieldWrites();}", this.genadvisor);
/*     */ 
/* 276 */     this.genadvisor.addMethod(initialiseFieldWrites);
/*     */ 
/* 278 */     CtMethod initialiseCallers = CtNewMethod.make(4, CtClass.voidType, "initialiseCallers", EMPTY_SIG, EMPTY_EXCEPTIONS, isBaseClass(clazz) ? null : "{super.initialiseCallers();}", this.genadvisor);
/*     */ 
/* 287 */     this.genadvisor.addMethod(initialiseCallers);
/*     */ 
/* 289 */     createAdvisorCtors(clazz);
/*     */ 
/* 291 */     return this.genadvisor;
/*     */   }
/*     */ 
/*     */   protected CtClass createInstanceAdvisorClass(CtClass clazz) throws NotFoundException, CannotCompileException
/*     */   {
/* 296 */     String innerClassName = getInstanceAdvisorName(clazz);
/*     */ 
/* 299 */     boolean classStatic = true;
/* 300 */     this.genInstanceAdvisor = TransformerCommon.makeNestedClass(clazz, innerClassName, true);
/*     */ 
/* 302 */     this.genInstanceAdvisor.setModifiers(Modifier.setPublic(this.genInstanceAdvisor.getModifiers()));
/*     */ 
/* 305 */     this.genInstanceAdvisor.setSuperclass(getGenadvisor());
/*     */ 
/* 308 */     CtClass untransformable = getClassPool().get("org.jboss.aop.instrument.Untransformable");
/* 309 */     this.genInstanceAdvisor.addInterface(untransformable);
/*     */ 
/* 311 */     CtMethod advicesUpdated = CtNewMethod.make(4, CtClass.voidType, "advicesUpdated", EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genInstanceAdvisor);
/*     */ 
/* 319 */     this.genInstanceAdvisor.addMethod(advicesUpdated);
/*     */ 
/* 321 */     implementInstanceAdvisorMethods();
/*     */ 
/* 323 */     String drfiBody = "{   internalRebuildInterceptors();    if (instanceAdvisorMixin.hasInterceptors())   {       advicesUpdated();   }}";
/*     */ 
/* 331 */     CtMethod doRebuildForInstance = CtNewMethod.make(4, CtClass.voidType, "doRebuildForInstance", EMPTY_SIG, EMPTY_EXCEPTIONS, drfiBody, this.genInstanceAdvisor);
/*     */ 
/* 339 */     this.genInstanceAdvisor.addMethod(doRebuildForInstance);
/*     */ 
/* 341 */     String body = "{    super($2);   instanceAdvisorMixin = new org.jboss.aop.GeneratedInstanceAdvisorMixin($1, $2);}";
/*     */ 
/* 346 */     CtConstructor ctor = CtNewConstructor.make(new CtClass[] { forName("java.lang.Object"), this.genadvisor }, new CtClass[0], body, this.genInstanceAdvisor);
/* 347 */     this.genInstanceAdvisor.addConstructor(ctor);
/*     */ 
/* 350 */     CtMethod initialiseInfosForInstance = CtNewMethod.make(4, CtClass.voidType, "initialiseInfosForInstance", EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genInstanceAdvisor);
/*     */ 
/* 358 */     this.genInstanceAdvisor.addMethod(initialiseInfosForInstance);
/*     */ 
/* 360 */     return this.genInstanceAdvisor;
/*     */   }
/*     */ 
/*     */   protected void createAdvisorCtors(CtClass clazz) throws CannotCompileException, NotFoundException
/*     */   {
/* 365 */     String initBody = "{   java.lang.String domainName = org.jboss.aop.Domain.getDomainName(this.getClass().getDeclaringClass(), $2);   domain= new org.jboss.aop.GeneratedAdvisorDomain($1, domainName, this.getClass().getDeclaringClass(), $2);    ((org.jboss.aop.Domain)domain).setInheritsBindings(true);    super.initialise(this.getClass().getDeclaringClass(), domain);}";
/*     */ 
/* 373 */     CtMethod initialise = CtNewMethod.make(4, CtClass.voidType, "initialise", new CtClass[] { forName("org.jboss.aop.AspectManager"), CtClass.booleanType }, EMPTY_EXCEPTIONS, initBody, this.genadvisor);
/*     */ 
/* 381 */     this.genadvisor.addMethod(initialise);
/*     */ 
/* 385 */     CtConstructor ctor = CtNewConstructor.defaultConstructor(this.genadvisor);
/* 386 */     ctor.setBody("{   super(\"" + clazz.getName() + "\"); " + "   initialise(org.jboss.aop.AspectManager.instance(this.getClass().getClassLoader()), false);" + "}");
/*     */ 
/* 391 */     this.genadvisor.addConstructor(ctor);
/*     */ 
/* 394 */     String instanceBody = "{   super(\"" + clazz.getName() + "\", $1); " + "   initialise($1.getDomain(), true);" + "}";
/*     */ 
/* 399 */     CtConstructor ctorWithParentAdvisor = CtNewConstructor.make(new CtClass[] { this.genadvisor }, EMPTY_EXCEPTIONS, instanceBody, this.genadvisor);
/* 400 */     this.genadvisor.addConstructor(ctorWithParentAdvisor);
/*     */ 
/* 404 */     CtConstructor ctorForSubAdvisors = CtNewConstructor.make(new CtClass[] { forName("java.lang.String") }, new CtClass[0], "{super($1);}", this.genadvisor);
/* 405 */     this.genadvisor.addConstructor(ctorForSubAdvisors);
/* 406 */     ctorForSubAdvisors.setModifiers(4);
/*     */ 
/* 409 */     CtConstructor ctorForSubAdvisorInstanceAdvisors = CtNewConstructor.make(new CtClass[] { forName("java.lang.String"), forName("org.jboss.aop.GeneratedClassAdvisor") }, new CtClass[0], "{super($1, $2);}", this.genadvisor);
/* 410 */     this.genadvisor.addConstructor(ctorForSubAdvisorInstanceAdvisors);
/* 411 */     ctorForSubAdvisorInstanceAdvisors.setModifiers(4);
/*     */   }
/*     */ 
/*     */   protected CtClass getSuperClassAdvisor(CtClass superclass) throws NotFoundException
/*     */   {
/* 416 */     if (superclass != null)
/*     */     {
/*     */       try
/*     */       {
/* 420 */         if (isAdvised(superclass))
/*     */         {
/* 422 */           return forName(superclass.getClassPool(), getAdvisorFQN(superclass));
/*     */         }
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/*     */       }
/*     */ 
/* 429 */       return getSuperClassAdvisor(superclass.getSuperclass());
/*     */     }
/* 431 */     return null;
/*     */   }
/*     */ 
/*     */   protected void implementInstanceAdvisorMethods()
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 437 */     CtClass instanceAdvisor = getClassPool().get("org.jboss.aop.InstanceAdvisor");
/* 438 */     this.genInstanceAdvisor.addInterface(instanceAdvisor);
/*     */ 
/* 440 */     CtField instanceAdvisorMixin = new CtField(getClassPool().get("org.jboss.aop.GeneratedInstanceAdvisorMixin"), "instanceAdvisorMixin", this.genInstanceAdvisor);
/*     */ 
/* 444 */     this.genInstanceAdvisor.addField(instanceAdvisorMixin);
/*     */ 
/* 446 */     CtMethod[] instanceAdvisorMethods = instanceAdvisor.getDeclaredMethods();
/* 447 */     for (int i = 0; i < instanceAdvisorMethods.length; i++)
/*     */     {
/* 449 */       String name = instanceAdvisorMethods[i].getName();
/* 450 */       if (name.equals("hasAspects"))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 455 */       if (name.equals("getDomain"))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 461 */       String ret = instanceAdvisorMethods[i].getReturnType().equals(CtClass.voidType) ? "" : "return ";
/* 462 */       StringBuffer delegatingBody = new StringBuffer();
/* 463 */       delegatingBody.append("{");
/* 464 */       if ((name.startsWith("insertInterceptor")) || (name.startsWith("removeInterceptor")) || (name.startsWith("appendInterceptor")))
/*     */       {
/* 466 */         delegatingBody.append("advicesUpdated();");
/*     */       }
/* 468 */       if (!instanceAdvisorMethods[i].getReturnType().equals(CtClass.voidType))
/*     */       {
/* 470 */         delegatingBody.append("return ");
/*     */       }
/* 472 */       delegatingBody.append("instanceAdvisorMixin." + instanceAdvisorMethods[i].getName() + "($$);}");
/*     */ 
/* 474 */       CtMethod m = CtNewMethod.make(1, instanceAdvisorMethods[i].getReturnType(), instanceAdvisorMethods[i].getName(), instanceAdvisorMethods[i].getParameterTypes(), instanceAdvisorMethods[i].getExceptionTypes(), delegatingBody.toString(), this.genInstanceAdvisor);
/*     */ 
/* 482 */       this.genInstanceAdvisor.addMethod(m);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addCreateInstanceAdvisorToGenAdvisor(CtClass clazz) throws NotFoundException, CannotCompileException
/*     */   {
/* 488 */     CtMethod createInstanceAdvisor = CtNewMethod.make(1, forName("org.jboss.aop.Advisor"), "createInstanceAdvisor", new CtClass[] { forName("java.lang.Object") }, EMPTY_EXCEPTIONS, "{return new " + getInstanceAdvisorFQN(clazz) + "($1, this);}", this.genadvisor);
/*     */ 
/* 496 */     this.genadvisor.addMethod(createInstanceAdvisor);
/*     */   }
/*     */ 
/*     */   protected void doSetupBasics(CtClass clazz) throws CannotCompileException, NotFoundException
/*     */   {
/* 501 */     createAdvisorClass(clazz);
/* 502 */     createInstanceAdvisorClass(clazz);
/* 503 */     addCreateInstanceAdvisorToGenAdvisor(clazz);
/* 504 */     createAdvisorFieldsAndGetter(clazz);
/*     */   }
/*     */ 
/*     */   private void createAdvisorFieldsAndGetter(CtClass clazz) throws NotFoundException, CannotCompileException
/*     */   {
/* 509 */     CtField classAdvisor = new CtField(forName("org.jboss.aop.Advisor"), "aop$classAdvisor$aop", clazz);
/*     */ 
/* 513 */     classAdvisor.setModifiers(138);
/* 514 */     clazz.addField(classAdvisor, CtField.Initializer.byExpr("new " + getAdvisorFQN(clazz) + "()"));
/*     */ 
/* 517 */     CtMethod getAdvisor = CtNewMethod.getter("_getAdvisor", classAdvisor);
/* 518 */     getAdvisor.setModifiers(1);
/* 519 */     clazz.addMethod(getAdvisor);
/*     */ 
/* 521 */     CtMethod getClassAdvisor = CtNewMethod.getter("_getClassAdvisor", classAdvisor);
/* 522 */     getClassAdvisor.setModifiers(9);
/* 523 */     clazz.addMethod(getClassAdvisor);
/*     */ 
/* 525 */     if (isBaseClass(clazz))
/*     */     {
/* 527 */       CtField currentAdvisor = new CtField(forName("org.jboss.aop.Advisor"), "currentAdvisor$aop", clazz);
/*     */ 
/* 531 */       currentAdvisor.setModifiers(196);
/* 532 */       clazz.addField(currentAdvisor, CtField.Initializer.byExpr("_getAdvisor()"));
/*     */ 
/* 534 */       String body = "{   if (currentAdvisor$aop == null)   {      currentAdvisor$aop = _getAdvisor();   }   return currentAdvisor$aop;}";
/*     */ 
/* 542 */       CtMethod getCurrentAdvisor = CtNewMethod.make(4, forName("org.jboss.aop.Advisor"), "getCurrentAdvisor$aop", EMPTY_SIG, EMPTY_EXCEPTIONS, body, clazz);
/*     */ 
/* 550 */       clazz.addMethod(getCurrentAdvisor);
/*     */ 
/* 552 */       CtField instanceAdvisor = new CtField(forName("org.jboss.aop.InstanceAdvisor"), "instanceAdvisor$aop", clazz);
/*     */ 
/* 556 */       instanceAdvisor.setModifiers(132);
/* 557 */       clazz.addField(instanceAdvisor);
/*     */     }
/*     */ 
/* 561 */     String body = "{    if (instanceAdvisor$aop == null)    {       synchronized(this)       {          if (instanceAdvisor$aop == null)          {             org.jboss.aop.Advisor advisor = ((" + getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ").createInstanceAdvisor(this); " + "            " + "currentAdvisor$aop" + " = advisor; " + "            " + "instanceAdvisor$aop" + " = (org.jboss.aop.InstanceAdvisor)advisor; " + "         } " + "      } " + "   } " + "   return " + "instanceAdvisor$aop" + ";" + "}";
/*     */     try
/*     */     {
/* 579 */       CtMethod getInstanceAdvisor = CtNewMethod.make(forName("org.jboss.aop.InstanceAdvisor"), "_getInstanceAdvisor", new CtClass[0], new CtClass[0], body, clazz);
/*     */ 
/* 586 */       clazz.addMethod(getInstanceAdvisor);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 591 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isBaseClass(CtClass clazz)
/*     */     throws NotFoundException
/*     */   {
/* 598 */     CtClass supa = clazz.getSuperclass();
/* 599 */     if ((supa == null) || (supa.getName().equals("java.lang.Object")))
/*     */     {
/* 601 */       return true;
/*     */     }
/*     */ 
/* 610 */     if (this.classPool.isClassLoadedButNotWoven(supa.getName()))
/*     */     {
/* 612 */       return true;
/*     */     }
/*     */ 
/* 615 */     return !isAdvised(supa);
/*     */   }
/*     */ 
/*     */   public static String updatedAdvicesName(String infoName)
/*     */   {
/* 620 */     return infoName + "_updated";
/*     */   }
/*     */ 
/*     */   private void addInstanceAdvisorWrappers(CtClass clazz)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 628 */     CtClass superClass = clazz;
/* 629 */     CtClass superAdvisor = this.genadvisor;
/* 630 */     boolean isSuper = false;
/*     */ 
/* 632 */     StringBuffer advicesUpdatedCode = new StringBuffer();
/* 633 */     StringBuffer initialiseInfosForInstanceCode = new StringBuffer();
/*     */     while (true)
/*     */     {
/* 637 */       CtField[] fields = superAdvisor.getDeclaredFields();
/*     */ 
/* 639 */       for (int i = 0; i < fields.length; i++)
/*     */       {
/* 641 */         if (Modifier.isStatic(fields[i].getModifiers()))
/*     */           continue;
/* 643 */         GeneratedAdvisorNameExtractor names = GeneratedAdvisorNameExtractor.access$000(superAdvisor, fields[i]);
/* 644 */         if (names == null) {
/*     */           continue;
/*     */         }
/* 647 */         String infoName = fields[i].getName();
/* 648 */         String updatedJoinpointAdvicesName = addAdvicesUpdatedForJoinpointField(infoName);
/* 649 */         advicesUpdatedCode.append(updatedJoinpointAdvicesName + " = true;");
/* 650 */         addWrapperDelegatorMethodToInstanceAdvisor(names, updatedJoinpointAdvicesName);
/*     */ 
/* 653 */         String infoClassName = fields[i].getType().getName();
/* 654 */         if ((!infoClassName.equals(FieldInfo.class.getName())) && (!infoClassName.equals(MethodInfo.class.getName())) && (!infoClassName.equals(ConByConInfo.class.getName())) && (!infoClassName.equals(MethodByConInfo.class.getName())) && (!infoClassName.equals(ConByMethodInfo.class.getName())) && (!infoClassName.equals(MethodByMethodInfo.class.getName())))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 662 */         String code = infoName + " = super.copyInfoFromClassAdvisor(((" + this.genadvisor.getName() + ")" + clazz.getName() + "." + "_getClassAdvisor" + "())." + infoName + ");";
/* 663 */         initialiseInfosForInstanceCode.append(code);
/*     */       }
/*     */ 
/* 667 */       if (isBaseClass(superClass))
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/* 672 */       isSuper = true;
/* 673 */       superClass = superClass.getSuperclass();
/* 674 */       superAdvisor = superAdvisor.getSuperclass();
/*     */     }
/*     */ 
/* 677 */     if (initialiseInfosForInstanceCode.length() > 0)
/*     */     {
/* 679 */       initialiseInfosForInstanceCode.insert(0, this.genadvisor.getName() + " classAdvisor = (" + this.genadvisor.getName() + ")" + clazz.getName() + "." + "_getClassAdvisor" + "();");
/*     */     }
/* 681 */     addCodeToInitialiseMethod(this.genInstanceAdvisor, initialiseInfosForInstanceCode.toString(), "initialiseInfosForInstance");
/*     */ 
/* 683 */     CtMethod advicesUpdated = this.genInstanceAdvisor.getDeclaredMethod("advicesUpdated");
/* 684 */     advicesUpdated.insertAfter(advicesUpdatedCode.toString());
/*     */   }
/*     */ 
/*     */   private String addAdvicesUpdatedForJoinpointField(String infoName) throws NotFoundException, CannotCompileException
/*     */   {
/* 689 */     String updatedAdvicesName = updatedAdvicesName(infoName);
/*     */     try
/*     */     {
/* 692 */       this.genInstanceAdvisor.getDeclaredField(updatedAdvicesName);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 697 */       CtField updatedAdvice = new CtField(CtClass.booleanType, updatedAdvicesName, this.genInstanceAdvisor);
/* 698 */       updatedAdvice.setModifiers(4);
/* 699 */       this.genInstanceAdvisor.addField(updatedAdvice);
/*     */     }
/*     */ 
/* 702 */     return updatedAdvicesName;
/*     */   }
/*     */ 
/*     */   private void addWrapperDelegatorMethodToInstanceAdvisor(GeneratedAdvisorNameExtractor names, String updatedAdvicesFieldName) throws NotFoundException, CannotCompileException
/*     */   {
/*     */     try
/*     */     {
/* 709 */       this.genInstanceAdvisor.getDeclaredMethod(names.getWrapper().getName());
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 714 */       CtMethod instanceAdvisorMethod = CtNewMethod.delegator(names.getWrapper(), this.genInstanceAdvisor);
/* 715 */       String code = "checkVersion();if (" + updatedAdvicesFieldName + ")" + "{ " + "   " + JoinPointInfo.class.getName() + " copy = " + names.getInfoFieldName() + ".copy();" + "   copy.setInterceptors( " + "instanceAdvisorMixin" + ".getWrappers(copy.getInterceptors()) );" + "   " + updatedAdvicesFieldName + " = false;" + "   " + names.getJoinPointField().getName() + " = null;" + "   super.rebindJoinPointWithInstanceInformation(copy);" + "}";
/*     */ 
/* 726 */       instanceAdvisorMethod.insertBefore(code);
/* 727 */       this.genInstanceAdvisor.addMethod(instanceAdvisorMethod);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initaliseMethodInfo(String infoName, long hash, long unadvisedHash)
/*     */     throws NotFoundException
/*     */   {
/* 734 */     String code = infoName + " = new " + "org.jboss.aop.MethodInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + hash + "L, " + unadvisedHash + "L, this);" + "addMethodInfo" + "(" + infoName + ");";
/*     */ 
/* 741 */     addCodeToInitialiseMethod(this.genadvisor, code, "initialiseMethods");
/*     */   }
/*     */ 
/*     */   protected void initialiseFieldReadInfoField(String infoName, int index, String fieldName, long wrapperHash)
/*     */     throws NotFoundException
/*     */   {
/* 747 */     String code = infoName + " = new " + "org.jboss.aop.FieldInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + "\"" + fieldName + "\", " + wrapperHash + "L, this, true);" + "addFieldReadInfo" + "(" + infoName + ");";
/*     */ 
/* 755 */     addCodeToInitialiseMethod(this.genadvisor, code, "initialiseFieldReads");
/*     */   }
/*     */ 
/*     */   protected void initialiseFieldWriteInfoField(String infoName, int index, String fieldName, long wrapperHash)
/*     */     throws NotFoundException
/*     */   {
/* 761 */     String code = infoName + " = new " + "org.jboss.aop.FieldInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + "\"" + fieldName + "\", " + wrapperHash + "L, this, false);" + "addFieldWriteInfo" + "(" + infoName + ");";
/*     */ 
/* 769 */     addCodeToInitialiseMethod(this.genadvisor, code, "initialiseFieldWrites");
/*     */   }
/*     */ 
/*     */   protected void initialiseConstructorInfoField(String infoName, int index, long constructorHash, long wrapperHash)
/*     */     throws NotFoundException
/*     */   {
/* 775 */     String code = infoName + " = new " + "org.jboss.aop.ConstructorInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + wrapperHash + "L, " + constructorHash + "L, this);" + "addConstructorInfo" + "(" + infoName + ");";
/*     */ 
/* 783 */     addCodeToInitialiseMethod(this.genadvisor, code, "initialiseConstructors");
/*     */   }
/*     */ 
/*     */   protected void initialiseConstructionInfoField(String infoName, int index, long constructorHash)
/*     */     throws NotFoundException
/*     */   {
/* 789 */     String code = infoName + " = new " + "org.jboss.aop.ConstructionInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + constructorHash + "L, this);" + "addConstructionInfo" + "(" + infoName + ");";
/*     */ 
/* 796 */     addCodeToInitialiseMethod(this.genadvisor, code, "initialiseConstructions");
/*     */   }
/*     */ 
/*     */   protected void initialiseCallerInfoField(String infoName, String init)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 802 */     addCodeToInitialiseMethod(this.genadvisor, infoName + " = " + init + ";", "initialiseCallers");
/*     */   }
/*     */ 
/*     */   private void addCodeToInitialiseMethod(CtClass clazz, String code, String methodName)
/*     */     throws NotFoundException
/*     */   {
/* 808 */     CtMethod method = clazz.getDeclaredMethod(methodName);
/*     */     try
/*     */     {
/* 811 */       method.insertAfter(code);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 815 */       e.printStackTrace();
/* 816 */       throw new RuntimeException("code was: " + code + " for method " + method.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GeneratedAdvisorNameExtractor {
/*     */     String infoName;
/*     */     CtMethod wrapper;
/*     */     CtField joinPointField;
/*     */ 
/*     */     private GeneratedAdvisorNameExtractor(String infoName, CtMethod wrapper, CtField joinPointField) {
/* 829 */       this.infoName = infoName;
/* 830 */       this.wrapper = wrapper;
/* 831 */       this.joinPointField = joinPointField;
/*     */     }
/*     */ 
/*     */     private static GeneratedAdvisorNameExtractor extractNames(CtClass genadvisor, CtField infoField) throws NotFoundException
/*     */     {
/* 836 */       String infoName = infoField.getName();
/*     */ 
/* 838 */       if (infoField.getType().getName().equals(FieldInfo.class.getName()))
/*     */       {
/* 840 */         boolean isWrite = infoName.startsWith("aop$FieldInfo_w_");
/* 841 */         if ((!isWrite) && (!infoName.startsWith("aop$FieldInfo_r_")))
/*     */         {
/* 843 */           throw new RuntimeException("Bad FieldInfo name: '" + infoName + "'");
/*     */         }
/* 845 */         String fieldName = infoName.substring("aop$FieldInfo_w_".length());
/*     */ 
/* 847 */         String wrapperName = isWrite ? GeneratedAdvisorFieldAccessTransformer.advisorFieldWrite(genadvisor, fieldName) : GeneratedAdvisorFieldAccessTransformer.advisorFieldRead(genadvisor, fieldName);
/*     */ 
/* 851 */         CtMethod wrapper = genadvisor.getDeclaredMethod(wrapperName);
/*     */ 
/* 853 */         String joinPointName = "joinpoint_r_" + fieldName;
/*     */ 
/* 856 */         CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
/*     */ 
/* 858 */         return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
/*     */       }
/* 860 */       if (infoField.getType().getName().equals(MethodInfo.class.getName()))
/*     */       {
/* 862 */         if (!infoName.startsWith("aop$MethodInfo_"))
/*     */         {
/* 864 */           throw new RuntimeException("Bad MethodInfo name: '" + infoName + "'");
/*     */         }
/* 866 */         String methodNameHash = infoName.substring("aop$MethodInfo_".length());
/* 867 */         CtMethod wrapper = genadvisor.getDeclaredMethod(methodNameHash);
/*     */ 
/* 869 */         String joinPointName = "joinpoint_" + methodNameHash;
/* 870 */         CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
/*     */ 
/* 872 */         return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
/*     */       }
/* 874 */       if (infoField.getType().getName().equals(ConByMethodInfo.class.getName()))
/*     */       {
/* 876 */         if (!infoName.startsWith("aop$constructorCall_"))
/*     */         {
/* 878 */           throw new RuntimeException("Bad ConByMethodInfo name: '" + infoName + "'");
/*     */         }
/*     */ 
/* 881 */         CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
/*     */ 
/* 883 */         String joinPointName = "joinpoint_CByM_" + infoName.substring("aop$constructorCall_".length());
/* 884 */         CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
/*     */ 
/* 886 */         return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
/*     */       }
/* 888 */       if (infoField.getType().getName().equals(MethodByMethodInfo.class.getName()))
/*     */       {
/* 890 */         if (!infoName.startsWith("aop$methodCall_"))
/*     */         {
/* 892 */           throw new RuntimeException("Bad MethodByMethodInfo name: '" + infoName + "'");
/*     */         }
/*     */ 
/* 895 */         CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
/*     */ 
/* 897 */         String joinPointName = "joinpoint_MByM_" + infoName.substring("aop$methodCall_".length());
/* 898 */         CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
/*     */ 
/* 900 */         return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
/*     */       }
/* 902 */       if (infoField.getType().getName().equals(ConByConInfo.class.getName()))
/*     */       {
/* 904 */         if (!infoName.startsWith("aop$constructorCall_con_"))
/*     */         {
/* 906 */           throw new RuntimeException("Bad ConByConInfo name: '" + infoName + "'");
/*     */         }
/*     */ 
/* 909 */         CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
/*     */ 
/* 911 */         String joinPointName = "joinpoint_CByC_" + infoName.substring("aop$constructorCall_con_".length());
/* 912 */         CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
/*     */ 
/* 914 */         return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
/*     */       }
/* 916 */       if (infoField.getType().getName().equals(MethodByConInfo.class.getName()))
/*     */       {
/* 918 */         if (!infoName.startsWith("aop$methodCall_con"))
/*     */         {
/* 920 */           throw new RuntimeException("Bad MethodByConInfo name: '" + infoName + "'");
/*     */         }
/*     */ 
/* 923 */         CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
/*     */ 
/* 925 */         String joinPointName = "joinpoint_MByC_" + infoName.substring("aop$methodCall_con_".length());
/* 926 */         CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
/*     */ 
/* 928 */         return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
/*     */       }
/*     */ 
/* 931 */       return null;
/*     */     }
/*     */ 
/*     */     public CtField getJoinPointField()
/*     */     {
/* 936 */       return this.joinPointField;
/*     */     }
/*     */ 
/*     */     public CtMethod getWrapper()
/*     */     {
/* 941 */       return this.wrapper;
/*     */     }
/*     */ 
/*     */     public String getInfoFieldName()
/*     */     {
/* 946 */       return this.infoName;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.GeneratedAdvisorInstrumentor
 * JD-Core Version:    0.6.0
 */