/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.FieldAccess;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ 
/*     */ public class GeneratedAdvisorFieldAccessTransformer extends FieldAccessTransformer
/*     */ {
/* 428 */   private ArrayList pendingFieldWriteInfos = new ArrayList();
/* 429 */   private ArrayList pendingFieldReadInfos = new ArrayList();
/*     */ 
/*     */   public GeneratedAdvisorFieldAccessTransformer(Instrumentor instrumentor)
/*     */   {
/*  47 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected void doBuildFieldWrappers(CtClass clazz, CtField field, int index, boolean shouldReplaceArrayAccess, JoinpointClassification classificationGet, JoinpointClassification classificationSet) throws NotFoundException, CannotCompileException
/*     */   {
/*  52 */     this.instrumentor.setupBasics(clazz);
/*  53 */     boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
/*  54 */     boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
/*  55 */     int mod = field.getModifiers();
/*     */ 
/*  62 */     buildWrapperPlaceHolders(clazz, field, isPrepared(classificationGet), isPrepared(classificationSet), mod);
/*     */     try
/*     */     {
/*  70 */       if (isPrepared(classificationGet))
/*     */       {
/*  72 */         addFieldReadInfoFieldToGeneratedAdvisor(field, index);
/*     */ 
/*  74 */         wrapper.prepareForWrapping(field, 0);
/*     */       }
/*     */ 
/*  77 */       if (isPrepared(classificationSet))
/*     */       {
/*  79 */         addFieldWriteInfoFieldToGeneratedAdvisor(field, index);
/*     */ 
/*  81 */         wrapper.prepareForWrapping(field, 1);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  86 */       throw new CannotCompileException(e);
/*     */     }
/*     */ 
/*  90 */     if (wrappedGet)
/*     */     {
/*  92 */       wrapper.wrap(field, 0);
/*  93 */       if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED))
/*     */       {
/*  95 */         this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
/*     */       }
/*     */     }
/*  98 */     if (wrappedSet)
/*     */     {
/* 100 */       wrapper.wrap(field, 1);
/* 101 */       if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED))
/*     */       {
/* 103 */         this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 108 */     replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, index);
/* 109 */     buildWrappers(clazz, field, shouldReplaceArrayAccess, wrappedGet, wrappedSet, index);
/*     */   }
/*     */ 
/*     */   protected String addFieldReadInfoFieldToGeneratedAdvisor(CtField field, int index) throws NotFoundException, CannotCompileException
/*     */   {
/* 114 */     CtClass genadvisor = getGenadvisor();
/* 115 */     String finame = addFieldReadInfoFieldWithAccessors(4, genadvisor, field);
/*     */ 
/* 120 */     addReadJoinPoint(field, finame, index);
/*     */ 
/* 122 */     long wrapperHash = JavassistMethodHashing.methodHash(field.getDeclaringClass().getDeclaredMethod(fieldRead(field.getName())));
/*     */ 
/* 124 */     ((GeneratedAdvisorInstrumentor)this.instrumentor).initialiseFieldReadInfoField(finame, index, field.getName(), wrapperHash);
/* 125 */     return finame;
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/* 130 */     return false;
/*     */   }
/*     */ 
/*     */   private void addReadJoinPoint(CtField field, String finame, int index) throws CannotCompileException, NotFoundException
/*     */   {
/* 135 */     CtClass joinpoint = createReadJoinPointClass(field, finame, index);
/* 136 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
/* 137 */     CtField jpfield = new CtField(joinpoint, FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), true), genadvisor);
/*     */ 
/* 141 */     jpfield.setModifiers(4);
/* 142 */     genadvisor.addField(jpfield);
/*     */   }
/*     */ 
/*     */   private CtClass createReadJoinPointClass(CtField field, String finame, int index) throws CannotCompileException, NotFoundException
/*     */   {
/* 147 */     return FieldJoinPointGenerator.createReadJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.instrumentor, field.getDeclaringClass(), field, finame, index);
/*     */   }
/*     */ 
/*     */   protected String addFieldWriteInfoFieldToGeneratedAdvisor(CtField field, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 156 */     CtClass genadvisor = getGenadvisor();
/*     */ 
/* 158 */     String finame = addFieldWriteInfoField(4, genadvisor, field);
/*     */ 
/* 163 */     addWriteJoinPoint(field, finame, index);
/*     */ 
/* 165 */     long wrapperHash = JavassistMethodHashing.methodHash(field.getDeclaringClass().getDeclaredMethod(fieldWrite(field.getName())));
/*     */ 
/* 167 */     ((GeneratedAdvisorInstrumentor)this.instrumentor).initialiseFieldWriteInfoField(finame, index, field.getName(), wrapperHash);
/*     */ 
/* 169 */     return finame;
/*     */   }
/*     */ 
/*     */   private void addWriteJoinPoint(CtField field, String finame, int index) throws CannotCompileException, NotFoundException
/*     */   {
/* 174 */     CtClass joinpoint = createWriteJoinPointClass(field, finame, index);
/* 175 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
/* 176 */     CtField jpfield = new CtField(joinpoint, FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), false), genadvisor);
/*     */ 
/* 180 */     jpfield.setModifiers(4);
/* 181 */     genadvisor.addField(jpfield);
/*     */   }
/*     */ 
/*     */   private CtClass createWriteJoinPointClass(CtField field, String finame, int index) throws CannotCompileException, NotFoundException
/*     */   {
/* 186 */     return FieldJoinPointGenerator.createWriteJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.instrumentor, field.getDeclaringClass(), field, finame, index);
/*     */   }
/*     */ 
/*     */   protected void buildWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 196 */     super.buildWrapperPlaceHolders(clazz, field, doGet, doSet, getStaticModifiers(field));
/*     */ 
/* 198 */     CtClass genadvisor = getGenadvisor();
/*     */     CtMethod rmethod;
/* 199 */     if (doGet)
/*     */     {
/* 201 */       rmethod = super.buildReadWrapperPlaceHolder(genadvisor, field, advisorFieldRead(genadvisor, field.getName()), 4);
/*     */     }
/*     */     CtMethod wmethod;
/* 208 */     if (doSet)
/*     */     {
/* 210 */       wmethod = super.buildWriteWrapperPlaceHolder(genadvisor, field, advisorFieldWrite(genadvisor, field.getName()), 4);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String advisorFieldRead(CtClass genadvisor, String fieldName)
/*     */   {
/* 221 */     return genadvisor.getSimpleName() + "$" + fieldRead(fieldName);
/*     */   }
/*     */ 
/*     */   public static String advisorFieldWrite(CtClass genadvisor, String fieldName)
/*     */   {
/* 226 */     return genadvisor.getSimpleName() + "$" + fieldWrite(fieldName);
/*     */   }
/*     */ 
/*     */   protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int fieldIndex) throws NotFoundException, CannotCompileException
/*     */   {
/* 231 */     if (get)
/*     */     {
/* 233 */       return getMainReadWrapperBody(clazz, field, fieldIndex);
/*     */     }
/* 235 */     return getMainWriteWrapperBody(clazz, field, fieldIndex);
/*     */   }
/*     */ 
/*     */   protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException
/*     */   {
/* 240 */     GeneratedAdvisorFieldAccessExprEditor expr = new GeneratedAdvisorFieldAccessExprEditor(clazz, field, doGet, doSet, index);
/* 241 */     clazz.instrument(expr);
/*     */   }
/*     */ 
/*     */   private CtClass getGenadvisor()
/*     */   {
/* 246 */     return ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
/*     */   }
/*     */ 
/*     */   private CtClass getGenInstanceAdvisor()
/*     */   {
/* 251 */     return ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenInstanceadvisor();
/*     */   }
/*     */ 
/*     */   private String getAdvisorReadWrapperBody(CtClass clazz, CtField field, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 257 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/* 258 */     String code = null;
/* 259 */     String joinpointName = FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), true);
/* 260 */     String infoName = getFieldReadInfoFieldName(field.getName());
/* 261 */     if (isStatic)
/*     */     {
/* 263 */       code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "       return " + clazz.getName() + "." + field.getName() + ";" + "   }" + "   else" + "   {" + "    " + MethodExecutionTransformer.getAopReturnStr(false) + joinpointName + "." + "invokeJoinpoint" + "();" + "   }" + "}";
/*     */     }
/*     */     else
/*     */     {
/* 281 */       code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "       return ((" + clazz.getName() + ")$1)." + field.getName() + ";" + "   }" + "   else" + "   {" + "    " + MethodExecutionTransformer.getAopReturnStr(false) + joinpointName + "." + "invokeJoinpoint" + "((" + clazz.getName() + ")$1);" + "   }" + "}";
/*     */     }
/*     */ 
/* 298 */     return code;
/*     */   }
/*     */ 
/*     */   private String getAdvisorWriteWrapperBody(CtClass clazz, CtField field, int index, boolean shouldReplaceArrayAccess)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 304 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/* 305 */     String code = null;
/* 306 */     String joinpointName = FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), false);
/* 307 */     String infoName = getFieldWriteInfoFieldName(field.getName());
/* 308 */     if (isStatic)
/*     */     {
/* 310 */       String targetString = "java.lang.Class.forName(\"" + clazz.getName() + "\")";
/* 311 */       String fieldString = clazz.getName() + "." + field.getName();
/* 312 */       code = "{    " + getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "   " + fieldString + " = $2;" + "   }" + "   else" + "   {" + "   " + joinpointName + "." + "invokeJoinpoint" + "($2);" + "   }" + "}";
/*     */     }
/*     */     else
/*     */     {
/* 331 */       String targetString = "((" + clazz.getName() + ")$1)";
/* 332 */       String fieldString = targetString + "." + field.getName();
/* 333 */       code = "{    " + getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "       " + fieldString + " = $2;" + "   }" + "   else" + "   {" + "   " + MethodExecutionTransformer.getAopReturnStr(false) + joinpointName + "." + "invokeJoinpoint" + "((" + clazz.getName() + ")$1, $2);" + "   }" + "}";
/*     */     }
/*     */ 
/* 351 */     return code;
/*     */   }
/*     */ 
/*     */   private String getMainReadWrapperBody(CtClass clazz, CtField field, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 359 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/*     */ 
/* 361 */     String advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")((" + clazz.getName() + ")$1)." + "getCurrentAdvisor$aop()" + ")";
/*     */ 
/* 365 */     return "return " + advisor + "." + advisorFieldRead(getGenadvisor(), field.getName()) + "($$);";
/*     */   }
/*     */ 
/*     */   private String getMainWriteWrapperBody(CtClass clazz, CtField field, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 372 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/*     */ 
/* 375 */     String advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")((" + clazz.getName() + ")$1)." + "getCurrentAdvisor$aop()" + ")";
/*     */ 
/* 379 */     return advisor + "." + advisorFieldWrite(getGenadvisor(), field.getName()) + "($$);";
/*     */   }
/*     */ 
/*     */   private void buildWrappers(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, boolean doGet, boolean doSet, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 386 */     if (doGet)
/*     */     {
/* 389 */       String code = getAdvisorReadWrapperBody(clazz, field, index);
/* 390 */       CtMethod method = getGenadvisor().getDeclaredMethod(advisorFieldRead(getGenadvisor(), field.getName()));
/*     */       try
/*     */       {
/* 393 */         method.setBody(code);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 397 */         throw new RuntimeException("Field " + field + " code: " + code + " in Method " + method, e);
/*     */       }
/*     */ 
/* 401 */       String mcode = getMainReadWrapperBody(clazz, field, index);
/* 402 */       CtMethod mmethod = clazz.getDeclaredMethod(fieldRead(field.getName()));
/*     */ 
/* 404 */       mmethod.setBody(mcode);
/*     */     }
/* 406 */     if (doSet)
/*     */     {
/* 409 */       String code = getAdvisorWriteWrapperBody(clazz, field, index, shouldReplaceArrayAccess);
/* 410 */       CtMethod method = getGenadvisor().getDeclaredMethod(advisorFieldWrite(getGenadvisor(), field.getName()));
/*     */       try
/*     */       {
/* 413 */         method.setBody(code);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 417 */         throw new RuntimeException("Field " + field + " code: " + code + " in Method " + method, e);
/*     */       }
/*     */ 
/* 421 */       String mcode = getMainWriteWrapperBody(clazz, field, index);
/* 422 */       CtMethod mmethod = clazz.getDeclaredMethod(fieldWrite(field.getName()));
/*     */ 
/* 424 */       mmethod.setBody(mcode);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class GeneratedAdvisorFieldAccessExprEditor extends FieldAccessTransformer.FieldAccessExprEditor
/*     */   {
/*     */     public GeneratedAdvisorFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index)
/*     */     {
/* 454 */       super(clazz, field, doGet, doSet, index);
/*     */     }
/*     */ 
/*     */     protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 459 */       if (fieldAccess.isStatic())
/*     */       {
/* 461 */         String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
/*     */ 
/* 466 */         fieldAccess.replace(code);
/*     */       }
/*     */       else
/*     */       {
/* 470 */         String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
/*     */ 
/* 475 */         fieldAccess.replace(code);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 481 */       String fieldWrite = FieldAccessTransformer.fieldWrite(this.field.getName());
/* 482 */       if (fieldAccess.isStatic())
/*     */       {
/* 484 */         String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
/*     */ 
/* 489 */         fieldAccess.replace(code);
/*     */       }
/*     */       else
/*     */       {
/* 493 */         String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
/*     */ 
/* 498 */         fieldAccess.replace(code);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private class PendingFieldInfo
/*     */   {
/*     */     CtField field;
/*     */     int index;
/*     */ 
/*     */     public PendingFieldInfo(CtField field, int index)
/*     */     {
/* 437 */       this.field = field;
/* 438 */       this.index = index;
/*     */     }
/*     */ 
/*     */     public CtField getField() {
/* 442 */       return this.field;
/*     */     }
/*     */ 
/*     */     public int getIndex() {
/* 446 */       return this.index;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.GeneratedAdvisorFieldAccessTransformer
 * JD-Core Version:    0.6.0
 */