/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.lang.reflect.Type;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.FieldInfo;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.FieldAccess;
/*     */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.util.JavassistToReflect;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class FieldJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*     */   public static final String WRITE_JOINPOINT_FIELD_PREFIX = "joinpoint_w_";
/*     */   public static final String READ_JOINPOINT_FIELD_PREFIX = "joinpoint_r_";
/*     */   public static final String WRITE_JOINPOINT_CLASS_PREFIX = "JoinPoint_w_";
/*     */   public static final String READ_JOINPOINT_CLASS_PREFIX = "JoinPoint_r_";
/*  60 */   private static final Class JOINPOINT_TYPE = FieldAccess.class;
/*  61 */   private static final Class READ_INVOCATION_TYPE = FieldReadInvocation.class;
/*  62 */   private static final Class WRITE_INVOCATION_TYPE = FieldWriteInvocation.class;
/*     */   private static final CtClass READ_INVOCATION_CT_TYPE;
/*     */   private static final CtClass WRITE_INVOCATION_CT_TYPE;
/*     */   private static final String TYPED_VALUE_FIELD = "typedValue";
/*     */   WeakReference<Class<?>> returnClassType;
/*     */   WeakReference<Type> returnType;
/*     */   boolean read;
/*     */   boolean hasTargetObject;
/*     */ 
/*     */   public FieldJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info)
/*     */   {
/*  86 */     super(advisor, info, getParameters((FieldInfo)info), ((FieldInfo)info).isRead() ? 0 : 1, ((FieldInfo)info).isRead());
/*     */ 
/*  89 */     if (((FieldInfo)info).isRead())
/*     */     {
/*  91 */       this.read = true;
/*  92 */       this.returnClassType = new WeakReference(((FieldInfo)info).getField().getType());
/*  93 */       this.returnType = new WeakReference(((FieldInfo)info).getField().getGenericType());
/*     */     }
/*  95 */     this.hasTargetObject = (!Modifier.isStatic(((FieldInfo)info).getField().getModifiers()));
/*     */   }
/*     */ 
/*     */   private static JoinPointGenerator.JoinPointParameters getParameters(FieldInfo info)
/*     */   {
/* 100 */     if (Modifier.isStatic(info.getField().getModifiers()))
/*     */     {
/* 102 */       return JoinPointGenerator.JoinPointParameters.ONLY_ARGS;
/*     */     }
/* 104 */     return JoinPointGenerator.JoinPointParameters.TARGET_ARGS;
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/* 109 */     FieldInfo finfo = (FieldInfo)info;
/* 110 */     this.joinpointClassName = getGeneratedJoinPointClassName(fieldName(finfo), finfo.isRead());
/*     */ 
/* 113 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(fieldName(finfo), finfo.isRead());
/*     */   }
/*     */ 
/*     */   protected String getJoinPointArg(int index)
/*     */   {
/* 125 */     return "this.typedValue";
/*     */   }
/*     */ 
/*     */   private String fieldName(FieldInfo info)
/*     */   {
/* 130 */     return info.getField().getName();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 135 */     return !this.read;
/*     */   }
/*     */ 
/*     */   protected Class<?> getReturnClassType()
/*     */   {
/* 140 */     if (this.returnClassType != null)
/*     */     {
/* 142 */       return (Class)this.returnClassType.get();
/*     */     }
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 149 */     FieldAccess fieldAccess = (FieldAccess)joinPoint;
/* 150 */     Field field = fieldAccess.getField();
/* 151 */     return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, fieldAccess.isRead() ? READ_INVOCATION_TYPE : WRITE_INVOCATION_TYPE, fieldAccess.isRead() ? field.getGenericType() : Void.TYPE, new Type[] { fieldAccess.isRead() ? new Type[0] : field.getGenericType() }, new Class[] { fieldAccess.isRead() ? new Class[0] : field.getType() }, null, field.getDeclaringClass(), hasTargetObject());
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 175 */     return this.hasTargetObject;
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(String fieldName, boolean read)
/*     */   {
/* 180 */     if (read)
/*     */     {
/* 182 */       return "joinpoint_r_" + fieldName;
/*     */     }
/*     */ 
/* 186 */     return "joinpoint_w_" + fieldName;
/*     */   }
/*     */ 
/*     */   private static String getGeneratedJoinPointClassName(String fieldName, boolean read)
/*     */   {
/* 192 */     if (read)
/*     */     {
/* 194 */       return "JoinPoint_r_" + fieldName;
/*     */     }
/*     */ 
/* 198 */     return "JoinPoint_w_" + fieldName;
/*     */   }
/*     */ 
/*     */   protected static CtClass createReadJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 209 */     BaseClassGenerator factory = new ReadBaseClassGenerator(instrumentor, advisedClass, advisedField, finame, index);
/* 210 */     return factory.generate();
/*     */   }
/*     */ 
/*     */   protected static CtClass createWriteJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 220 */     BaseClassGenerator factory = new WriteBaseClassGenerator(instrumentor, advisedClass, advisedField, finame, index);
/* 221 */     return factory.generate();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  70 */       READ_INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(READ_INVOCATION_TYPE);
/*  71 */       WRITE_INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(WRITE_INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  75 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class WriteBaseClassGenerator extends FieldJoinPointGenerator.BaseClassGenerator
/*     */   {
/*     */     private static final String GET_VALUE = "getValue";
/*     */     private static final String SET_VALUE = "setValue";
/*     */ 
/*     */     WriteBaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index)
/*     */       throws NotFoundException
/*     */     {
/* 574 */       super(advisedClass, advisedField, finame, index, false);
/*     */     }
/*     */ 
/*     */     protected CtClass setupClass() throws NotFoundException, CannotCompileException
/*     */     {
/* 579 */       CtClass setUp = super.setupClass();
/* 580 */       CtField valueField = new CtField(getArgumentType(), "typedValue", setUp);
/* 581 */       this.jp.addField(valueField);
/* 582 */       CtMethod oldGetValue = FieldJoinPointGenerator.WRITE_INVOCATION_CT_TYPE.getDeclaredMethod("getValue");
/* 583 */       CtMethod getValue = CtNewMethod.make(oldGetValue.getReturnType(), "getValue", oldGetValue.getParameterTypes(), oldGetValue.getExceptionTypes(), "{return ($w)typedValue;}", setUp);
/*     */ 
/* 587 */       setUp.addMethod(getValue);
/* 588 */       CtMethod oldSetValue = FieldJoinPointGenerator.WRITE_INVOCATION_CT_TYPE.getDeclaredMethod("setValue");
/* 589 */       CtMethod setValue = CtNewMethod.make(oldSetValue.getReturnType(), "getValue", oldSetValue.getParameterTypes(), oldSetValue.getExceptionTypes(), "{typedValue = " + JavassistToReflect.castInvocationValueToTypeString(getArgumentType(), "$1") + ";}", setUp);
/*     */ 
/* 594 */       setUp.addMethod(setValue);
/* 595 */       return setUp;
/*     */     }
/*     */ 
/*     */     protected CtClass getSuperClass() throws NotFoundException
/*     */     {
/* 600 */       return FieldJoinPointGenerator.WRITE_INVOCATION_CT_TYPE;
/*     */     }
/*     */ 
/*     */     protected CtClass getArgumentType() throws NotFoundException
/*     */     {
/* 605 */       return this.advisedField.getType();
/*     */     }
/*     */ 
/*     */     protected String createSetValue()
/*     */     {
/* 610 */       if (this.hasTargetObject)
/*     */       {
/* 612 */         return "typedValue = $3;";
/*     */       }
/* 614 */       return "typedValue = $2;";
/*     */     }
/*     */ 
/*     */     protected CtClass[] getInvokeJoinPointParams() throws NotFoundException
/*     */     {
/* 619 */       return new CtClass[] { this.hasTargetObject ? new CtClass[] { this.advisedClass, this.advisedField.getType() } : this.advisedField.getType() };
/*     */     }
/*     */ 
/*     */     protected CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 624 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(CtClass.voidType, "invokeJoinpoint", getInvokeJoinPointParams(), JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 631 */       invokeJoinpointMethod.setModifiers(4);
/* 632 */       this.jp.addMethod(invokeJoinpointMethod);
/*     */ 
/* 634 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     protected String createInvokeNextDispatchMethodBody() throws NotFoundException
/*     */     {
/* 639 */       return "{" + (this.hasTargetObject ? "typedTargetObject." + this.advisedField.getName() + " = " + "typedValue" : new StringBuilder().append(this.advisedClass.getName()).append(".").append(this.advisedField.getName()).append(" = ").append("typedValue").toString()) + (this.hasTargetObject ? "; return typedTargetObject." + this.advisedField.getName() + ";" : new StringBuilder().append("; return ").append(this.advisedClass.getName()).append(".").append(this.advisedField.getName()).append(";").toString()) + "}";
/*     */     }
/*     */ 
/*     */     protected String createInvokeJoinPointDispatchMethodBody()
/*     */     {
/* 653 */       return "{" + this.advisedClass.getName() + "." + this.advisedField.getName() + " = $1;}";
/*     */     }
/*     */ 
/*     */     protected void addArgumentFieldAndAccessor()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 661 */       CtField inconsistentArgs = new CtField(CtClass.booleanType, "inconsistentArgs", this.jp);
/*     */ 
/* 663 */       this.jp.addField(inconsistentArgs, CtField.Initializer.byExpr("false"));
/* 664 */       super.addArgumentFieldAndAccessor();
/* 665 */       CtMethod enforceArgsConsistency = CtNewMethod.make(createEnforceArgsConsistencyBody(), this.jp);
/*     */ 
/* 667 */       enforceArgsConsistency.setModifiers(4);
/* 668 */       this.jp.addMethod(enforceArgsConsistency);
/*     */     }
/*     */ 
/*     */     protected String createGetArgumentsBody()
/*     */     {
/* 673 */       StringBuffer code = new StringBuffer("public java.lang.Object[] ");
/* 674 */       code.append("getArguments");
/* 675 */       code.append("(){ inconsistentArgs = true;   ");
/* 676 */       code.append("   if(");
/* 677 */       code.append("arguments");
/* 678 */       code.append("  == null)");
/* 679 */       code.append("   {");
/* 680 */       code.append("      ");
/* 681 */       code.append("arguments");
/* 682 */       code.append(" = new java.lang.Object[]{");
/* 683 */       code.append("getValue");
/* 684 */       code.append("()};");
/* 685 */       code.append("   }");
/* 686 */       code.append("   return ");
/* 687 */       code.append("arguments");
/* 688 */       code.append("; ");
/* 689 */       code.append("}");
/* 690 */       return code.toString();
/*     */     }
/*     */ 
/*     */     protected String createSetArgumentsBody()
/*     */     {
/* 695 */       StringBuffer code = new StringBuffer("public void setArguments(java.lang.Object[] args)");
/*     */ 
/* 697 */       code.append("{   inconsistentArgs = true;   ");
/* 698 */       code.append("if (args == null || args.length != 1)");
/* 699 */       code.append("{throw new RuntimeException(");
/* 700 */       code.append("\"Field write arguments must be a non-null array containing");
/* 701 */       code.append(" a single element: the value of the field write\");}");
/* 702 */       code.append("arguments");
/* 703 */       code.append("=args;");
/* 704 */       code.append("}");
/* 705 */       return code.toString();
/*     */     }
/*     */ 
/*     */     protected String createEnforceArgsConsistencyBody()
/*     */     {
/* 710 */       StringBuffer code = new StringBuffer("public void ");
/* 711 */       code.append("enforceArgsConsistency");
/*     */ 
/* 713 */       code.append("() {if(inconsistentArgs) { this.");
/* 714 */       code.append("setValue").append("(").append("arguments").append("[0]);}}");
/* 715 */       return code.toString();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ReadBaseClassGenerator extends FieldJoinPointGenerator.BaseClassGenerator
/*     */   {
/*     */     ReadBaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index)
/*     */       throws NotFoundException
/*     */     {
/* 489 */       super(advisedClass, advisedField, finame, index, true);
/*     */     }
/*     */ 
/*     */     protected CtClass getSuperClass() throws NotFoundException
/*     */     {
/* 494 */       return FieldJoinPointGenerator.READ_INVOCATION_CT_TYPE;
/*     */     }
/*     */ 
/*     */     protected CtClass getArgumentType()
/*     */     {
/* 499 */       return null;
/*     */     }
/*     */ 
/*     */     protected String createSetValue()
/*     */     {
/* 504 */       return "";
/*     */     }
/*     */ 
/*     */     protected CtClass[] getInvokeJoinPointParams() throws NotFoundException
/*     */     {
/* 509 */       return this.hasTargetObject ? new CtClass[] { this.advisedClass } : new CtClass[0];
/*     */     }
/*     */ 
/*     */     protected CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 514 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(this.advisedField.getType(), "invokeJoinpoint", getInvokeJoinPointParams(), JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 521 */       invokeJoinpointMethod.setModifiers(4);
/* 522 */       this.jp.addMethod(invokeJoinpointMethod);
/*     */ 
/* 524 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     protected String createInvokeNextDispatchMethodBody()
/*     */     {
/* 529 */       return "{return " + this.advisedClass.getName() + "." + this.advisedField.getName() + ";}";
/*     */     }
/*     */ 
/*     */     protected String createInvokeJoinPointDispatchMethodBody()
/*     */     {
/* 536 */       return "{return " + this.advisedClass.getName() + "." + this.advisedField.getName() + ";}";
/*     */     }
/*     */ 
/*     */     protected String createGetArgumentsBody()
/*     */     {
/* 543 */       StringBuffer code = new StringBuffer("public java.lang.Object[] ");
/* 544 */       code.append("getArguments");
/* 545 */       code.append("(){ ");
/* 546 */       code.append("   return ");
/* 547 */       code.append("arguments");
/* 548 */       code.append("; ");
/* 549 */       code.append("}");
/* 550 */       return code.toString();
/*     */     }
/*     */ 
/*     */     protected String createSetArgumentsBody()
/*     */     {
/* 555 */       StringBuffer code = new StringBuffer("public void setArguments(java.lang.Object[] args)");
/*     */ 
/* 557 */       code.append("{   ");
/* 558 */       code.append("if (args != null){ throw new RuntimeException(\"Arguments array of field read must be null\");}");
/* 559 */       code.append("arguments");
/* 560 */       code.append("=args;");
/* 561 */       code.append("}");
/* 562 */       return code.toString();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass advisedClass;
/*     */     CtField advisedField;
/*     */     String finame;
/*     */     boolean hasTargetObject;
/*     */     CtClass jp;
/*     */     CtClass fieldType;
/*     */     CtClass fieldInfoClass;
/*     */     boolean read;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtField advisedField, String finame, int index, boolean read)
/*     */       throws NotFoundException
/*     */     {
/* 241 */       this.instrumentor = instrumentor;
/* 242 */       this.advisedClass = advisedClass;
/* 243 */       this.advisedField = advisedField;
/* 244 */       this.finame = finame;
/* 245 */       this.fieldType = advisedField.getType();
/* 246 */       this.read = read;
/* 247 */       this.fieldInfoClass = instrumentor.forName("org.jboss.aop.FieldInfo");
/* 248 */       this.hasTargetObject = (!Modifier.isStatic(advisedField.getModifiers()));
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 253 */       this.jp = setupClass();
/* 254 */       if (this.hasTargetObject)
/*     */       {
/* 256 */         addTypedTargetField();
/*     */       }
/* 258 */       addArgumentFieldAndAccessor();
/* 259 */       addInvokeJoinpointMethod();
/* 260 */       addFieldInfoField();
/* 261 */       addPublicConstructor();
/* 262 */       addProtectedConstructors();
/* 263 */       addDispatchMethods();
/*     */ 
/* 265 */       TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
/* 266 */       return this.jp;
/*     */     }
/*     */ 
/*     */     protected void addArgumentFieldAndAccessor() throws CannotCompileException, NotFoundException
/*     */     {
/* 271 */       CtField argumentsField = new CtField(this.instrumentor.forName("java.lang.Object[]"), "arguments", this.jp);
/*     */ 
/* 273 */       argumentsField.setModifiers(4);
/* 274 */       this.jp.addField(argumentsField);
/* 275 */       CtMethod getArguments = CtNewMethod.make(createGetArgumentsBody(), this.jp);
/* 276 */       getArguments.setModifiers(1);
/* 277 */       this.jp.addMethod(getArguments);
/* 278 */       CtMethod setArguments = CtNewMethod.make(createSetArgumentsBody(), this.jp);
/* 279 */       setArguments.setModifiers(1);
/* 280 */       this.jp.addMethod(setArguments);
/*     */     }
/*     */     protected abstract String createGetArgumentsBody();
/*     */ 
/*     */     protected abstract String createSetArgumentsBody();
/*     */ 
/* 288 */     private static String debugFields(CtClass clazz) throws NotFoundException { StringBuffer sb = new StringBuffer();
/* 289 */       sb.append(clazz.getName());
/* 290 */       CtField[] fields = clazz.getFields();
/* 291 */       for (int i = 0; i < fields.length; i++)
/*     */       {
/* 293 */         sb.append("\n\t\t\t\t" + Modifier.toString(fields[i].getModifiers()) + " " + fields[i].getName() + " " + fields[i].getType());
/*     */       }
/*     */ 
/* 296 */       return sb.toString(); }
/*     */ 
/*     */     protected CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 301 */       String className = FieldJoinPointGenerator.access$000(this.advisedField.getName(), this.read);
/*     */ 
/* 304 */       CtClass superClass = this.read ? FieldJoinPointGenerator.READ_INVOCATION_CT_TYPE : FieldJoinPointGenerator.WRITE_INVOCATION_CT_TYPE;
/* 305 */       this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true, 9, superClass);
/* 306 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/* 307 */       return this.jp;
/*     */     }
/*     */ 
/*     */     protected abstract CtClass getSuperClass() throws NotFoundException;
/*     */ 
/*     */     private void addTypedTargetField() throws CannotCompileException {
/* 314 */       CtField targetField = new CtField(this.advisedClass, "typedTargetObject", this.jp);
/* 315 */       this.jp.addField(targetField);
/* 316 */       targetField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 326 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.fieldInfoClass }, new CtClass[0], "{super($1, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 332 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 341 */       CtClass[] ctorParams1 = this.hasTargetObject ? new CtClass[2] : new CtClass[1];
/* 342 */       CtClass[] ctorParams2 = this.hasTargetObject ? new CtClass[3] : new CtClass[2];
/*     */       CtClass tmp46_43 = this.jp; ctorParams2[0] = tmp46_43; ctorParams1[0] = tmp46_43;
/* 345 */       if (this.hasTargetObject)
/*     */       {
/*     */         CtClass tmp64_61 = this.advisedClass; ctorParams2[1] = tmp64_61; ctorParams1[1] = tmp64_61;
/* 346 */       }ctorParams2[(ctorParams2.length - 1)] = getArgumentType();
/*     */ 
/* 348 */       StringBuffer body = new StringBuffer();
/* 349 */       body.append("{");
/* 350 */       body.append("   this($1.info);");
/*     */ 
/* 352 */       if (this.hasTargetObject)
/*     */       {
/* 354 */         body.append("   this.typedTargetObject = $2;");
/* 355 */         body.append("   super.setTargetObject($2);");
/*     */       }
/*     */ 
/* 358 */       if (getArgumentType() != null)
/*     */       {
/* 360 */         CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 365 */         protectedConstructor.setModifiers(4);
/* 366 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */       else
/*     */       {
/* 370 */         ctorParams2 = ctorParams1;
/*     */       }
/* 372 */       String setArguments = createSetValue();
/* 373 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + setArguments + "}", this.jp);
/*     */ 
/* 378 */       protectedConstructor.setModifiers(4);
/* 379 */       this.jp.addConstructor(protectedConstructor);
/*     */     }
/*     */ 
/*     */     protected abstract CtClass getArgumentType() throws NotFoundException;
/*     */ 
/*     */     protected abstract String createSetValue();
/*     */ 
/*     */     protected abstract CtClass[] getInvokeJoinPointParams() throws NotFoundException;
/*     */ 
/*     */     protected abstract CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException;
/*     */ 
/*     */     private void addFieldInfoField() throws CannotCompileException
/*     */     {
/* 396 */       CtField infoField = new CtField(this.fieldInfoClass, "info", this.jp);
/* 397 */       infoField.setModifiers(4);
/* 398 */       this.jp.addField(infoField);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 403 */       addInvokeNextDispatchMethod();
/* 404 */       addInvokeJoinPointDispatchMethod();
/* 405 */       addInvokeTargetMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeNextDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 412 */       String body = createInvokeNextDispatchMethodBody();
/*     */       try
/*     */       {
/* 416 */         CtMethod dispatch = CtNewMethod.make(this.read ? this.advisedField.getType() : CtClass.voidType, "dispatch", JoinPointGenerator.EMPTY_CTCLASS_ARRAY, JoinPointGenerator.EMPTY_CTCLASS_ARRAY, body, this.jp);
/*     */ 
/* 423 */         dispatch.setModifiers(4);
/* 424 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 428 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", JoinPointGenerator.EMPTY_CTCLASS_ARRAY), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected abstract String createInvokeNextDispatchMethodBody() throws NotFoundException;
/*     */ 
/*     */     protected void addInvokeJoinPointDispatchMethod() throws NotFoundException, CannotCompileException {
/* 436 */       CtClass[] params = getInvokeJoinPointParams();
/* 437 */       if (params.length == 0)
/*     */       {
/* 439 */         return;
/*     */       }
/*     */ 
/* 444 */       String body = createInvokeJoinPointDispatchMethodBody();
/*     */       try
/*     */       {
/* 448 */         CtMethod dispatch = CtNewMethod.make(this.read ? this.advisedField.getType() : CtClass.voidType, "dispatch", params, new CtClass[0], body, this.jp);
/*     */ 
/* 455 */         dispatch.setModifiers(4);
/* 456 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 460 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", params), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected abstract String createInvokeJoinPointDispatchMethodBody() throws NotFoundException;
/*     */ 
/*     */     private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
/* 468 */       CtMethod template = FieldJoinPointGenerator.READ_INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
/*     */ 
/* 470 */       String body = this.read ? "{return ($w)dispatch();}" : "{dispatch(); return null;}";
/*     */ 
/* 472 */       CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
/*     */ 
/* 479 */       this.jp.addMethod(invokeTarget);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.FieldJoinPointGenerator
 * JD-Core Version:    0.6.0
 */