/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ 
/*     */ public abstract class ConstructionTransformer
/*     */ {
/*     */   static final String CONSTRUCTION_INFO_CLASS_NAME = "org.jboss.aop.ConstructionInfo";
/*     */   protected Instrumentor instrumentor;
/*     */ 
/*     */   protected ConstructionTransformer(Instrumentor instrumentor)
/*     */   {
/*  51 */     this.instrumentor = instrumentor;
/*     */   }
/*     */ 
/*     */   protected String addConstructionInfoField(int modifiers, CtClass addTo, CtConstructor ctor, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  59 */     return addConstructionInfoField(modifiers, addTo, ctor, index, null);
/*     */   }
/*     */ 
/*     */   protected String addConstructionInfoField(int modifiers, CtClass addTo, CtConstructor ctor, int index, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  67 */     String name = getConstructionInfoFieldName(ctor.getDeclaringClass().getSimpleName(), index);
/*     */ 
/*  71 */     if (this.instrumentor.getClassPool() != null)
/*     */     {
/*     */       try
/*     */       {
/*  75 */         addTo.getDeclaredField(name);
/*  76 */         return name;
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/*  81 */         TransformerCommon.addInfoField(this.instrumentor, "org.jboss.aop.ConstructionInfo", name, modifiers, addTo, addInfoAsWeakReference(), init);
/*     */       }
/*     */     }
/*  84 */     return name;
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/*  89 */     return true;
/*     */   }
/*     */ 
/*     */   public static String getConstructionInfoFieldName(String classname, int index)
/*     */   {
/*  94 */     if (classname.indexOf(".") >= 0)
/*     */     {
/*  96 */       throw new RuntimeException("Use simple class name for construction info field name: " + classname);
/*     */     }
/*  98 */     return "aop$constructionInfo_" + classname.replace('.', '$') + "_" + index;
/*     */   }
/*     */ 
/*     */   protected static String constructionInfoFromWeakReference(String localName, String ctorInfoName)
/*     */   {
/* 103 */     return TransformerCommon.infoFromWeakReference("org.jboss.aop.ConstructionInfo", localName, ctorInfoName);
/*     */   }
/*     */ 
/*     */   public boolean insertConstructionInterception(CtClass clazz, ClassAdvisor advisor)
/*     */     throws Exception
/*     */   {
/* 110 */     if (!advisor.getManager().isConstruction()) return false;
/*     */ 
/* 112 */     boolean oneMatch = false;
/* 113 */     List constructors = this.instrumentor.getConstructors(clazz);
/*     */ 
/* 115 */     Iterator it = constructors.iterator();
/* 116 */     for (int index = 0; it.hasNext(); index++)
/*     */     {
/* 119 */       CtConstructor constructor = (CtConstructor)it.next();
/* 120 */       if ((constructor.isClassInitializer()) || (!isAdvisableConstructor(constructor, advisor)))
/*     */       {
/* 122 */         if (!oneMatch) {
/*     */           continue;
/*     */         }
/* 125 */         generateNotMatchedConstructionInfoField(constructor, index);
/*     */       }
/*     */       else
/*     */       {
/* 130 */         if (!oneMatch)
/*     */         {
/* 132 */           oneMatch = true;
/* 133 */           this.instrumentor.setupBasics(clazz);
/*     */ 
/* 135 */           for (int j = 0; j < index; j++)
/*     */           {
/* 137 */             generateNotMatchedConstructionInfoField((CtConstructor)constructors.get(j), j);
/*     */           }
/*     */         }
/*     */ 
/* 141 */         generateConstructionInfoField(constructor, index);
/* 142 */         insertInterception(constructor, index);
/*     */       }
/*     */     }
/* 144 */     return oneMatch;
/*     */   }
/*     */ 
/*     */   protected abstract void insertInterception(CtConstructor paramCtConstructor, int paramInt)
/*     */     throws Exception;
/*     */ 
/*     */   public static boolean isAdvisableConstructor(CtConstructor con, ClassAdvisor advisor) throws NotFoundException
/*     */   {
/* 153 */     Map pointcuts = advisor.getManager().getPointcuts();
/* 154 */     synchronized (pointcuts)
/*     */     {
/* 156 */       Iterator it = pointcuts.values().iterator();
/* 157 */       while (it.hasNext())
/*     */       {
/* 159 */         Pointcut pointcut = (Pointcut)it.next();
/* 160 */         if (pointcut.matchesConstruction(advisor, con))
/*     */         {
/* 162 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   protected void generateConstructionInfoField(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException
/*     */   {
/* 171 */     addConstructionInfoField(10, constructor.getDeclaringClass(), constructor, index);
/*     */   }
/*     */ 
/*     */   protected void generateNotMatchedConstructionInfoField(CtConstructor constructor, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.ConstructionTransformer
 * JD-Core Version:    0.6.0
 */