/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ConstructionInfo;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.Construction;
/*     */ import org.jboss.aop.joinpoint.ConstructionInvocation;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class ConstructionJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*     */   public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_construction_";
/*     */   public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_construction_";
/*  56 */   private static final Class JOINPOINT_TYPE = Construction.class;
/*  57 */   private static final Class INVOCATION_TYPE = ConstructionInvocation.class;
/*     */   private static final CtClass INVOCATION_CT_TYPE;
/*     */ 
/*     */   public ConstructionJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info)
/*     */   {
/*  73 */     super(advisor, info, JoinPointGenerator.JoinPointParameters.TARGET_ARGS, ((ConstructionInfo)info).getConstructor().getParameterTypes().length, false);
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/*  81 */     ConstructionInfo cinfo = (ConstructionInfo)info;
/*  82 */     this.joinpointClassName = getGeneratedJoinPointClassName(classSimpleName(cinfo), index(cinfo));
/*     */ 
/*  86 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(classSimpleName(cinfo), index(cinfo));
/*     */   }
/*     */ 
/*     */   private String classSimpleName(ConstructionInfo info)
/*     */   {
/*  93 */     Constructor ctor = info.getConstructor();
/*  94 */     return Advisor.getSimpleName(ctor.getDeclaringClass());
/*     */   }
/*     */ 
/*     */   private int index(ConstructionInfo info)
/*     */   {
/*  99 */     return info.getIndex();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 104 */     return true;
/*     */   }
/*     */ 
/*     */   protected Class getReturnClassType()
/*     */   {
/* 109 */     return null;
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 114 */     Constructor ctor = ((Construction)joinPoint).getConstructor();
/* 115 */     return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getGenericParameterTypes(), ctor.getParameterTypes(), ctor.getGenericExceptionTypes(), ctor.getDeclaringClass(), true);
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 131 */     return true;
/*     */   }
/*     */ 
/*     */   protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 148 */     BaseClassGenerator generator = new BaseClassGenerator(instrumentor, advisedClass, advisedCtor, ciname, index);
/* 149 */     return generator.generate();
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(String className, int index)
/*     */   {
/* 154 */     return "joinpoint_construction_" + className + "_" + index;
/*     */   }
/*     */ 
/*     */   private static String getGeneratedJoinPointClassName(String className, int index)
/*     */   {
/* 159 */     return "JoinPoint_construction_" + className + "_" + index;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  63 */       INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  67 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass advisedClass;
/*     */     CtConstructor advisedCtor;
/*     */     String ciname;
/*     */     int index;
/*     */     CtClass jp;
/*     */     CtField targetField;
/*     */     CtClass[] originalParams;
/*     */     CtClass[] params;
/*     */     CtClass constructionInfoClass;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index)
/*     */       throws NotFoundException
/*     */     {
/* 183 */       this.instrumentor = instrumentor;
/* 184 */       this.advisedClass = advisedClass;
/* 185 */       this.advisedCtor = advisedCtor;
/* 186 */       this.ciname = ciname;
/* 187 */       this.index = index;
/* 188 */       this.originalParams = advisedCtor.getParameterTypes();
/* 189 */       this.params = new CtClass[this.originalParams.length + 1];
/* 190 */       this.params[0] = advisedClass;
/* 191 */       System.arraycopy(this.originalParams, 0, this.params, 1, this.originalParams.length);
/*     */ 
/* 193 */       this.constructionInfoClass = instrumentor.forName("org.jboss.aop.ConstructionInfo");
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 198 */       this.jp = setupClass();
/* 199 */       OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.originalParams, false);
/*     */ 
/* 201 */       addTypedTargetField();
/* 202 */       addInvokeJoinpointMethod();
/* 203 */       addConstructionInfoField();
/* 204 */       addPublicConstructor();
/* 205 */       addProtectedConstructors();
/* 206 */       addDispatchMethods();
/*     */ 
/* 208 */       TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
/* 209 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 215 */       String className = ConstructionJoinPointGenerator.access$000(this.advisedClass.getSimpleName(), this.index);
/*     */ 
/* 218 */       this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true, 9, ConstructionJoinPointGenerator.INVOCATION_CT_TYPE);
/* 219 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/* 220 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private void addTypedTargetField() throws CannotCompileException
/*     */     {
/* 225 */       this.targetField = new CtField(this.advisedClass, "typedTargetObject", this.jp);
/* 226 */       this.jp.addField(this.targetField);
/* 227 */       this.targetField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 237 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.constructionInfoClass }, new CtClass[0], "{super($1, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 243 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException
/*     */     {
/* 252 */       CtClass[] ctorParams1 = new CtClass[this.params.length + 1];
/* 253 */       CtClass[] ctorParams2 = new CtClass[2];
/*     */       CtClass tmp24_21 = this.jp; ctorParams2[0] = tmp24_21; ctorParams1[0] = tmp24_21;
/* 255 */       System.arraycopy(this.params, 0, ctorParams1, 1, this.params.length);
/* 256 */       ctorParams2[1] = this.params[0];
/*     */ 
/* 258 */       StringBuffer body = new StringBuffer();
/* 259 */       body.append("{");
/* 260 */       body.append("   this($1.info);");
/*     */ 
/* 262 */       int offset = 2;
/* 263 */       body.append("   this." + this.targetField.getName() + " = $2;");
/* 264 */       body.append("   super.setTargetObject($2);");
/*     */ 
/* 266 */       StringBuffer setArguments = new StringBuffer();
/* 267 */       for (int i = offset; i < ctorParams1.length; i++)
/*     */       {
/* 269 */         setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
/*     */       }
/* 271 */       setArguments.append("}");
/*     */ 
/* 273 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
/*     */ 
/* 278 */       protectedConstructor.setModifiers(4);
/* 279 */       this.jp.addConstructor(protectedConstructor);
/* 280 */       if (this.params.length > 1)
/*     */       {
/* 282 */         protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 287 */         protectedConstructor.setModifiers(4);
/* 288 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */     }
/*     */ 
/*     */     private CtMethod addInvokeJoinpointMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 298 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(CtClass.voidType, "invokeJoinpoint", this.params, JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 305 */       invokeJoinpointMethod.setModifiers(4);
/* 306 */       this.jp.addMethod(invokeJoinpointMethod);
/* 307 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     private void addConstructionInfoField() throws CannotCompileException
/*     */     {
/* 312 */       CtField infoField = new CtField(this.constructionInfoClass, "info", this.jp);
/* 313 */       infoField.setModifiers(4);
/* 314 */       this.jp.addField(infoField);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 319 */       addInvokeNextDispatchMethod();
/* 320 */       addInvokeJoinPointDispatchMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeNextDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 327 */       String body = "{ return null;}";
/*     */       try
/*     */       {
/* 331 */         CtMethod dispatch = CtNewMethod.make(CtClass.voidType, "dispatch", JoinPointGenerator.EMPTY_CTCLASS_ARRAY, this.advisedCtor.getExceptionTypes(), body, this.jp);
/*     */ 
/* 338 */         dispatch.setModifiers(4);
/* 339 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 343 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", JoinPointGenerator.EMPTY_CTCLASS_ARRAY), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addInvokeJoinPointDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 350 */       String body = "{ return null;}";
/*     */       try
/*     */       {
/* 355 */         CtMethod dispatch = CtNewMethod.make(CtClass.voidType, "dispatch", this.params, this.advisedCtor.getExceptionTypes(), body, this.jp);
/*     */ 
/* 362 */         dispatch.setModifiers(4);
/* 363 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 367 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.ConstructionJoinPointGenerator
 * JD-Core Version:    0.6.0
 */